/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned.rss.expanded;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import com.dcloud.zxing2.oned.rss.AbstractRSSReader;
import com.dcloud.zxing2.oned.rss.DataCharacter;
import com.dcloud.zxing2.oned.rss.FinderPattern;
import com.dcloud.zxing2.oned.rss.RSSUtils;
import com.dcloud.zxing2.oned.rss.expanded.BitArrayBuilder;
import com.dcloud.zxing2.oned.rss.expanded.ExpandedPair;
import com.dcloud.zxing2.oned.rss.expanded.ExpandedRow;
import com.dcloud.zxing2.oned.rss.expanded.decoders.AbstractExpandedDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM = new int[]{0, 348, 1388, 2948, 3988};
    private static final int[][] FINDER_PATTERNS;
    private static final int[][] WEIGHTS;
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES;
    private static final int MAX_PAIRS = 11;
    private final List<ExpandedPair> pairs = new ArrayList<ExpandedPair>(11);
    private final List<ExpandedRow> rows = new ArrayList<ExpandedRow>();
    private final int[] startEnd = new int[2];
    private boolean startFromEven;

    private List<ExpandedPair> checkRows(boolean bl) {
        if (this.rows.size() > 25) {
            this.rows.clear();
            return null;
        }
        this.pairs.clear();
        if (bl) {
            Collections.reverse(this.rows);
        }
        List<ExpandedPair> list = null;
        try {
            list = this.checkRows(new ArrayList<ExpandedRow>(), 0);
        }
        catch (NotFoundException notFoundException) {}
        if (bl) {
            Collections.reverse(this.rows);
        }
        return list;
    }

    private List<ExpandedPair> checkRows(List<ExpandedRow> list, int n2) throws NotFoundException {
        while (n2 < this.rows.size()) {
            RSSExpandedReader rSSExpandedReader = this;
            ExpandedRow expandedRow = rSSExpandedReader.rows.get(n2);
            rSSExpandedReader.pairs.clear();
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.pairs.addAll(list.get(i2).getPairs());
            }
            RSSExpandedReader rSSExpandedReader2 = this;
            rSSExpandedReader2.pairs.addAll(expandedRow.getPairs());
            if (RSSExpandedReader.isValidSequence(rSSExpandedReader2.pairs)) {
                ArrayList<ExpandedRow> arrayList;
                if (this.checkChecksum()) {
                    return this.pairs;
                }
                ArrayList<ExpandedRow> arrayList2 = arrayList;
                arrayList2();
                arrayList2.addAll(list);
                arrayList2.add(expandedRow);
                try {
                    return this.checkRows(arrayList, n2 + 1);
                }
                catch (NotFoundException notFoundException) {}
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean isValidSequence(List<ExpandedPair> list) {
        int[][] nArray = FINDER_PATTERN_SEQUENCES;
        int n2 = FINDER_PATTERN_SEQUENCES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int[] nArray2 = nArray[i2];
            if (list.size() > nArray2.length) continue;
            boolean bl = true;
            for (int i3 = 0; i3 < list.size(); ++i3) {
                if (list.get(i3).getFinderPattern().getValue() == nArray2[i3]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private void storeRow(int n2, boolean bl) {
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n3 = 0; n3 < this.rows.size(); ++n3) {
            ExpandedRow expandedRow = this.rows.get(n3);
            if (expandedRow.getRowNumber() > n2) {
                bl3 = expandedRow.isEquivalent(this.pairs);
                break;
            }
            bl2 = expandedRow.isEquivalent(this.pairs);
        }
        if (!bl3 && !bl2) {
            ExpandedRow expandedRow;
            if (RSSExpandedReader.isPartialRow(this.pairs, this.rows)) {
                return;
            }
            RSSExpandedReader rSSExpandedReader = this;
            ExpandedRow expandedRow2 = expandedRow;
            expandedRow = new ExpandedRow(this.pairs, n2, bl);
            rSSExpandedReader.rows.add(n3, expandedRow2);
            RSSExpandedReader.removePartialRows(rSSExpandedReader.pairs, this.rows);
            return;
        }
    }

    private static void removePartialRows(List<ExpandedPair> list, List<ExpandedRow> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ExpandedRow expandedRow = (ExpandedRow)object.next();
            if (expandedRow.getPairs().size() == list.size()) continue;
            boolean bl = true;
            for (ExpandedPair expandedPair : expandedRow.getPairs()) {
                boolean bl2 = false;
                Iterator<ExpandedPair> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!expandedPair.equals(iterator.next())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object.remove();
        }
    }

    private static boolean isPartialRow(Iterable<ExpandedPair> iterable, Iterable<ExpandedRow> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ExpandedRow expandedRow = (ExpandedRow)object.next();
            boolean bl = true;
            for (ExpandedPair expandedPair : iterable) {
                boolean bl2 = false;
                Iterator<ExpandedPair> iterator = expandedRow.getPairs().iterator();
                while (iterator.hasNext()) {
                    if (!expandedPair.equals(iterator.next())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    static Result constructResult(List<ExpandedPair> resultPointArray) throws NotFoundException, FormatException {
        List<ExpandedPair> list = resultPointArray;
        resultPointArray = AbstractExpandedDecoder.createDecoder(BitArrayBuilder.buildBitArray(list)).parseInformation();
        Object object = list.get(0).getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = list.get(list.size() - 1).getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray3 = resultPointArray;
        ResultPoint[] resultPointArray4 = new ResultPoint[4];
        resultPointArray = resultPointArray4;
        resultPointArray[0] = object[0];
        resultPointArray[1] = object[1];
        resultPointArray[2] = resultPointArray2[0];
        resultPointArray4[3] = resultPointArray2[1];
        object = BarcodeFormat.RSS_EXPANDED;
        return new Result((String)resultPointArray3, null, resultPointArray, (BarcodeFormat)((Object)object));
    }

    private boolean checkChecksum() {
        ExpandedPair expandedPair = this.pairs.get(0);
        DataCharacter dataCharacter = expandedPair.getLeftChar();
        DataCharacter dataCharacter2 = expandedPair.getRightChar();
        if (dataCharacter2 == null) {
            return false;
        }
        int n2 = dataCharacter2.getChecksumPortion();
        int n3 = 2;
        for (int i2 = 1; i2 < this.pairs.size(); ++i2) {
            ExpandedPair expandedPair2 = this.pairs.get(i2);
            n2 += expandedPair2.getLeftChar().getChecksumPortion();
            ++n3;
            DataCharacter dataCharacter3 = expandedPair2.getRightChar();
            if (dataCharacter3 == null) continue;
            n2 += dataCharacter3.getChecksumPortion();
            ++n3;
        }
        int n4 = n2 % 211;
        return (n3 - 4) * 211 + n4 == dataCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray bitArray, int n2) {
        int n3;
        if (bitArray.get(n2)) {
            BitArray bitArray2 = bitArray;
            n3 = bitArray2.getNextSet(bitArray2.getNextUnset(n2));
        } else {
            BitArray bitArray3 = bitArray;
            n3 = bitArray3.getNextUnset(bitArray3.getNextSet(n2));
        }
        return n3;
    }

    private void findNextPair(BitArray bitArray, List<ExpandedPair> list, int n2) throws NotFoundException {
        int[] nArray = this.getDecodeFinderCounters();
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n3 = bitArray.getSize();
        if (n2 < 0) {
            if (list.isEmpty()) {
                n2 = 0;
            } else {
                List<ExpandedPair> list2 = list;
                n2 = list2.get(list2.size() - 1).getFinderPattern().getStartEnd()[1];
            }
        }
        boolean bl = list.size() % 2 != 0;
        if (this.startFromEven) {
            bl ^= true;
        }
        int n4 = 0;
        while (n2 < n3 && (n4 = bitArray.get(n2) ^ 1) != 0) {
            ++n2;
        }
        int n5 = 0;
        int n6 = n4;
        n4 = n2;
        int n7 = n5;
        n5 = n6;
        while (n2 < n3) {
            if ((bitArray.get(n2) ^ n5) != 0) {
                nArray2[n7] = nArray2[n7] + 1;
            } else {
                if (n7 == 3) {
                    if (bl) {
                        RSSExpandedReader.reverseCounters(nArray2);
                    }
                    if (AbstractRSSReader.isFinderPattern(nArray2)) {
                        this.startEnd[0] = n4;
                        this.startEnd[1] = n2;
                        return;
                    }
                    if (bl) {
                        RSSExpandedReader.reverseCounters(nArray2);
                    }
                    int[] nArray3 = nArray2;
                    int[] nArray4 = nArray2;
                    n4 += nArray2[0] + nArray2[1];
                    nArray4[0] = nArray3[2];
                    nArray4[1] = nArray3[3];
                    nArray3[2] = 0;
                    nArray4[3] = 0;
                    --n7;
                } else {
                    ++n7;
                }
                nArray2[n7] = 1;
                n5 ^= 1;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            int n3 = nArray[i2];
            int n4 = n2 - i2 - 1;
            nArray[i2] = nArray[n4];
            nArray[n4] = n3;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n2, boolean n3) {
        int n4;
        int n5;
        int n6;
        if (n3 != 0) {
            for (n3 = ((RSSExpandedReader)object).startEnd[0] - 1; n3 >= 0 && !bitArray.get(n3); --n3) {
            }
            n6 = n3 + 1;
            n3 = ((RSSExpandedReader)object).startEnd[0] - n6;
            n5 = ((RSSExpandedReader)object).startEnd[1];
        } else {
            n6 = ((RSSExpandedReader)object).startEnd[0];
            n5 = bitArray.getNextUnset(((RSSExpandedReader)object).startEnd[1] + 1);
            n3 = n5 - ((RSSExpandedReader)object).startEnd[1];
        }
        int[] nArray = ((AbstractRSSReader)object).getDecodeFinderCounters();
        Object object = nArray;
        int n7 = nArray.length - 1;
        System.arraycopy(nArray, 0, object, 1, n7);
        nArray[0] = n3;
        try {
            n4 = AbstractRSSReader.parseFinderValue(nArray, FINDER_PATTERNS);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        int[] nArray2 = new int[2];
        int[] nArray3 = nArray2;
        nArray2[0] = n6;
        nArray2[1] = n5;
        return new FinderPattern(n4, nArray3, n6, n5, n2);
    }

    private static boolean isNotA1left(FinderPattern finderPattern, boolean bl, boolean bl2) {
        return finderPattern.getValue() != 0 || !bl || !bl2;
    }

    private void adjustOddEvenCounts(int n2) throws NotFoundException {
        block28: {
            block31: {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block22: {
                    boolean bl5;
                    block29: {
                        block30: {
                            boolean bl6;
                            int n3;
                            int n4;
                            block24: {
                                block27: {
                                    block25: {
                                        block26: {
                                            block19: {
                                                block23: {
                                                    block20: {
                                                        block21: {
                                                            n4 = AbstractRSSReader.count(this.getOddCounts());
                                                            n3 = AbstractRSSReader.count(this.getEvenCounts());
                                                            n2 = n4 + n3 - n2;
                                                            bl6 = (n4 & 1) == 1;
                                                            bl5 = (n3 & 1) == 0;
                                                            bl4 = false;
                                                            bl3 = false;
                                                            if (n4 > 13) {
                                                                bl3 = true;
                                                            } else if (n4 < 4) {
                                                                bl4 = true;
                                                            }
                                                            bl2 = false;
                                                            bl = false;
                                                            if (n3 > 13) {
                                                                bl = true;
                                                            } else if (n3 < 4) {
                                                                bl2 = true;
                                                            }
                                                            if (n2 != 1) break block19;
                                                            if (!bl6) break block20;
                                                            if (bl5) break block21;
                                                            bl3 = true;
                                                            break block22;
                                                        }
                                                        throw NotFoundException.getNotFoundInstance();
                                                    }
                                                    if (!bl5) break block23;
                                                    bl = true;
                                                    break block22;
                                                }
                                                throw NotFoundException.getNotFoundInstance();
                                            }
                                            if (n2 != -1) break block24;
                                            if (!bl6) break block25;
                                            if (bl5) break block26;
                                            bl4 = true;
                                            break block22;
                                        }
                                        throw NotFoundException.getNotFoundInstance();
                                    }
                                    if (!bl5) break block27;
                                    bl2 = true;
                                    break block22;
                                }
                                throw NotFoundException.getNotFoundInstance();
                            }
                            if (n2 != 0) break block28;
                            if (!bl6) break block29;
                            if (!bl5) break block30;
                            if (n4 < n3) {
                                bl4 = true;
                                bl = true;
                            } else {
                                bl3 = true;
                                bl2 = true;
                            }
                            break block22;
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    if (bl5) break block31;
                }
                if (bl4) {
                    if (!bl3) {
                        AbstractRSSReader.increment(this.getOddCounts(), this.getOddRoundingErrors());
                    } else {
                        throw NotFoundException.getNotFoundInstance();
                    }
                }
                if (bl3) {
                    AbstractRSSReader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
                }
                if (bl2) {
                    if (!bl) {
                        AbstractRSSReader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
                    } else {
                        throw NotFoundException.getNotFoundInstance();
                    }
                }
                if (bl) {
                    AbstractRSSReader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
                }
                return;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[3] = 1;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[4];
        nArray2 = nArray3;
        nArray3[0] = 3;
        nArray3[1] = 6;
        nArray3[2] = 4;
        nArray3[3] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray4 = new int[4];
        nArray2 = nArray4;
        nArray4[0] = 3;
        nArray4[1] = 4;
        nArray4[2] = 6;
        nArray4[3] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray5 = new int[4];
        nArray2 = nArray5;
        nArray5[0] = 3;
        nArray5[1] = 2;
        nArray5[2] = 8;
        nArray5[3] = 1;
        nArrayArray[3] = nArray2;
        int[] nArray6 = new int[4];
        nArray2 = nArray6;
        nArray6[0] = 2;
        nArray6[1] = 6;
        nArray6[2] = 5;
        nArray6[3] = 1;
        nArrayArray[4] = nArray2;
        int[] nArray7 = new int[4];
        nArray2 = nArray7;
        nArray7[0] = 2;
        nArray7[1] = 2;
        nArray7[2] = 9;
        nArray7[3] = 1;
        nArrayArray[5] = nArray2;
        FINDER_PATTERNS = nArrayArray;
        int[][] nArrayArray2 = new int[23][];
        int[] nArray8 = new int[8];
        nArray2 = nArray8;
        nArray8[0] = 1;
        nArray8[1] = 3;
        nArray8[2] = 9;
        nArray8[3] = 27;
        nArray8[4] = 81;
        nArray8[5] = 32;
        nArray8[6] = 96;
        nArray8[7] = 77;
        nArrayArray2[0] = nArray2;
        int[] nArray9 = new int[8];
        nArray2 = nArray9;
        nArray9[0] = 20;
        nArray9[1] = 60;
        nArray9[2] = 180;
        nArray9[3] = 118;
        nArray9[4] = 143;
        nArray9[5] = 7;
        nArray9[6] = 21;
        nArray9[7] = 63;
        nArrayArray2[1] = nArray2;
        int[] nArray10 = new int[8];
        nArray2 = nArray10;
        nArray10[0] = 189;
        nArray10[1] = 145;
        nArray10[2] = 13;
        nArray10[3] = 39;
        nArray10[4] = 117;
        nArray10[5] = 140;
        nArray10[6] = 209;
        nArray10[7] = 205;
        nArrayArray2[2] = nArray2;
        int[] nArray11 = new int[8];
        nArray2 = nArray11;
        nArray11[0] = 193;
        nArray11[1] = 157;
        nArray11[2] = 49;
        nArray11[3] = 147;
        nArray11[4] = 19;
        nArray11[5] = 57;
        nArray11[6] = 171;
        nArray11[7] = 91;
        nArrayArray2[3] = nArray2;
        int[] nArray12 = new int[8];
        nArray2 = nArray12;
        nArray12[0] = 62;
        nArray12[1] = 186;
        nArray12[2] = 136;
        nArray12[3] = 197;
        nArray12[4] = 169;
        nArray12[5] = 85;
        nArray12[6] = 44;
        nArray12[7] = 132;
        nArrayArray2[4] = nArray2;
        int[] nArray13 = new int[8];
        nArray2 = nArray13;
        nArray13[0] = 185;
        nArray13[1] = 133;
        nArray13[2] = 188;
        nArray13[3] = 142;
        nArray13[4] = 4;
        nArray13[5] = 12;
        nArray13[6] = 36;
        nArray13[7] = 108;
        nArrayArray2[5] = nArray2;
        int[] nArray14 = new int[8];
        nArray2 = nArray14;
        nArray14[0] = 113;
        nArray14[1] = 128;
        nArray14[2] = 173;
        nArray14[3] = 97;
        nArray14[4] = 80;
        nArray14[5] = 29;
        nArray14[6] = 87;
        nArray14[7] = 50;
        nArrayArray2[6] = nArray2;
        int[] nArray15 = new int[8];
        nArray2 = nArray15;
        nArray15[0] = 150;
        nArray15[1] = 28;
        nArray15[2] = 84;
        nArray15[3] = 41;
        nArray15[4] = 123;
        nArray15[5] = 158;
        nArray15[6] = 52;
        nArray15[7] = 156;
        nArrayArray2[7] = nArray2;
        int[] nArray16 = new int[8];
        nArray2 = nArray16;
        nArray16[0] = 46;
        nArray16[1] = 138;
        nArray16[2] = 203;
        nArray16[3] = 187;
        nArray16[4] = 139;
        nArray16[5] = 206;
        nArray16[6] = 196;
        nArray16[7] = 166;
        nArrayArray2[8] = nArray2;
        int[] nArray17 = new int[8];
        nArray2 = nArray17;
        nArray17[0] = 76;
        nArray17[1] = 17;
        nArray17[2] = 51;
        nArray17[3] = 153;
        nArray17[4] = 37;
        nArray17[5] = 111;
        nArray17[6] = 122;
        nArray17[7] = 155;
        nArrayArray2[9] = nArray2;
        int[] nArray18 = new int[8];
        nArray2 = nArray18;
        nArray18[0] = 43;
        nArray18[1] = 129;
        nArray18[2] = 176;
        nArray18[3] = 106;
        nArray18[4] = 107;
        nArray18[5] = 110;
        nArray18[6] = 119;
        nArray18[7] = 146;
        nArrayArray2[10] = nArray2;
        int[] nArray19 = new int[8];
        nArray2 = nArray19;
        nArray19[0] = 16;
        nArray19[1] = 48;
        nArray19[2] = 144;
        nArray19[3] = 10;
        nArray19[4] = 30;
        nArray19[5] = 90;
        nArray19[6] = 59;
        nArray19[7] = 177;
        nArrayArray2[11] = nArray2;
        int[] nArray20 = new int[8];
        nArray2 = nArray20;
        nArray20[0] = 109;
        nArray20[1] = 116;
        nArray20[2] = 137;
        nArray20[3] = 200;
        nArray20[4] = 178;
        nArray20[5] = 112;
        nArray20[6] = 125;
        nArray20[7] = 164;
        nArrayArray2[12] = nArray2;
        int[] nArray21 = new int[8];
        nArray2 = nArray21;
        nArray21[0] = 70;
        nArray21[1] = 210;
        nArray21[2] = 208;
        nArray21[3] = 202;
        nArray21[4] = 184;
        nArray21[5] = 130;
        nArray21[6] = 179;
        nArray21[7] = 115;
        nArrayArray2[13] = nArray2;
        int[] nArray22 = new int[8];
        nArray2 = nArray22;
        nArray22[0] = 134;
        nArray22[1] = 191;
        nArray22[2] = 151;
        nArray22[3] = 31;
        nArray22[4] = 93;
        nArray22[5] = 68;
        nArray22[6] = 204;
        nArray22[7] = 190;
        nArrayArray2[14] = nArray2;
        int[] nArray23 = new int[8];
        nArray2 = nArray23;
        nArray23[0] = 148;
        nArray23[1] = 22;
        nArray23[2] = 66;
        nArray23[3] = 198;
        nArray23[4] = 172;
        nArray23[5] = 94;
        nArray23[6] = 71;
        nArray23[7] = 2;
        nArrayArray2[15] = nArray2;
        int[] nArray24 = new int[8];
        nArray2 = nArray24;
        nArray24[0] = 6;
        nArray24[1] = 18;
        nArray24[2] = 54;
        nArray24[3] = 162;
        nArray24[4] = 64;
        nArray24[5] = 192;
        nArray24[6] = 154;
        nArray24[7] = 40;
        nArrayArray2[16] = nArray2;
        int[] nArray25 = new int[8];
        nArray2 = nArray25;
        nArray25[0] = 120;
        nArray25[1] = 149;
        nArray25[2] = 25;
        nArray25[3] = 75;
        nArray25[4] = 14;
        nArray25[5] = 42;
        nArray25[6] = 126;
        nArray25[7] = 167;
        nArrayArray2[17] = nArray2;
        int[] nArray26 = new int[8];
        nArray2 = nArray26;
        nArray26[0] = 79;
        nArray26[1] = 26;
        nArray26[2] = 78;
        nArray26[3] = 23;
        nArray26[4] = 69;
        nArray26[5] = 207;
        nArray26[6] = 199;
        nArray26[7] = 175;
        nArrayArray2[18] = nArray2;
        int[] nArray27 = new int[8];
        nArray2 = nArray27;
        nArray27[0] = 103;
        nArray27[1] = 98;
        nArray27[2] = 83;
        nArray27[3] = 38;
        nArray27[4] = 114;
        nArray27[5] = 131;
        nArray27[6] = 182;
        nArray27[7] = 124;
        nArrayArray2[19] = nArray2;
        int[] nArray28 = new int[8];
        nArray2 = nArray28;
        nArray28[0] = 161;
        nArray28[1] = 61;
        nArray28[2] = 183;
        nArray28[3] = 127;
        nArray28[4] = 170;
        nArray28[5] = 88;
        nArray28[6] = 53;
        nArray28[7] = 159;
        nArrayArray2[20] = nArray2;
        int[] nArray29 = new int[8];
        nArray2 = nArray29;
        nArray29[0] = 55;
        nArray29[1] = 165;
        nArray29[2] = 73;
        nArray29[3] = 8;
        nArray29[4] = 24;
        nArray29[5] = 72;
        nArray29[6] = 5;
        nArray29[7] = 15;
        nArrayArray2[21] = nArray2;
        int[] nArray30 = new int[8];
        nArray2 = nArray30;
        nArray30[0] = 45;
        nArray30[1] = 135;
        nArray30[2] = 194;
        nArray30[3] = 160;
        nArray30[4] = 58;
        nArray30[5] = 174;
        nArray30[6] = 100;
        nArray30[7] = 89;
        nArrayArray2[22] = nArray2;
        WEIGHTS = nArrayArray2;
        int[][] nArrayArray3 = new int[10][];
        int[] nArray31 = new int[2];
        nArray2 = nArray31;
        nArray31[0] = 0;
        nArray31[1] = 0;
        nArrayArray3[0] = nArray2;
        int[] nArray32 = new int[3];
        nArray2 = nArray32;
        nArray32[0] = 0;
        nArray32[1] = 1;
        nArray32[2] = 1;
        nArrayArray3[1] = nArray2;
        int[] nArray33 = new int[4];
        nArray2 = nArray33;
        nArray33[0] = 0;
        nArray33[1] = 2;
        nArray33[2] = 1;
        nArray33[3] = 3;
        nArrayArray3[2] = nArray2;
        int[] nArray34 = new int[5];
        nArray2 = nArray34;
        nArray34[0] = 0;
        nArray34[1] = 4;
        nArray34[2] = 1;
        nArray34[3] = 3;
        nArray34[4] = 2;
        nArrayArray3[3] = nArray2;
        int[] nArray35 = new int[6];
        nArray2 = nArray35;
        nArray35[0] = 0;
        nArray35[1] = 4;
        nArray35[2] = 1;
        nArray35[3] = 3;
        nArray35[4] = 3;
        nArray35[5] = 5;
        nArrayArray3[4] = nArray2;
        int[] nArray36 = new int[7];
        nArray2 = nArray36;
        nArray36[0] = 0;
        nArray36[1] = 4;
        nArray36[2] = 1;
        nArray36[3] = 3;
        nArray36[4] = 4;
        nArray36[5] = 5;
        nArray36[6] = 5;
        nArrayArray3[5] = nArray2;
        int[] nArray37 = new int[8];
        nArray2 = nArray37;
        nArray37[0] = 0;
        nArray37[1] = 0;
        nArray37[2] = 1;
        nArray37[3] = 1;
        nArray37[4] = 2;
        nArray37[5] = 2;
        nArray37[6] = 3;
        nArray37[7] = 3;
        nArrayArray3[6] = nArray2;
        int[] nArray38 = new int[9];
        nArray2 = nArray38;
        nArray38[0] = 0;
        nArray38[1] = 0;
        nArray38[2] = 1;
        nArray38[3] = 1;
        nArray38[4] = 2;
        nArray38[5] = 2;
        nArray38[6] = 3;
        nArray38[7] = 4;
        nArray38[8] = 4;
        nArrayArray3[7] = nArray2;
        int[] nArray39 = new int[10];
        nArray2 = nArray39;
        nArray39[0] = 0;
        nArray39[1] = 0;
        nArray39[2] = 1;
        nArray39[3] = 1;
        nArray39[4] = 2;
        nArray39[5] = 2;
        nArray39[6] = 3;
        nArray39[7] = 4;
        nArray39[8] = 5;
        nArray39[9] = 5;
        nArrayArray3[8] = nArray2;
        int[] nArray40 = new int[11];
        nArray2 = nArray40;
        nArray40[0] = 0;
        nArray40[1] = 0;
        nArray40[2] = 1;
        nArray40[3] = 1;
        nArray40[4] = 2;
        nArray40[5] = 3;
        nArray40[6] = 3;
        nArray40[7] = 4;
        nArray40[8] = 4;
        nArray40[9] = 5;
        nArray40[10] = 5;
        nArrayArray3[9] = nArray2;
        FINDER_PATTERN_SEQUENCES = nArrayArray3;
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        this.pairs.clear();
        this.startFromEven = false;
        try {
            return RSSExpandedReader.constructResult(this.decodeRow2pairs(n2, bitArray));
        }
        catch (NotFoundException notFoundException) {
            this.pairs.clear();
            this.startFromEven = true;
            return RSSExpandedReader.constructResult(this.decodeRow2pairs(n2, bitArray));
        }
    }

    @Override
    public void reset() {
        RSSExpandedReader rSSExpandedReader = this;
        rSSExpandedReader.pairs.clear();
        rSSExpandedReader.rows.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<ExpandedPair> decodeRow2pairs(int n2, BitArray bitArray) throws NotFoundException {
        try {
            while (true) {
                RSSExpandedReader rSSExpandedReader = this;
                ExpandedPair expandedPair = rSSExpandedReader.retrieveNextPair(bitArray, ((RSSExpandedReader)this).pairs, n2);
                rSSExpandedReader.pairs.add(expandedPair);
            }
        }
        catch (NotFoundException notFoundException) {
            if (((RSSExpandedReader)this).pairs.isEmpty()) {
                throw notFoundException;
            }
            if (((RSSExpandedReader)this).checkChecksum()) {
                return ((RSSExpandedReader)this).pairs;
            }
            boolean bl = ((RSSExpandedReader)this).rows.isEmpty() ^ true;
            ((RSSExpandedReader)this).storeRow(n2, false);
            if (bl) {
                List<ExpandedPair> list = ((RSSExpandedReader)this).checkRows(false);
                if (list != null) {
                    return list;
                }
                if ((this = ((RSSExpandedReader)this).checkRows(true)) != null) {
                    return this;
                }
            }
            throw NotFoundException.getNotFoundInstance();
        }
    }

    List<ExpandedRow> getRows() {
        return this.rows;
    }

    ExpandedPair retrieveNextPair(BitArray bitArray, List<ExpandedPair> list, int n2) throws NotFoundException {
        Object object;
        FinderPattern finderPattern;
        boolean bl = list.size() % 2 == 0;
        if (((RSSExpandedReader)object).startFromEven) {
            bl ^= true;
        }
        boolean bl2 = true;
        int n3 = -1;
        do {
            RSSExpandedReader rSSExpandedReader = object;
            rSSExpandedReader.findNextPair(bitArray, list, n3);
            finderPattern = rSSExpandedReader.parseFoundFinderPattern(bitArray, n2, bl);
            if (finderPattern == null) {
                n3 = RSSExpandedReader.getNextSecondBar(bitArray, ((RSSExpandedReader)object).startEnd[0]);
                continue;
            }
            bl2 = false;
        } while (bl2);
        DataCharacter dataCharacter = ((RSSExpandedReader)object).decodeDataCharacter(bitArray, finderPattern, bl, true);
        if (!list.isEmpty()) {
            List<ExpandedPair> list2 = list;
            if (list2.get(list2.size() - 1).mustBeLast()) {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        try {
            object = ((RSSExpandedReader)object).decodeDataCharacter(bitArray, finderPattern, bl, false);
        }
        catch (NotFoundException notFoundException) {
            object = null;
        }
        return new ExpandedPair(dataCharacter, (DataCharacter)object, finderPattern, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl, boolean bl2) throws NotFoundException {
        int n2;
        int[] nArray = this.getDataCharacterCounters();
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl2) {
            OneDReader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray2);
        } else {
            OneDReader.recordPattern(bitArray, finderPattern.getStartEnd()[1], nArray2);
            int n3 = 0;
            for (int i2 = nArray2.length - 1; n3 < i2; ++n3, --i2) {
                int[] nArray3 = nArray2;
                int[] nArray4 = nArray2;
                int n4 = nArray3[n3];
                nArray3[n3] = nArray4[i2];
                nArray4[i2] = n4;
            }
        }
        int n5 = 17;
        float f2 = (float)AbstractRSSReader.count(nArray2) / (float)n5;
        float f3 = (float)(finderPattern.getStartEnd()[1] - finderPattern.getStartEnd()[0]) / 15.0f;
        if (Math.abs(f2 - f3) / f3 > 0.3f) throw NotFoundException.getNotFoundInstance();
        RSSExpandedReader rSSExpandedReader = this;
        int[] nArray5 = rSSExpandedReader.getOddCounts();
        int[] nArray6 = rSSExpandedReader.getEvenCounts();
        float[] fArray = rSSExpandedReader.getOddRoundingErrors();
        float[] fArray2 = rSSExpandedReader.getEvenRoundingErrors();
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            float f4 = (float)nArray2[i3] * 1.0f / f2;
            int n6 = (int)(f4 + 0.5f);
            if (n6 < 1) {
                if (f4 < 0.3f) throw NotFoundException.getNotFoundInstance();
                n6 = 1;
            } else if (n6 > 8) {
                if (f4 > 8.7f) throw NotFoundException.getNotFoundInstance();
                n6 = 8;
            }
            int n7 = i3;
            int n8 = n7 / 2;
            if ((n7 & 1) == 0) {
                nArray5[n8] = n6;
                fArray[n8] = f4 - (float)n6;
                continue;
            }
            nArray6[n8] = n6;
            fArray2[n8] = f4 - (float)n6;
        }
        this.adjustOddEvenCounts(n5);
        int n9 = finderPattern.getValue() * 4;
        n5 = bl ? 0 : 2;
        n9 = n9 + n5 + (bl2 ^ 1) - 1;
        n5 = 0;
        int n10 = 0;
        for (n2 = nArray5.length - 1; n2 >= 0; --n2) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) {
                int n11 = n10;
                n10 = WEIGHTS[n9][n2 * 2];
                n10 = n11 + nArray5[n2] * n10;
            }
            n5 += nArray5[n2];
        }
        n2 = 0;
        for (int i4 = nArray6.length - 1; i4 >= 0; --i4) {
            if (!RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) continue;
            int n12 = n2;
            n2 = WEIGHTS[n9][i4 * 2 + 1];
            n2 = n12 + nArray6[i4] * n2;
        }
        n9 = n10 + n2;
        if ((n5 & 1) != 0 || n5 > 13 || n5 < 4) throw NotFoundException.getNotFoundInstance();
        n5 = (13 - n5) / 2;
        int n13 = SYMBOL_WIDEST[n5];
        int n14 = 9 - n13;
        n14 = RSSUtils.getRSSvalue(nArray6, n14, false);
        int n15 = EVEN_TOTAL_SUBSET[n5];
        n5 = GSUM[n5];
        n5 = RSSUtils.getRSSvalue(nArray5, n13, true) * n15 + n14 + n5;
        return new DataCharacter(n5, n9);
    }
}

