/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ReaderException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.EANManufacturerOrgSupport;
import com.dcloud.zxing2.oned.OneDReader;
import com.dcloud.zxing2.oned.UPCEANExtensionSupport;
import java.util.Arrays;
import java.util.Map;

public abstract class UPCEANReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.48f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.7f;
    static final int[] START_END_PATTERN = new int[]{1, 1, 1};
    static final int[] MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
    static final int[] END_PATTERN = new int[]{1, 1, 1, 1, 1, 1};
    static final int[][] L_PATTERNS;
    static final int[][] L_AND_G_PATTERNS;
    private final StringBuilder decodeRowStringBuffer;
    private final UPCEANExtensionSupport extensionReader;
    private final EANManufacturerOrgSupport eanManSupport;

    protected UPCEANReader() {
        EANManufacturerOrgSupport eANManufacturerOrgSupport;
        UPCEANExtensionSupport uPCEANExtensionSupport;
        StringBuilder stringBuilder;
        Object object = stringBuilder;
        stringBuilder = new StringBuilder(20);
        v1.decodeRowStringBuffer = object;
        object = uPCEANExtensionSupport;
        uPCEANExtensionSupport = new UPCEANExtensionSupport();
        v1.extensionReader = object;
        object = eANManufacturerOrgSupport;
        eANManufacturerOrgSupport = new EANManufacturerOrgSupport();
        v1.eanManSupport = object;
    }

    static int[] findStartGuardPattern(BitArray bitArray) throws NotFoundException {
        boolean bl = false;
        int[] nArray = null;
        int n2 = 0;
        int[] nArray2 = new int[START_END_PATTERN.length];
        while (!bl) {
            nArray = START_END_PATTERN;
            Arrays.fill(nArray2, 0, START_END_PATTERN.length, 0);
            nArray = UPCEANReader.findGuardPattern(bitArray, n2, false, nArray, nArray2);
            n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = n2 - (n3 - n2);
            if (n4 >= 0) {
                bl = bitArray.isRange(n4, n2, false);
            }
            n2 = n3;
        }
        return nArray;
    }

    static boolean checkStandardUPCEANChecksum(CharSequence charSequence) throws FormatException {
        int n2;
        int n3 = charSequence.length();
        if (n3 == 0) {
            return false;
        }
        int n4 = 0;
        for (n2 = n3 - 2; n2 >= 0; n2 -= 2) {
            int n5 = charSequence.charAt(n2) - 48;
            if (n5 >= 0 && n5 <= 9) {
                n4 += n5;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        int n6 = n3;
        n3 = n4 * 3;
        for (n4 = (v17393) - 1; n4 >= 0; n4 -= 2) {
            n2 = charSequence.charAt(n4) - 48;
            if (n2 >= 0 && n2 <= 9) {
                n3 += n2;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        return n3 % 10 == 0;
    }

    static int[] findGuardPattern(BitArray object, int n2, boolean bl, int[] nArray) throws NotFoundException {
        BitArray bitArray = object;
        object = new int[nArray.length];
        return UPCEANReader.findGuardPattern(bitArray, n2, bl, nArray, (int[])object);
    }

    private static int[] findGuardPattern(BitArray bitArray, int n2, boolean n3, int[] nArray, int[] nArray2) throws NotFoundException {
        int n4 = nArray.length;
        int n5 = bitArray.getSize();
        n2 = n3 != 0 ? bitArray.getNextUnset(n2) : bitArray.getNextSet(n2);
        int n6 = 0;
        int n7 = n3;
        n3 = n2;
        int n8 = n6;
        n6 = n7;
        while (n2 < n5) {
            if (bitArray.get(n2) ^ n6) {
                nArray2[n8] = nArray2[n8] + 1;
            } else {
                int n9 = n4 - 1;
                if (n8 == n9) {
                    if (OneDReader.patternMatchVariance(nArray2, nArray, 0.7f) < 0.48f) {
                        return new int[]{n3, n2};
                    }
                    int n10 = n9;
                    n3 += nArray2[0] + nArray2[1];
                    n9 = n4 - 2;
                    System.arraycopy(nArray2, 2, nArray2, 0, n9);
                    nArray2[n9] = 0;
                    nArray2[n10] = 0;
                    --n8;
                } else {
                    ++n8;
                }
                nArray2[n8] = 1;
                n6 ^= 1;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int decodeDigit(BitArray bitArray, int[] nArray, int n2, int[][] nArray2) throws NotFoundException {
        OneDReader.recordPattern(bitArray, n2, nArray);
        float f2 = 0.48f;
        n2 = -1;
        int n3 = nArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            float f3;
            float f4 = OneDReader.patternMatchVariance(nArray, nArray2[i2], 0.7f);
            if (f3 < f2) {
                n2 = i2;
            } else {
                f4 = f2;
            }
            f2 = f4;
        }
        if (n2 >= 0) {
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[4];
        Object object = nArray;
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArrayArray[0] = object;
        int[] nArray2 = new int[4];
        object = nArray2;
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 1;
        nArrayArray[1] = object;
        int[] nArray3 = new int[4];
        object = nArray3;
        nArray3[0] = 2;
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 2;
        nArrayArray[2] = object;
        int[] nArray4 = new int[4];
        object = nArray4;
        nArray4[0] = 1;
        nArray4[1] = 4;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArrayArray[3] = object;
        int[] nArray5 = new int[4];
        object = nArray5;
        nArray5[0] = 1;
        nArray5[1] = 1;
        nArray5[2] = 3;
        nArray5[3] = 2;
        nArrayArray[4] = object;
        int[] nArray6 = new int[4];
        object = nArray6;
        nArray6[0] = 1;
        nArray6[1] = 2;
        nArray6[2] = 3;
        nArray6[3] = 1;
        nArrayArray[5] = object;
        int[] nArray7 = new int[4];
        object = nArray7;
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 4;
        nArrayArray[6] = object;
        int[] nArray8 = new int[4];
        object = nArray8;
        nArray8[0] = 1;
        nArray8[1] = 3;
        nArray8[2] = 1;
        nArray8[3] = 2;
        nArrayArray[7] = object;
        int[] nArray9 = new int[4];
        object = nArray9;
        nArray9[0] = 1;
        nArray9[1] = 2;
        nArray9[2] = 1;
        nArray9[3] = 3;
        nArrayArray[8] = object;
        int[] nArray10 = new int[4];
        object = nArray10;
        nArray10[0] = 3;
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[3] = 2;
        nArrayArray[9] = object;
        L_PATTERNS = nArrayArray;
        int[][] nArrayArray2 = new int[20][];
        object = nArrayArray2;
        L_AND_G_PATTERNS = nArrayArray2;
        System.arraycopy(nArrayArray, 0, object, 0, 10);
        for (int i2 = 10; i2 < 20; ++i2) {
            int[] nArray11 = L_PATTERNS[i2 - 10];
            int[] nArray12 = new int[nArray11.length];
            for (int i3 = 0; i3 < nArray11.length; ++i3) {
                nArray12[i3] = nArray11[nArray11.length - i3 - 1];
            }
            UPCEANReader.L_AND_G_PATTERNS[i2] = nArray12;
        }
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        return this.decodeRow(n2, bitArray, UPCEANReader.findStartGuardPattern(bitArray), map);
    }

    public Result decodeRow(int n2, BitArray object, int[] nArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n3;
        int n4;
        ResultPointCallback resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            float f2 = (float)(nArray[0] + nArray[1]) / 2.0f;
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(f2, n2));
        }
        UPCEANReader uPCEANReader = this;
        StringBuilder stringBuilder = uPCEANReader.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n5 = uPCEANReader.decodeMiddle((BitArray)object, nArray, stringBuilder);
        if (resultPointCallback != null) {
            ResultPoint resultPoint;
            ResultPoint resultPoint2 = resultPoint;
            float f3 = n5;
            resultPoint = new ResultPoint(f3, n2);
            resultPointCallback.foundPossibleResultPoint(resultPoint2);
        }
        int[] nArray2 = ((UPCEANReader)this).decodeEnd((BitArray)object, n5);
        if (resultPointCallback != null) {
            float f4 = (float)(nArray2[0] + nArray2[1]) / 2.0f;
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(f4, n2));
        }
        if ((n4 = (n3 = nArray2[1]) + (n3 - nArray2[0])) < object.getSize() && object.isRange(n3, n4, false)) {
            String string2 = stringBuilder.toString();
            if (string2.length() >= 8) {
                if (((UPCEANReader)this).checkChecksum(string2)) {
                    Result result;
                    ResultPoint resultPoint;
                    ResultPoint resultPoint3;
                    Result result2;
                    float f5 = (float)(nArray[1] + nArray[0]) / 2.0f;
                    float f6 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
                    BarcodeFormat barcodeFormat = ((UPCEANReader)this).getBarcodeFormat();
                    Result result3 = result2;
                    ResultPoint[] resultPointArray = new ResultPoint[2];
                    ResultPoint[] resultPointArray2 = resultPointArray;
                    ResultPoint resultPoint4 = resultPoint3;
                    float f7 = f5;
                    f5 = n2;
                    resultPoint3 = new ResultPoint(f7, f5);
                    resultPointArray[0] = resultPoint4;
                    resultPoint4 = resultPoint;
                    resultPoint = new ResultPoint(f6, f5);
                    resultPointArray[1] = resultPoint4;
                    result3(string2, null, resultPointArray2, barcodeFormat);
                    int n6 = 0;
                    try {
                        result = ((UPCEANReader)this).extensionReader.decodeRow(n2, (BitArray)object, nArray2[1]);
                    }
                    catch (ReaderException readerException) {}
                    object = ResultMetadataType.UPC_EAN_EXTENSION;
                    result2.putMetadata((ResultMetadataType)((Object)object), result.getText());
                    result2.putAllMetadata(result.getResultMetadata());
                    result2.addResultPoints(result.getResultPoints());
                    n6 = result.getText().length();
                    int[] nArray3 = map == null ? null : (int[])map.get((Object)DecodeHintType.ALLOWED_EAN_EXTENSIONS);
                    if (nArray3 != null) {
                        boolean bl = false;
                        int n7 = nArray3.length;
                        for (int i2 = 0; i2 < n7; ++i2) {
                            if (n6 != nArray3[i2]) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            throw NotFoundException.getNotFoundInstance();
                        }
                    }
                    if ((barcodeFormat == BarcodeFormat.EAN_13 || barcodeFormat == BarcodeFormat.UPC_A) && (this = ((UPCEANReader)this).eanManSupport.lookupCountryIdentifier(string2)) != null) {
                        result3.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, this);
                    }
                    return result3;
                }
                throw ChecksumException.getChecksumInstance();
            }
            throw FormatException.getFormatInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    boolean checkChecksum(String string2) throws FormatException {
        return UPCEANReader.checkStandardUPCEANChecksum(string2);
    }

    int[] decodeEnd(BitArray bitArray, int n2) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n2, false, START_END_PATTERN);
    }

    abstract BarcodeFormat getBarcodeFormat();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuilder var3) throws NotFoundException;
}

