/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class CodaBarReader
extends OneDReader {
    private static final float MAX_ACCEPTABLE = 2.0f;
    private static final float PADDING = 1.5f;
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final char[] STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private int[] counters = new int[80];
    private int counterLength = 0;

    private void setCounters(BitArray bitArray) throws NotFoundException {
        int n2;
        this.counterLength = 0;
        int n3 = bitArray.getNextUnset(0);
        if (n3 < (n2 = bitArray.getSize())) {
            boolean bl = true;
            int n4 = 0;
            while (n3 < n2) {
                if (bitArray.get(n3) ^ bl) {
                    ++n4;
                } else {
                    this.counterAppend(n4);
                    n4 = 1;
                    bl ^= true;
                }
                ++n3;
            }
            this.counterAppend(n4);
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private void counterAppend(int n2) {
        int[] nArray = ((CodaBarReader)object).counters;
        int n3 = ((CodaBarReader)object).counterLength;
        ((CodaBarReader)object).counters[n3] = n2;
        ((CodaBarReader)object).counterLength = n2 = n3 + 1;
        if (n2 >= nArray.length) {
            CodaBarReader codaBarReader = object;
            Object object = new int[n2 * 2];
            System.arraycopy(nArray, 0, object, 0, n2);
            codaBarReader.counters = (int[])object;
        }
    }

    private int findStartPattern() throws NotFoundException {
        for (int i2 = 1; i2 < this.counterLength; i2 += 2) {
            int n2 = this.toNarrowWidePattern(i2);
            if (n2 == -1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n2])) continue;
            n2 = 0;
            for (int i3 = i2; i3 < i2 + 7; ++i3) {
                n2 += this.counters[i3];
            }
            if (i2 != 1 && this.counters[i2 - 1] < n2 / 2) continue;
            return i2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static boolean arrayContains(char[] cArray, char c2) {
        if (cArray != null) {
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (cArray[i2] != c2) continue;
                return true;
            }
        }
        return false;
    }

    private int toNarrowWidePattern(int n2) {
        Object object;
        Object object2;
        int n3 = n2 + 7;
        if (n3 >= ((CodaBarReader)object3).counterLength) {
            return -1;
        }
        Object object3 = ((CodaBarReader)object3).counters;
        Object object4 = 0;
        Object object5 = Integer.MAX_VALUE;
        Object object6 = n2;
        while (object6 < n3) {
            object2 = object3[object6];
            if (object2 < object5) {
                object5 = object2;
            }
            if (object2 <= object4) {
                object2 = object4;
            }
            int n4 = object4 = object6 + 2;
            object4 = object2;
            object6 = n4;
        }
        object4 = (object5 + object4) / 2;
        object5 = 0;
        object6 = Integer.MAX_VALUE;
        for (object2 = (Object)(n2 + 1); object2 < n3; object2 += 2) {
            object = object3[object2];
            if (object < object6) {
                object6 = object;
            }
            if (object <= object5) {
                object = object5;
            }
            object5 = object;
        }
        n3 = (object6 + object5) / 2;
        object5 = 128;
        object6 = 0;
        for (object2 = (Object)false; object2 < 7; ++object2) {
            object = (object2 & 1) == 0 ? (Object)object4 : (Object)n3;
            object5 >>= 1;
            if (object3[n2 + object2] <= object) continue;
            object6 |= object5;
        }
        int n5 = 0;
        while (true) {
            int[] nArray = CHARACTER_ENCODINGS;
            if (n5 >= CHARACTER_ENCODINGS.length) break;
            if (nArray[n5] == object6) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        int n3;
        Arrays.fill(resultPointArray2.counters, 0);
        resultPointArray2.setCounters(bitArray);
        int n4 = resultPointArray2.findStartPattern();
        resultPointArray2.decodeRowResult.setLength(0);
        int n5 = n4;
        while ((n3 = resultPointArray2.toNarrowWidePattern(n5)) != -1) {
            resultPointArray2.decodeRowResult.append((char)n3);
            if ((resultPointArray2.decodeRowResult.length() <= 1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n3])) && (n5 += 8) < resultPointArray2.counterLength) continue;
            n3 = n5 - 1;
            int n6 = resultPointArray2.counters[n3];
            int n7 = 0;
            for (int i2 = -8; i2 < -1; ++i2) {
                n7 += resultPointArray2.counters[n5 + i2];
            }
            if (n5 < resultPointArray2.counterLength && n6 < n7 / 2) {
                throw NotFoundException.getNotFoundInstance();
            }
            resultPointArray2.validatePattern(n4);
            for (n5 = 0; n5 < resultPointArray2.decodeRowResult.length(); ++n5) {
                StringBuilder stringBuilder = resultPointArray2.decodeRowResult;
                stringBuilder.setCharAt(n5, ALPHABET[stringBuilder.charAt(n5)]);
            }
            n5 = resultPointArray2.decodeRowResult.charAt(0);
            char[] cArray = STARTEND_ENCODING;
            if (CodaBarReader.arrayContains(STARTEND_ENCODING, (char)n5)) {
                StringBuilder stringBuilder = resultPointArray2.decodeRowResult;
                if (CodaBarReader.arrayContains(cArray, stringBuilder.charAt(stringBuilder.length() - 1))) {
                    if (resultPointArray2.decodeRowResult.length() > 3) {
                        ResultPoint resultPoint;
                        ResultPoint resultPoint2;
                        if (map == null || !map.containsKey((Object)DecodeHintType.RETURN_CODABAR_START_END)) {
                            StringBuilder stringBuilder2 = resultPointArray2.decodeRowResult;
                            stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
                            resultPointArray2.decodeRowResult.deleteCharAt(0);
                        }
                        int n8 = 0;
                        for (n5 = 0; n5 < n4; ++n5) {
                            n8 += resultPointArray2.counters[n5];
                        }
                        float f2 = n8;
                        while (n4 < n3) {
                            n8 += resultPointArray2.counters[n4];
                            ++n4;
                        }
                        float f3 = n8;
                        ResultPoint[] resultPointArray = new ResultPoint[2];
                        ResultPoint[] resultPointArray2 = resultPointArray;
                        ResultPoint resultPoint3 = resultPoint2;
                        float f4 = n2;
                        resultPoint2 = new ResultPoint(f2, f4);
                        resultPointArray[0] = resultPoint3;
                        resultPoint3 = resultPoint;
                        resultPoint = new ResultPoint(f3, f4);
                        resultPointArray[1] = resultPoint3;
                        BarcodeFormat barcodeFormat = BarcodeFormat.CODABAR;
                        return new Result(resultPointArray2.decodeRowResult.toString(), null, resultPointArray2, barcodeFormat);
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    void validatePattern(int n2) throws NotFoundException {
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int[] nArray3 = new int[4];
        int[] nArray4 = nArray3;
        nArray3[0] = 0;
        nArray3[1] = 0;
        nArray3[2] = 0;
        nArray3[3] = 0;
        int n3 = this.decodeRowResult.length() - 1;
        int n4 = 0;
        int n5 = n2;
        while (true) {
            int n6 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n4)];
            for (int i2 = 6; i2 >= 0; --i2) {
                int n7 = n6;
                n6 = (i2 & 1) + (n6 & 1) * 2;
                nArray2[n6] = nArray2[n6] + this.counters[n5 + i2];
                nArray4[n6] = nArray4[n6] + 1;
                n6 = n7 >> 1;
            }
            if (n4 >= n3) {
                float[] fArray = new float[4];
                float[] fArray2 = new float[4];
                for (n4 = 0; n4 < 2; ++n4) {
                    fArray2[n4] = 0.0f;
                    n5 = n4 + 2;
                    fArray2[n5] = ((float)nArray2[n4] / (float)nArray4[n4] + (float)nArray2[n5] / (float)nArray4[n5]) / 2.0f;
                    fArray[n4] = fArray2[n5];
                    fArray[n5] = ((float)nArray2[n5] * 2.0f + 1.5f) / (float)nArray4[n5];
                }
                int n8 = 0;
                while (true) {
                    int n9 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n8)];
                    for (n4 = 6; n4 >= 0; --n4) {
                        float f2 = this.counters[n2 + n4];
                        n5 = (n4 & 1) + (n9 & 1) * 2;
                        if (!(f2 < fArray2[n5]) && !(f2 > fArray[n5])) {
                            n9 >>= 1;
                            continue;
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    if (n8 >= n3) {
                        return;
                    }
                    n2 += 8;
                    ++n8;
                }
            }
            n5 += 8;
            ++n4;
        }
    }
}

