/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.maxicode;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.maxicode.decoder.Decoder;
import java.util.Map;

public final class MaxiCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private static final int MATRIX_WIDTH = 30;
    private static final int MATRIX_HEIGHT = 33;
    private final Decoder decoder;

    public MaxiCodeReader() {
        Decoder decoder;
        Decoder decoder2 = decoder;
        decoder = new Decoder();
        v1.decoder = decoder2;
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getEnclosingRectangle();
        if (nArray != null) {
            BitMatrix bitMatrix2;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = nArray[3];
            BitMatrix bitMatrix3 = bitMatrix2;
            bitMatrix2 = new BitMatrix(30, 33);
            for (int i2 = 0; i2 < 33; ++i2) {
                int n6 = n3 + (i2 * n5 + n5 / 2) / 33;
                for (int i3 = 0; i3 < 30; ++i3) {
                    if (!bitMatrix.get(n2 + (i3 * n4 + n4 / 2 + (i2 & 1) * n4 / 2) / 30, n6)) continue;
                    bitMatrix3.set(i3, i2);
                }
            }
            return bitMatrix3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap resultPointArray, Map<DecodeHintType, ?> object) throws NotFoundException, ChecksumException, FormatException {
        if (object != null && object.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            Result result;
            MaxiCodeReader maxiCodeReader = object2;
            Object object2 = MaxiCodeReader.extractPureBits(resultPointArray.getBlackMatrix());
            DecoderResult decoderResult = maxiCodeReader.decoder.decode((BitMatrix)object2, (Map<DecodeHintType, ?>)object);
            object2 = decoderResult;
            resultPointArray = NO_POINTS;
            object = result;
            Object object3 = object2;
            object2 = ((DecoderResult)object3).getText();
            byte[] byArray = ((DecoderResult)object3).getRawBytes();
            Object object4 = object2;
            object2 = BarcodeFormat.MAXICODE;
            result = new Result((String)object4, byArray, resultPointArray, (BarcodeFormat)((Object)object2));
            object2 = decoderResult.getECLevel();
            if (object2 != null) {
                ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object2);
            }
            return object;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
    }
}

