/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.encoder;

import com.dcloud.zxing2.datamatrix.encoder.Encoder;
import com.dcloud.zxing2.datamatrix.encoder.EncoderContext;
import com.dcloud.zxing2.datamatrix.encoder.HighLevelEncoder;

class C40Encoder
implements Encoder {
    C40Encoder() {
    }

    private int backtrackOneCharacter(EncoderContext encoderContext, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n2) {
        EncoderContext encoderContext2 = encoderContext;
        StringBuilder stringBuilder3 = stringBuilder;
        int n3 = stringBuilder3.length();
        stringBuilder3.delete(n3 - n2, n3);
        --encoderContext2.pos;
        int n4 = this.encodeChar(encoderContext2.getCurrentChar(), stringBuilder2);
        encoderContext.resetSymbolInfo();
        return n4;
    }

    static void writeNextTriplet(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.writeCodewords(C40Encoder.encodeToCodewords(stringBuilder, 0));
        stringBuilder.delete(0, 3);
    }

    private static String encodeToCodewords(CharSequence charSequence, int n2) {
        char c2 = charSequence.charAt(n2);
        char c3 = charSequence.charAt(n2 + 1);
        n2 = charSequence.charAt(n2 + 2);
        int n3 = c2 * 1600 + c3 * 40 + n2 + 1;
        c3 = (char)(n3 / 256);
        n2 = (char)(n3 % 256);
        return new String(new char[]{c3, n2});
    }

    @Override
    public int getEncodingMode() {
        return 1;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            EncoderContext encoderContext2 = encoderContext;
            EncoderContext encoderContext3 = encoderContext;
            int n2 = encoderContext3.getCurrentChar();
            ++encoderContext3.pos;
            n2 = this.encodeChar((char)n2, stringBuilder2);
            int n3 = stringBuilder2.length() / 3 * 2;
            n3 = encoderContext2.getCodewordCount() + n3;
            encoderContext2.updateSymbolInfo(n3);
            n3 = encoderContext2.getSymbolInfo().getDataCapacity() - n3;
            if (!encoderContext2.hasMoreCharacters()) {
                StringBuilder stringBuilder3;
                StringBuilder stringBuilder4 = stringBuilder3;
                stringBuilder3 = new StringBuilder();
                if (stringBuilder2.length() % 3 == 2 && (n3 < 2 || n3 > 2)) {
                    n2 = this.backtrackOneCharacter(encoderContext, stringBuilder2, stringBuilder4, n2);
                }
                while (stringBuilder2.length() % 3 == 1 && (n2 <= 3 && n3 != 1 || n2 > 3)) {
                    n2 = this.backtrackOneCharacter(encoderContext, stringBuilder2, stringBuilder4, n2);
                }
                break;
            }
            if (stringBuilder2.length() % 3 != 0) continue;
            n2 = encoderContext.pos;
            n2 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), n2, this.getEncodingMode());
            if (n2 == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n2);
            break;
        }
        this.handleEOD(encoderContext, stringBuilder2);
    }

    void handleEOD(EncoderContext encoderContext, StringBuilder stringBuilder) {
        block13: {
            block11: {
                int n2;
                int n3;
                block12: {
                    block10: {
                        StringBuilder stringBuilder2 = stringBuilder;
                        n3 = stringBuilder2.length() / 3 * 2;
                        n2 = stringBuilder2.length() % 3;
                        EncoderContext encoderContext2 = encoderContext;
                        n3 = encoderContext2.getCodewordCount() + n3;
                        encoderContext2.updateSymbolInfo(n3);
                        n3 = encoderContext2.getSymbolInfo().getDataCapacity() - n3;
                        if (n2 != 2) break block10;
                        stringBuilder.append('\u0000');
                        while (stringBuilder.length() >= 3) {
                            C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
                        }
                        if (encoderContext.hasMoreCharacters()) {
                            encoderContext.writeCodeword('\u00fe');
                        }
                        break block11;
                    }
                    if (n3 != 1 || n2 != 1) break block12;
                    while (stringBuilder.length() >= 3) {
                        C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
                    }
                    if (encoderContext.hasMoreCharacters()) {
                        encoderContext.writeCodeword('\u00fe');
                    }
                    --encoderContext.pos;
                    break block11;
                }
                if (n2 != 0) break block13;
                while (stringBuilder.length() >= 3) {
                    C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
                }
                if (n3 > 0 || encoderContext.hasMoreCharacters()) {
                    encoderContext.writeCodeword('\u00fe');
                }
            }
            encoderContext.signalEncoderChange(0);
            return;
        }
        throw new IllegalStateException("Unexpected case. Please report!");
    }

    int encodeChar(char c2, StringBuilder stringBuilder) {
        if (c2 == ' ') {
            stringBuilder.append('\u0003');
            return 1;
        }
        if (c2 >= '0' && c2 <= '9') {
            stringBuilder.append((char)(c2 - 48 + 4));
            return 1;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            stringBuilder.append((char)(c2 - 65 + 14));
            return 1;
        }
        if (c2 >= '\u0000' && c2 <= '\u001f') {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append('\u0000');
            stringBuilder2.append(c2);
            return 2;
        }
        if (c2 >= '!' && c2 <= '/') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c2 - 33));
            return 2;
        }
        if (c2 >= ':' && c2 <= '@') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c2 - 58 + 15));
            return 2;
        }
        if (c2 >= '[' && c2 <= '_') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c2 - 91 + 22));
            return 2;
        }
        if (c2 >= '`' && c2 <= '\u007f') {
            stringBuilder.append('\u0002');
            stringBuilder.append((char)(c2 - 96));
            return 2;
        }
        if (c2 >= '\u0080') {
            stringBuilder.append("\u0001\u001e");
            return this.encodeChar((char)(c2 - 128), stringBuilder) + 2;
        }
        throw new IllegalArgumentException("Illegal character: " + c2);
    }
}

