/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.common.GridSampler;
import com.dcloud.zxing2.common.detector.MathUtils;
import com.dcloud.zxing2.common.detector.WhiteRectangleDetector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Detector {
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix bitMatrix) throws NotFoundException {
        WhiteRectangleDetector whiteRectangleDetector;
        ((Detector)((Object)whiteRectangleDetector2)).image = bitMatrix;
        WhiteRectangleDetector whiteRectangleDetector2 = whiteRectangleDetector;
        whiteRectangleDetector = new WhiteRectangleDetector(bitMatrix);
        v1.rectangleDetector = whiteRectangleDetector2;
    }

    private ResultPoint correctTopRightRectangular(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2, int n3) {
        ResultPoint resultPoint5;
        ResultPoint resultPoint6;
        ResultPoint resultPoint7 = resultPoint4;
        float f2 = (float)Detector.distance(resultPoint, resultPoint2) / (float)n2;
        int n4 = Detector.distance(resultPoint3, resultPoint4);
        float f3 = n4;
        float f4 = (resultPoint7.getX() - resultPoint3.getX()) / f3;
        f3 = (resultPoint7.getY() - resultPoint3.getY()) / f3;
        ResultPoint resultPoint8 = resultPoint6;
        resultPoint6 = new ResultPoint(resultPoint4.getX() + f2 * f4, resultPoint4.getY() + f2 * f3);
        f2 = (float)Detector.distance(resultPoint, resultPoint3) / (float)n3;
        int n5 = Detector.distance(resultPoint2, resultPoint4);
        ResultPoint resultPoint9 = resultPoint4;
        float f5 = n5;
        f4 = (resultPoint9.getX() - resultPoint2.getX()) / f5;
        f5 = (resultPoint9.getY() - resultPoint2.getY()) / f5;
        ResultPoint resultPoint10 = resultPoint5;
        resultPoint5 = new ResultPoint(resultPoint4.getX() + f2 * f4, resultPoint4.getY() + f2 * f5);
        if (!this.isValid(resultPoint8)) {
            if (this.isValid(resultPoint10)) {
                return resultPoint10;
            }
            return null;
        }
        if (!this.isValid(resultPoint10)) {
            return resultPoint8;
        }
        if (Math.abs(n2 - this.transitionsBetween(resultPoint3, resultPoint8).getTransitions()) + Math.abs(n3 - this.transitionsBetween(resultPoint2, resultPoint8).getTransitions()) <= Math.abs(n2 - this.transitionsBetween(resultPoint3, resultPoint10).getTransitions()) + Math.abs(n3 - this.transitionsBetween(resultPoint2, resultPoint10).getTransitions())) {
            return resultPoint8;
        }
        return resultPoint10;
    }

    private ResultPoint correctTopRight(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2) {
        ResultPoint resultPoint5;
        ResultPoint resultPoint6;
        ResultPoint resultPoint7 = resultPoint4;
        float f2 = n2;
        float f3 = (float)Detector.distance(resultPoint, resultPoint2) / f2;
        int n3 = Detector.distance(resultPoint3, resultPoint4);
        float f4 = n3;
        float f5 = (resultPoint7.getX() - resultPoint3.getX()) / f4;
        f4 = (resultPoint7.getY() - resultPoint3.getY()) / f4;
        ResultPoint resultPoint8 = resultPoint6;
        resultPoint6 = new ResultPoint(resultPoint4.getX() + f3 * f5, resultPoint4.getY() + f3 * f4);
        f2 = (float)Detector.distance(resultPoint, resultPoint3) / f2;
        int n4 = Detector.distance(resultPoint2, resultPoint4);
        ResultPoint resultPoint9 = resultPoint4;
        float f6 = n4;
        f4 = (resultPoint9.getX() - resultPoint2.getX()) / f6;
        f6 = (resultPoint9.getY() - resultPoint2.getY()) / f6;
        ResultPoint resultPoint10 = resultPoint5;
        resultPoint5 = new ResultPoint(resultPoint4.getX() + f2 * f4, resultPoint4.getY() + f2 * f6);
        if (!this.isValid(resultPoint8)) {
            if (this.isValid(resultPoint10)) {
                return resultPoint10;
            }
            return null;
        }
        if (!this.isValid(resultPoint10)) {
            return resultPoint8;
        }
        if (Math.abs(this.transitionsBetween(resultPoint3, resultPoint8).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint8).getTransitions()) <= Math.abs(this.transitionsBetween(resultPoint3, resultPoint10).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint10).getTransitions())) {
            resultPoint10 = resultPoint8;
        }
        return resultPoint10;
    }

    private boolean isValid(ResultPoint resultPoint) {
        return resultPoint.getX() >= 0.0f && resultPoint.getX() < (float)this.image.getWidth() && resultPoint.getY() > 0.0f && resultPoint.getY() < (float)this.image.getHeight();
    }

    private static int distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2));
    }

    private static void increment(Map<ResultPoint, Integer> map, ResultPoint resultPoint) {
        Integer n2 = map.get(resultPoint);
        n2 = n2 == null ? 1 : n2 + 1;
        map.put(resultPoint, n2);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2, int n3) throws NotFoundException {
        ResultPoint resultPoint5 = resultPoint2;
        ResultPoint resultPoint6 = resultPoint3;
        ResultPoint resultPoint7 = resultPoint4;
        ResultPoint resultPoint8 = resultPoint;
        float f2 = (float)n2 - 0.5f;
        float f3 = (float)n3 - 0.5f;
        float f4 = resultPoint8.getX();
        float f5 = resultPoint8.getY();
        float f6 = resultPoint7.getX();
        float f7 = resultPoint7.getY();
        float f8 = resultPoint6.getX();
        float f9 = resultPoint6.getY();
        float f10 = resultPoint5.getX();
        float f11 = resultPoint5.getY();
        return GridSampler.getInstance().sampleGrid(bitMatrix, n2, n3, 0.5f, 0.5f, f2, 0.5f, f2, f3, 0.5f, f3, f4, f5, f6, f7, f8, f9, f10, f11);
    }

    private ResultPointsAndTransitions transitionsBetween(ResultPoint resultPoint, ResultPoint resultPoint2) {
        ResultPoint resultPoint3 = resultPoint2;
        ResultPoint resultPoint4 = resultPoint;
        int n2 = (int)resultPoint4.getX();
        int n3 = (int)resultPoint4.getY();
        int n4 = (int)resultPoint3.getX();
        int n5 = (int)resultPoint3.getY();
        boolean bl = Math.abs(n5 - n3) > Math.abs(n4 - n2);
        if (!bl) {
            int n6 = n4;
            int n7 = n2;
            n2 = n3;
            n4 = n5;
            n3 = n7;
            n5 = n6;
        }
        int n8 = n4;
        int n9 = Math.abs(n5 - n3);
        int n10 = Math.abs(n8 - n2);
        int n11 = -n9 / 2;
        int n12 = n2 < n8 ? 1 : -1;
        int n13 = n3 < n5 ? 1 : -1;
        int n14 = 0;
        BitMatrix bitMatrix = this.image;
        int n15 = bl ? n2 : n3;
        int n16 = bl ? n3 : n2;
        int n17 = bitMatrix.get(n15, n16);
        while (n3 != n5) {
            BitMatrix bitMatrix2 = this.image;
            n16 = bl ? n2 : n3;
            int n18 = bl ? n3 : n2;
            int n19 = bitMatrix2.get(n16, n18);
            n15 = n19;
            if (n19 != n17) {
                ++n14;
            } else {
                n15 = n17;
            }
            if ((n11 += n10) > 0) {
                if (n2 == n4) break;
                n2 += n12;
                n11 -= n9;
            }
            n3 += n13;
            n17 = n15;
        }
        return new ResultPointsAndTransitions(resultPoint, resultPoint2, n14);
    }

    public DetectorResult detect() throws NotFoundException {
        HashMap<ResultPoint, Integer> hashMap;
        ArrayList<ResultPointsAndTransitions> arrayList;
        ResultPoint[] resultPointArray = ((Detector)object7).rectangleDetector.detect();
        ResultPoint resultPoint = resultPointArray[0];
        ResultPoint resultPoint2 = resultPointArray[1];
        ResultPoint resultPoint3 = resultPointArray[2];
        ResultPoint resultPoint4 = resultPointArray[3];
        Object object = arrayList;
        ((ArrayList)object)(4);
        object.add(((Detector)object7).transitionsBetween(resultPoint, resultPoint2));
        object.add(((Detector)object7).transitionsBetween(resultPoint, resultPoint3));
        object.add(((Detector)object7).transitionsBetween(resultPoint2, resultPoint4));
        arrayList.add(((Detector)object7).transitionsBetween(resultPoint3, resultPoint4));
        Collections.sort(arrayList, new ResultPointsAndTransitionsComparator());
        object = (ResultPointsAndTransitions)arrayList.get(0);
        Object object2 = (ResultPointsAndTransitions)arrayList.get(1);
        HashMap<ResultPoint, Integer> hashMap2 = hashMap;
        hashMap2();
        Detector.increment(hashMap2, ((ResultPointsAndTransitions)object).getFrom());
        Detector.increment(hashMap2, ((ResultPointsAndTransitions)object).getTo());
        Detector.increment(hashMap2, ((ResultPointsAndTransitions)object2).getFrom());
        Detector.increment(hashMap, ((ResultPointsAndTransitions)object2).getTo());
        object = null;
        object2 = null;
        Object object3 = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object4 = (ResultPoint)entry.getKey();
            if ((Integer)entry.getValue() == 2) {
                Object object5 = object;
                object2 = object3;
                object = object4;
                object4 = object5;
            } else if (object == null) {
                ResultPointsAndTransitions resultPointsAndTransitions = object2;
                object2 = object3;
                object = resultPointsAndTransitions;
            } else {
                Object object6 = object;
                ResultPointsAndTransitions resultPointsAndTransitions = object2;
                object2 = object4;
                object = resultPointsAndTransitions;
                object4 = object6;
            }
            object3 = object2;
            object2 = object;
            object = object4;
        }
        if (object != null && object2 != null && object3 != null) {
            Object object7;
            ResultPoint resultPoint5;
            ResultPoint[] resultPointArray2 = new ResultPoint[]{object, object2, object3};
            ResultPoint.orderBestPatterns(resultPointArray2);
            object = resultPointArray2[0];
            object2 = resultPointArray2[1];
            object3 = resultPointArray2[2];
            if (!hashMap2.containsKey(resultPoint)) {
                resultPoint4 = resultPoint;
            } else if (!hashMap2.containsKey(resultPoint2)) {
                resultPoint4 = resultPoint2;
            } else if (!hashMap2.containsKey(resultPoint3)) {
                resultPoint4 = resultPoint3;
            }
            int n2 = ((Detector)object7).transitionsBetween((ResultPoint)object3, resultPoint4).getTransitions();
            int n3 = ((Detector)object7).transitionsBetween((ResultPoint)object, resultPoint4).getTransitions();
            if ((n2 & 1) == 1) {
                ++n2;
            }
            n2 += 2;
            if ((n3 & 1) == 1) {
                ++n3;
            }
            if (n2 * 4 < (n3 += 2) * 7 && n3 * 4 < n2 * 7) {
                resultPoint5 = ((Detector)object7).correctTopRight((ResultPoint)object2, (ResultPoint)object, (ResultPoint)object3, resultPoint4, n2 = Math.min(n3, n2));
                if (resultPoint5 == null) {
                    resultPoint5 = resultPoint4;
                }
                if (((n3 = Math.max(((Detector)object7).transitionsBetween((ResultPoint)object3, resultPoint5).getTransitions(), ((Detector)object7).transitionsBetween((ResultPoint)object, resultPoint5).getTransitions()) + 1) & 1) == 1) {
                    // empty if block
                }
                int n4 = ++n3;
                object7 = Detector.sampleGrid(((Detector)object7).image, (ResultPoint)object3, (ResultPoint)object2, (ResultPoint)object, resultPoint5, n4, n4);
            } else {
                resultPoint5 = ((Detector)object7).correctTopRightRectangular((ResultPoint)object2, (ResultPoint)object, (ResultPoint)object3, resultPoint4, n2, n3);
                if (resultPoint5 == null) {
                    resultPoint5 = resultPoint4;
                }
                n3 = ((Detector)object7).transitionsBetween((ResultPoint)object3, resultPoint5).getTransitions();
                int n5 = ((Detector)object7).transitionsBetween((ResultPoint)object, resultPoint5).getTransitions();
                if ((n3 & 1) == 1) {
                    ++n3;
                }
                if ((n5 & 1) == 1) {
                    ++n5;
                }
                object7 = Detector.sampleGrid(((Detector)object7).image, (ResultPoint)object3, (ResultPoint)object2, (ResultPoint)object, resultPoint5, n3, n5);
            }
            ResultPoint[] resultPointArray3 = new ResultPoint[4];
            ResultPoint[] resultPointArray4 = resultPointArray3;
            resultPointArray3[0] = object3;
            resultPointArray3[1] = object2;
            resultPointArray3[2] = object;
            resultPointArray3[3] = resultPoint5;
            return new DetectorResult((BitMatrix)object7, resultPointArray4);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static final class ResultPointsAndTransitionsComparator
    implements Comparator<ResultPointsAndTransitions>,
    Serializable {
        private ResultPointsAndTransitionsComparator() {
        }

        @Override
        public int compare(ResultPointsAndTransitions resultPointsAndTransitions, ResultPointsAndTransitions resultPointsAndTransitions2) {
            return resultPointsAndTransitions.getTransitions() - resultPointsAndTransitions2.getTransitions();
        }
    }

    private static final class ResultPointsAndTransitions {
        private final ResultPoint from;
        private final ResultPoint to;
        private final int transitions;

        private ResultPointsAndTransitions(ResultPoint resultPoint, ResultPoint resultPoint2, int n2) {
            this.from = resultPoint;
            this.to = resultPoint2;
            this.transitions = n2;
        }

        ResultPoint getFrom() {
            return this.from;
        }

        ResultPoint getTo() {
            return this.to;
        }

        public int getTransitions() {
            return this.transitions;
        }

        public String toString() {
            return this.from + "/" + this.to + '/' + this.transitions;
        }
    }
}

