/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Dimension;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.datamatrix.encoder.DefaultPlacement;
import com.dcloud.zxing2.datamatrix.encoder.ErrorCorrection;
import com.dcloud.zxing2.datamatrix.encoder.HighLevelEncoder;
import com.dcloud.zxing2.datamatrix.encoder.SymbolInfo;
import com.dcloud.zxing2.datamatrix.encoder.SymbolShapeHint;
import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;
import java.util.Map;

public final class DataMatrixWriter
implements Writer {
    private static BitMatrix encodeLowLevel(DefaultPlacement defaultPlacement, SymbolInfo symbolInfo) {
        ByteMatrix byteMatrix;
        SymbolInfo symbolInfo2 = symbolInfo;
        int n2 = symbolInfo2.getSymbolDataWidth();
        int n3 = symbolInfo2.getSymbolDataHeight();
        ByteMatrix byteMatrix2 = byteMatrix;
        SymbolInfo symbolInfo3 = symbolInfo;
        int n4 = symbolInfo3.getSymbolWidth();
        byteMatrix = new ByteMatrix(n4, symbolInfo3.getSymbolHeight());
        n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            int n6;
            int n7;
            if (i2 % symbolInfo.matrixHeight == 0) {
                n7 = 0;
                for (n6 = 0; n6 < symbolInfo.getSymbolWidth(); ++n6) {
                    n5 = n6 % 2 == 0 ? 1 : 0;
                    byteMatrix2.set(n7, n4, n5 != 0);
                    ++n7;
                }
                ++n4;
            }
            n7 = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                if (n6 % symbolInfo.matrixWidth == 0) {
                    byteMatrix2.set(n7, n4, true);
                    ++n7;
                }
                byteMatrix2.set(n7, n4, defaultPlacement.getBit(n6, i2));
                ++n7;
                n5 = symbolInfo.matrixWidth;
                if (n6 % n5 != n5 - 1) continue;
                n5 = i2 % 2 == 0 ? 1 : 0;
                byteMatrix2.set(n7, n4, n5 != 0);
                ++n7;
            }
            ++n4;
            n7 = symbolInfo.matrixHeight;
            if (i2 % n7 != n7 - 1) continue;
            n7 = 0;
            for (n6 = 0; n6 < symbolInfo.getSymbolWidth(); ++n6) {
                byteMatrix2.set(n7, n4, true);
                ++n7;
            }
            ++n4;
        }
        return DataMatrixWriter.convertByteMatrixToBitMatrix(byteMatrix2);
    }

    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix byteMatrix) {
        BitMatrix bitMatrix;
        ByteMatrix byteMatrix2 = byteMatrix;
        int n2 = byteMatrix2.getWidth();
        int n3 = byteMatrix2.getHeight();
        BitMatrix bitMatrix2 = bitMatrix;
        new BitMatrix(n2, n3).clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (byteMatrix.get(i2, i3) != 1) continue;
                bitMatrix2.set(i2, i3);
            }
        }
        return bitMatrix2;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat object, int n2, int n3, Map<EncodeHintType, ?> map) {
        if (!string2.isEmpty()) {
            if (object == BarcodeFormat.DATA_MATRIX) {
                if (n2 >= 0 && n3 >= 0) {
                    Object object2;
                    Object object3 = SymbolShapeHint.FORCE_NONE;
                    object = null;
                    Object var3_5 = null;
                    if (map != null) {
                        object2 = (SymbolShapeHint)((Object)map.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
                        if (object2 == null) {
                            object2 = object3;
                        }
                        object3 = (Dimension)map.get((Object)EncodeHintType.MIN_SIZE);
                        if (object3 == null) {
                            object3 = object;
                        }
                        object = (Dimension)map.get((Object)EncodeHintType.MAX_SIZE);
                        if (object == null) {
                            object = var3_5;
                        }
                    } else {
                        Object object4 = object3;
                        BarcodeFormat barcodeFormat = object;
                        object = var3_5;
                        object3 = barcodeFormat;
                        object2 = object4;
                    }
                    String string3 = HighLevelEncoder.encodeHighLevel(string2, object2, (Dimension)object3, (Dimension)object);
                    object3 = SymbolInfo.lookup(string3.length(), object2, (Dimension)object3, (Dimension)object, true);
                    string2 = ErrorCorrection.encodeECC200(string3, (SymbolInfo)object3);
                    Object object5 = object3;
                    int n4 = ((SymbolInfo)object5).getSymbolDataWidth();
                    DefaultPlacement defaultPlacement = new DefaultPlacement(string2, n4, ((SymbolInfo)object5).getSymbolDataHeight());
                    defaultPlacement.place();
                    return DataMatrixWriter.encodeLowLevel(defaultPlacement, (SymbolInfo)object3);
                }
                throw new IllegalArgumentException("Requested dimensions are too small: " + n2 + 'x' + n3);
            }
            throw new IllegalArgumentException("Can only encode DATA_MATRIX, but got " + (Object)object);
        }
        throw new IllegalArgumentException("Found empty contents");
    }
}

