/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.datamatrix.decoder.Decoder;
import com.dcloud.zxing2.datamatrix.detector.Detector;
import java.util.Map;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder;

    public DataMatrixReader() {
        Decoder decoder;
        Decoder decoder2 = decoder;
        decoder = new Decoder();
        v1.decoder = decoder2;
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray != null && nArray2 != null) {
            int n2 = DataMatrixReader.moduleSize(nArray, bitMatrix);
            int n3 = nArray[1];
            int n4 = nArray2[1];
            int n5 = nArray[0];
            int n6 = (nArray2[0] - n5 + 1) / n2;
            n4 = (n4 - n3 + 1) / n2;
            if (n6 > 0 && n4 > 0) {
                BitMatrix bitMatrix2;
                int n7 = n5;
                int n8 = n3;
                n3 = n2 / 2;
                n5 = n8 + n3;
                n3 = n7 + n3;
                BitMatrix bitMatrix3 = bitMatrix2;
                bitMatrix2 = new BitMatrix(n6, n4);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n9 = n5 + i2 * n2;
                    for (int i3 = 0; i3 < n6; ++i3) {
                        if (!bitMatrix.get(n3 + i3 * n2, n9)) continue;
                        bitMatrix3.set(i3, i2);
                    }
                }
                return bitMatrix3;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n2;
        int n3 = bitMatrix.getWidth();
        int n4 = nArray[1];
        for (n2 = nArray[0]; n2 < n3 && bitMatrix.get(n2, n4); ++n2) {
        }
        if (n2 != n3) {
            int n5 = n2 - nArray[0];
            if (n5 != 0) {
                return n5;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        Result result;
        Object object3;
        if (object2 != null && object2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            DataMatrixReader dataMatrixReader = object3;
            object3 = DataMatrixReader.extractPureBits(object.getBlackMatrix());
            object3 = dataMatrixReader.decoder.decode((BitMatrix)object3);
            object = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(object.getBlackMatrix()).detect();
            object3 = ((DataMatrixReader)object3).decoder.decode(detectorResult.getBits());
            object = detectorResult.getPoints();
        }
        object2 = result;
        Object object4 = object3;
        String string = ((DecoderResult)object4).getText();
        BarcodeFormat barcodeFormat = BarcodeFormat.DATA_MATRIX;
        result = new Result(string, ((DecoderResult)object4).getRawBytes(), (ResultPoint[])object, barcodeFormat);
        object = ((DecoderResult)object3).getByteSegments();
        if (object != null) {
            ((Result)object2).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object);
        }
        if ((object3 = ((DecoderResult)object3).getECLevel()) != null) {
            ((Result)object2).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object3);
        }
        return object2;
    }

    @Override
    public void reset() {
    }
}

