/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.reedsolomon;

import com.dcloud.zxing2.common.reedsolomon.GenericGFPoly;

public final class GenericGF {
    public static final GenericGF AZTEC_DATA_12 = new GenericGF(4201, 4096, 1);
    public static final GenericGF AZTEC_DATA_10 = new GenericGF(1033, 1024, 1);
    public static final GenericGF AZTEC_DATA_6 = new GenericGF(67, 64, 1);
    public static final GenericGF AZTEC_PARAM = new GenericGF(19, 16, 1);
    public static final GenericGF QR_CODE_FIELD_256 = new GenericGF(285, 256, 0);
    public static final GenericGF DATA_MATRIX_FIELD_256;
    public static final GenericGF AZTEC_DATA_8;
    public static final GenericGF MAXICODE_FIELD_64;
    private final int[] expTable;
    private final int[] logTable;
    private final GenericGFPoly zero;
    private final GenericGFPoly one;
    private final int size;
    private final int primitive;
    private final int generatorBase;

    public GenericGF(int n2, int n3, int n4) {
        GenericGFPoly genericGFPoly;
        GenericGFPoly genericGFPoly2;
        this.primitive = n2;
        this.size = n3;
        this.generatorBase = n4;
        this.expTable = new int[n3];
        this.logTable = new int[n3];
        n4 = 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.expTable[i2] = n4;
            if ((n4 *= 2) < n3) continue;
            n4 = (n4 ^ n2) & n3 - 1;
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            this.logTable[this.expTable[n2]] = n2;
        }
        GenericGF genericGF = this;
        GenericGFPoly genericGFPoly3 = genericGFPoly2;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        genericGFPoly2 = new GenericGFPoly(this, nArray2);
        genericGF.zero = genericGFPoly3;
        genericGFPoly3 = genericGFPoly;
        int[] nArray3 = new int[1];
        nArray2 = nArray3;
        nArray3[0] = 1;
        genericGFPoly = new GenericGFPoly(this, nArray2);
        genericGF.one = genericGFPoly3;
    }

    static int addOrSubtract(int n2, int n3) {
        return n2 ^ n3;
    }

    static {
        AZTEC_DATA_8 = DATA_MATRIX_FIELD_256 = new GenericGF(301, 256, 1);
        MAXICODE_FIELD_64 = AZTEC_DATA_6;
    }

    GenericGFPoly getZero() {
        return this.zero;
    }

    GenericGFPoly getOne() {
        return this.one;
    }

    GenericGFPoly buildMonomial(int n2, int n3) {
        if (n2 >= 0) {
            if (n3 == 0) {
                return this.zero;
            }
            int[] nArray = new int[n2 + 1];
            int[] nArray2 = nArray;
            nArray[0] = n3;
            return new GenericGFPoly(this, nArray2);
        }
        throw new IllegalArgumentException();
    }

    int exp(int n2) {
        return this.expTable[n2];
    }

    int log(int n2) {
        if (n2 != 0) {
            return this.logTable[n2];
        }
        throw new IllegalArgumentException();
    }

    int inverse(int n2) {
        if (n2 != 0) {
            return this.expTable[this.size - this.logTable[n2] - 1];
        }
        throw new ArithmeticException();
    }

    int multiply(int n2, int n3) {
        if (n2 != 0 && n3 != 0) {
            int[] nArray = this.logTable;
            return this.expTable[(this.logTable[n2] + nArray[n3]) % (this.size - 1)];
        }
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public int getGeneratorBase() {
        return this.generatorBase;
    }

    public String toString() {
        return "GF(0x" + Integer.toHexString(this.primitive) + ',' + this.size + ')';
    }
}

