/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.InvertedLuminanceSource;

public abstract class LuminanceSource {
    private final int width;
    private final int height;

    protected LuminanceSource(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public abstract byte[] getRow(int var1, byte[] var2);

    public abstract byte[] getMatrix();

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public boolean isCropSupported() {
        return false;
    }

    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException("This luminance source does not support cropping.");
    }

    public boolean isRotateSupported() {
        return false;
    }

    public LuminanceSource invert() {
        return new InvertedLuminanceSource(this);
    }

    public LuminanceSource rotateCounterClockwise() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 90 degrees.");
    }

    public LuminanceSource rotateCounterClockwise45() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 45 degrees.");
    }

    public final String toString() {
        StringBuilder stringBuilder;
        int n2 = this.width;
        byte[] byArray = new byte[n2];
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.height * (n2 + 1));
        for (n2 = 0; n2 < this.height; ++n2) {
            byArray = this.getRow(n2, byArray);
            for (int i2 = 0; i2 < this.width; ++i2) {
                int n3 = byArray[i2] & 0xFF;
                n3 = n3 < 64 ? 35 : (n3 < 128 ? 43 : (n3 < 192 ? 46 : 32));
                stringBuilder2.append((char)n3);
            }
            stringBuilder2.append('\n');
        }
        return stringBuilder2.toString();
    }
}

