/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget.toast;

import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

final class SafeToastContext
extends ContextWrapper {
    SafeToastContext(Context context) {
        super(context);
    }

    public Context getApplicationContext() {
        SafeToastContext safeToastContext = this;
        return safeToastContext.new ApplicationContextWrapper(safeToastContext.getBaseContext().getApplicationContext());
    }

    private final class WindowManagerWrapper
    implements WindowManager {
        private static final String TAG = "WindowManagerWrapper";
        private final WindowManager base;

        private WindowManagerWrapper(WindowManager windowManager) {
            this.base = windowManager;
        }

        public Display getDefaultDisplay() {
            return this.base.getDefaultDisplay();
        }

        public void removeViewImmediate(View view) {
            this.base.removeViewImmediate(view);
        }

        public void addView(View view, ViewGroup.LayoutParams layoutParams) {
            try {
                this.base.addView(view, layoutParams);
            }
            catch (Throwable throwable) {
                Log.e((String)TAG, (String)"[addView]", (Throwable)throwable);
            }
            catch (WindowManager.BadTokenException badTokenException) {
                Log.i((String)TAG, (String)badTokenException.getMessage());
            }
        }

        public void updateViewLayout(View view, ViewGroup.LayoutParams layoutParams) {
            this.base.updateViewLayout(view, layoutParams);
        }

        public void removeView(View view) {
            this.base.removeView(view);
        }
    }

    private final class ApplicationContextWrapper
    extends ContextWrapper {
        private ApplicationContextWrapper(Context context) {
            super(context);
        }

        public Object getSystemService(String string2) {
            if ("window".equals(string2)) {
                return new WindowManagerWrapper((WindowManager)this.getBaseContext().getSystemService(string2));
            }
            return super.getSystemService(string2);
        }
    }
}

