/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget.photoview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import androidx.core.view.MotionEventCompat;
import com.dcloud.android.widget.photoview.Compat;
import com.dcloud.android.widget.photoview.CustomGestureDetector;
import com.dcloud.android.widget.photoview.OnGestureListener;
import com.dcloud.android.widget.photoview.OnMatrixChangedListener;
import com.dcloud.android.widget.photoview.OnOutsidePhotoTapListener;
import com.dcloud.android.widget.photoview.OnPhotoTapListener;
import com.dcloud.android.widget.photoview.OnScaleChangedListener;
import com.dcloud.android.widget.photoview.OnSingleFlingListener;
import com.dcloud.android.widget.photoview.Util;

public class PhotoViewAttacher
implements View.OnTouchListener,
OnGestureListener,
View.OnLayoutChangeListener {
    private static float DEFAULT_MAX_SCALE = 3.0f;
    private static float DEFAULT_MID_SCALE = 1.75f;
    private static float DEFAULT_MIN_SCALE = 1.0f;
    private static int DEFAULT_ZOOM_DURATION = 200;
    private static final int EDGE_NONE = -1;
    private static final int EDGE_LEFT = 0;
    private static final int EDGE_RIGHT = 1;
    private static final int EDGE_BOTH = 2;
    private static int SINGLE_TOUCH = 1;
    private Interpolator mInterpolator;
    private int mZoomDuration;
    private float mMinScale;
    private float mMidScale;
    private float mMaxScale;
    private boolean mAllowParentInterceptOnEdge;
    private boolean mBlockParentIntercept;
    private ImageView mImageView;
    private GestureDetector mGestureDetector;
    private CustomGestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix;
    private final Matrix mDrawMatrix;
    private final Matrix mSuppMatrix;
    private final RectF mDisplayRect;
    private final float[] mMatrixValues;
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnPhotoTapListener mPhotoTapListener;
    private OnOutsidePhotoTapListener mOutsidePhotoTapListener;
    private View.OnClickListener mOnClickListener;
    private View.OnLongClickListener mLongClickListener;
    private OnScaleChangedListener mScaleChangeListener;
    private OnSingleFlingListener mSingleFlingListener;
    private FlingRunnable mCurrentFlingRunnable;
    private int mScrollEdge;
    private float mBaseRotation;
    private boolean mZoomEnabled;
    private ImageView.ScaleType mScaleType;

    public PhotoViewAttacher(ImageView imageView) {
        ImageView imageView2 = imageView;
        this.mInterpolator = new AccelerateDecelerateInterpolator();
        this.mZoomDuration = DEFAULT_ZOOM_DURATION;
        this.mMinScale = DEFAULT_MIN_SCALE;
        this.mMidScale = DEFAULT_MID_SCALE;
        this.mMaxScale = DEFAULT_MAX_SCALE;
        this.mAllowParentInterceptOnEdge = true;
        this.mBlockParentIntercept = false;
        this.mBaseMatrix = new Matrix();
        this.mDrawMatrix = new Matrix();
        this.mSuppMatrix = new Matrix();
        this.mDisplayRect = new RectF();
        this.mMatrixValues = new float[9];
        this.mScrollEdge = 2;
        this.mZoomEnabled = true;
        this.mScaleType = ImageView.ScaleType.FIT_CENTER;
        this.mImageView = imageView;
        imageView.setOnTouchListener((View.OnTouchListener)this);
        imageView2.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        if (imageView2.isInEditMode()) {
            return;
        }
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mBaseRotation = 0.0f;
        photoViewAttacher.mScaleDragDetector = new CustomGestureDetector(imageView.getContext(), this);
        this.mGestureDetector = new GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                if (PhotoViewAttacher.this.mLongClickListener != null) {
                    PhotoViewAttacher.this.mLongClickListener.onLongClick((View)PhotoViewAttacher.this.mImageView);
                }
            }

            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
                if (PhotoViewAttacher.this.mSingleFlingListener != null) {
                    if (PhotoViewAttacher.this.getScale() > DEFAULT_MIN_SCALE) {
                        return false;
                    }
                    if (MotionEventCompat.getPointerCount((MotionEvent)motionEvent) <= SINGLE_TOUCH && MotionEventCompat.getPointerCount((MotionEvent)motionEvent2) <= SINGLE_TOUCH) {
                        return PhotoViewAttacher.this.mSingleFlingListener.onFling(motionEvent, motionEvent2, f2, f3);
                    }
                    return false;
                }
                return false;
            }
        });
        this.mGestureDetector.setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                RectF rectF;
                if (PhotoViewAttacher.this.mOnClickListener != null) {
                    PhotoViewAttacher.this.mOnClickListener.onClick((View)PhotoViewAttacher.this.mImageView);
                }
                if ((rectF = PhotoViewAttacher.this.getDisplayRect()) != null) {
                    float f2;
                    MotionEvent motionEvent2 = motionEvent;
                    float f3 = motionEvent2.getX();
                    if (rectF.contains(f3, f2 = motionEvent2.getY())) {
                        f3 = (f3 - rectF.left) / rectF.width();
                        float f4 = (f2 - rectF.top) / rectF.height();
                        if (PhotoViewAttacher.this.mPhotoTapListener != null) {
                            PhotoViewAttacher.this.mPhotoTapListener.onPhotoTap(PhotoViewAttacher.this.mImageView, f3, f4);
                        }
                        return true;
                    }
                    if (PhotoViewAttacher.this.mOutsidePhotoTapListener != null) {
                        PhotoViewAttacher.this.mOutsidePhotoTapListener.onOutsidePhotoTap(PhotoViewAttacher.this.mImageView);
                    }
                }
                return false;
            }

            /*
             * Unable to fully structure code
             */
            public boolean onDoubleTap(MotionEvent var1_1) {
                block8: {
                    try {
                        var2_3 = PhotoViewAttacher.this.getScale();
                    }
                    catch (ArrayIndexOutOfBoundsException v0) {}
                    v1 = this;
                    v2 = var1_1;
                    v3 = v2;
                    var1_2 = v2.getX();
                    var3_4 = v3.getY();
                    if (!(v4 < v1.PhotoViewAttacher.this.getMediumScale())) ** GOTO lbl17
                    v5 = PhotoViewAttacher.this;
                    v5.setScale(v5.getMediumScale(), var1_2, var3_4, true);
                    break block8;
lbl17:
                    // 1 sources

                    if (!(var2_3 >= PhotoViewAttacher.this.getMediumScale())) ** GOTO lbl24
                    if (!(var2_3 < PhotoViewAttacher.this.getMaximumScale())) ** GOTO lbl24
                    v6 = PhotoViewAttacher.this;
                    v6.setScale(v6.getMaximumScale(), var1_2, var3_4, true);
                    break block8;
lbl24:
                    // 2 sources

                    v7 = PhotoViewAttacher.this;
                    v7.setScale(v7.getMinimumScale(), var1_2, var3_4, true);
                }
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent motionEvent) {
                return false;
            }
        });
    }

    private Matrix getDrawMatrix() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mDrawMatrix.set(this.mBaseMatrix);
        photoViewAttacher.mDrawMatrix.postConcat(this.mSuppMatrix);
        return photoViewAttacher.mDrawMatrix;
    }

    private float getValue(Matrix matrix, int n2) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[n2];
    }

    private void resetMatrix() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.reset();
        photoViewAttacher.setRotationBy(photoViewAttacher.mBaseRotation);
        photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
        photoViewAttacher.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mImageView.setImageMatrix(matrix);
        if (photoViewAttacher.mMatrixChangeListener != null && (matrix = this.getDisplayRect(matrix)) != null) {
            this.mMatrixChangeListener.onMatrixChanged((RectF)matrix);
        }
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
        }
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable drawable2 = this.mImageView.getDrawable();
        if (drawable2 != null) {
            PhotoViewAttacher photoViewAttacher = this;
            Drawable drawable3 = drawable2;
            float f2 = drawable3.getIntrinsicWidth();
            float f3 = drawable3.getIntrinsicHeight();
            photoViewAttacher.mDisplayRect.set(0.0f, 0.0f, f2, f3);
            matrix.mapRect(photoViewAttacher.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private void updateBaseMatrix(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        PhotoViewAttacher photoViewAttacher = this;
        float f2 = photoViewAttacher.getImageViewWidth(photoViewAttacher.mImageView);
        float f3 = photoViewAttacher.getImageViewHeight(photoViewAttacher.mImageView);
        Drawable drawable3 = drawable2;
        int n2 = drawable3.getIntrinsicWidth();
        int n3 = drawable3.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float f4 = n2;
        float f5 = f2 / f4;
        float f6 = n3;
        float f7 = f3 / f6;
        ImageView.ScaleType scaleType = photoViewAttacher.mScaleType;
        if (scaleType == ImageView.ScaleType.CENTER) {
            f4 = (f2 - f4) / 2.0f;
            this.mBaseMatrix.postTranslate(f4, (f3 - f6) / 2.0f);
        } else if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            PhotoViewAttacher photoViewAttacher2 = this;
            float f8 = f5 = Math.max(f5, f7);
            photoViewAttacher2.mBaseMatrix.postScale(f8, f8);
            f4 = (f2 - f4 * f5) / 2.0f;
            photoViewAttacher2.mBaseMatrix.postTranslate(f4, (f3 - f6 * f5) / 2.0f);
        } else if (scaleType == ImageView.ScaleType.CENTER_INSIDE) {
            PhotoViewAttacher photoViewAttacher3 = this;
            float f9 = f5 = Math.min(1.0f, Math.min(f5, f7));
            photoViewAttacher3.mBaseMatrix.postScale(f9, f9);
            f4 = (f2 - f4 * f5) / 2.0f;
            photoViewAttacher3.mBaseMatrix.postTranslate(f4, (f3 - f6 * f5) / 2.0f);
        } else {
            RectF rectF;
            RectF rectF2;
            RectF rectF3 = rectF2;
            rectF2 = new RectF(0.0f, 0.0f, f4, f6);
            RectF rectF4 = rectF;
            rectF = new RectF(0.0f, 0.0f, f2, f3);
            if ((int)this.mBaseRotation % 180 != 0) {
                RectF rectF5;
                rectF3 = rectF5;
                rectF5 = new RectF(0.0f, 0.0f, f6, f4);
            }
            switch (3.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()]) {
                default: {
                    break;
                }
                case 4: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.FILL);
                    break;
                }
                case 3: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.END);
                    break;
                }
                case 2: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.START);
                    break;
                }
                case 1: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.CENTER);
                }
            }
        }
        this.resetMatrix();
    }

    private boolean checkMatrixBounds() {
        float f2;
        float f3;
        float f4;
        float f5;
        PhotoViewAttacher photoViewAttacher = this;
        RectF rectF = photoViewAttacher.getDisplayRect(photoViewAttacher.getDrawMatrix());
        if (rectF == null) {
            return false;
        }
        float f6 = rectF.height();
        PhotoViewAttacher photoViewAttacher2 = this;
        float f7 = rectF.width();
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = photoViewAttacher2.getImageViewHeight(photoViewAttacher2.mImageView);
        if (f5 <= f4) {
            int n2 = 3.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()];
            f9 = n2 != 2 ? (n2 != 3 ? (f10 - f6) / 2.0f - rectF.top : f10 - f6 - rectF.top) : -rectF.top;
        } else {
            float f11;
            f6 = rectF.top;
            if (f11 > 0.0f) {
                f9 = -f6;
            } else {
                float f12;
                f6 = rectF.bottom;
                if (f12 < f10) {
                    f9 = f10 - f6;
                }
            }
        }
        PhotoViewAttacher photoViewAttacher3 = this;
        f6 = photoViewAttacher3.getImageViewWidth(photoViewAttacher3.mImageView);
        if (f7 <= f3) {
            int n3 = 3.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()];
            f2 = n3 != 2 ? (n3 != 3 ? (f6 - f7) / 2.0f - rectF.left : f6 - f7 - rectF.left) : -rectF.left;
            this.mScrollEdge = 2;
        } else {
            float f13;
            f7 = rectF.left;
            if (f13 > 0.0f) {
                this.mScrollEdge = 0;
                f2 = -f7;
            } else {
                float f14;
                f2 = rectF.right;
                if (f14 < f6) {
                    f2 = f6 - f2;
                    this.mScrollEdge = 1;
                } else {
                    this.mScrollEdge = -1;
                    f2 = f8;
                }
            }
        }
        this.mSuppMatrix.postTranslate(f2, f9);
        return true;
    }

    private int getImageViewWidth(ImageView imageView) {
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private int getImageViewHeight(ImageView imageView) {
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    private void cancelFling() {
        FlingRunnable flingRunnable = this.mCurrentFlingRunnable;
        if (flingRunnable != null) {
            flingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.mGestureDetector.setOnDoubleTapListener(onDoubleTapListener);
    }

    public void setOnScaleChangeListener(OnScaleChangedListener onScaleChangedListener) {
        this.mScaleChangeListener = onScaleChangedListener;
    }

    public void setOnSingleFlingListener(OnSingleFlingListener onSingleFlingListener) {
        this.mSingleFlingListener = onSingleFlingListener;
    }

    public boolean isZoomEnabled() {
        return this.mZoomEnabled;
    }

    public RectF getDisplayRect() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.checkMatrixBounds();
        return photoViewAttacher.getDisplayRect(photoViewAttacher.getDrawMatrix());
    }

    public boolean setDisplayMatrix(Matrix matrix) {
        if (matrix != null) {
            if (this.mImageView.getDrawable() == null) {
                return false;
            }
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.mSuppMatrix.set(matrix);
            photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
            photoViewAttacher.checkMatrixBounds();
            return true;
        }
        throw new IllegalArgumentException("Matrix cannot be null");
    }

    public void setBaseRotation(float f2) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mBaseRotation = f2 % 360.0f;
        photoViewAttacher.update();
        photoViewAttacher.setRotationBy(photoViewAttacher.mBaseRotation);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public void setRotationTo(float f2) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.setRotate(f2 % 360.0f);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public void setRotationBy(float f2) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.postRotate(f2 % 360.0f);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public float getMinimumScale() {
        return this.mMinScale;
    }

    public float getMediumScale() {
        return this.mMidScale;
    }

    public float getMaximumScale() {
        return this.mMaxScale;
    }

    public float getScale() {
        PhotoViewAttacher photoViewAttacher = this;
        PhotoViewAttacher photoViewAttacher2 = this;
        return (float)Math.sqrt((float)Math.pow(photoViewAttacher.getValue(photoViewAttacher.mSuppMatrix, 0), 2.0) + (float)Math.pow(photoViewAttacher2.getValue(photoViewAttacher2.mSuppMatrix, 3), 2.0));
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    @Override
    public void onDrag(float f2, float f3) {
        if (this.mScaleDragDetector.isScaling()) {
            return;
        }
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.postTranslate(f2, f3);
        photoViewAttacher.checkAndDisplayMatrix();
        ViewParent viewParent = photoViewAttacher.mImageView.getParent();
        if (photoViewAttacher.mAllowParentInterceptOnEdge && !this.mScaleDragDetector.isScaling() && !this.mBlockParentIntercept) {
            int n2 = this.mScrollEdge;
            if ((n2 == 2 || n2 == 0 && f2 >= 1.0f || n2 == 1 && f2 <= -1.0f) && viewParent != null) {
                viewParent.requestDisallowInterceptTouchEvent(false);
            }
        } else if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    @Override
    public void onFling(float f2, float f3, float f4, float f5) {
        FlingRunnable flingRunnable;
        FlingRunnable flingRunnable2 = flingRunnable;
        PhotoViewAttacher photoViewAttacher = this;
        FlingRunnable flingRunnable3 = flingRunnable2;
        PhotoViewAttacher photoViewAttacher2 = this;
        flingRunnable3(photoViewAttacher2.mImageView.getContext());
        photoViewAttacher.mCurrentFlingRunnable = flingRunnable3;
        int n2 = photoViewAttacher.getImageViewWidth(photoViewAttacher.mImageView);
        int n3 = photoViewAttacher.getImageViewHeight(photoViewAttacher.mImageView);
        int n4 = (int)f4;
        int n5 = (int)f5;
        flingRunnable.fling(n2, n3, n4, n5);
        this.mImageView.post((Runnable)this.mCurrentFlingRunnable);
    }

    public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.updateBaseMatrix(photoViewAttacher.mImageView.getDrawable());
    }

    @Override
    public void onScale(float f2, float f3, float f4) {
        if ((this.getScale() < this.mMaxScale || f2 < 1.0f) && (this.getScale() > this.mMinScale || f2 > 1.0f)) {
            OnScaleChangedListener onScaleChangedListener = this.mScaleChangeListener;
            if (onScaleChangedListener != null) {
                onScaleChangedListener.onScaleChange(f2, f3, f4);
            }
            PhotoViewAttacher photoViewAttacher = this;
            float f5 = f2;
            photoViewAttacher.mSuppMatrix.postScale(f5, f5, f3, f4);
            photoViewAttacher.checkAndDisplayMatrix();
        }
    }

    public boolean onTouch(View object, MotionEvent motionEvent) {
        boolean bl = false;
        if (this.mZoomEnabled && Util.hasDrawable((ImageView)object)) {
            int n2 = motionEvent.getAction();
            if (n2 != 0) {
                RectF rectF;
                if ((n2 == 1 || n2 == 3) && this.getScale() < this.mMinScale && (rectF = this.getDisplayRect()) != null) {
                    AnimatedZoomRunnable animatedZoomRunnable;
                    Object object2 = object;
                    object = animatedZoomRunnable;
                    RectF rectF2 = rectF;
                    PhotoViewAttacher photoViewAttacher = this;
                    float f2 = photoViewAttacher.getScale();
                    float f3 = photoViewAttacher.mMinScale;
                    float f4 = rectF2.centerX();
                    float f5 = rectF2.centerY();
                    animatedZoomRunnable = new AnimatedZoomRunnable(this, f2, f3, f4, f5);
                    object2.post((Runnable)object);
                    bl = true;
                }
            } else {
                if ((object = object.getParent()) != null) {
                    object.requestDisallowInterceptTouchEvent(true);
                }
                this.cancelFling();
            }
            if ((object = this.mScaleDragDetector) != null) {
                PhotoViewAttacher photoViewAttacher = this;
                boolean bl2 = photoViewAttacher.mScaleDragDetector.isDragging();
                bl = photoViewAttacher.mScaleDragDetector.onTouchEvent(motionEvent);
                n2 = !((CustomGestureDetector)object).isScaling() && !this.mScaleDragDetector.isScaling() ? 1 : 0;
                bl2 = !bl2 && !this.mScaleDragDetector.isDragging();
                bl2 = n2 != 0 && bl2;
                this.mBlockParentIntercept = bl2;
            }
            if ((this = this.mGestureDetector) != null && this.onTouchEvent(motionEvent)) {
                bl = true;
            }
        }
        return bl;
    }

    public void setAllowParentInterceptOnEdge(boolean bl) {
        this.mAllowParentInterceptOnEdge = bl;
    }

    public void setMinimumScale(float f2) {
        PhotoViewAttacher photoViewAttacher = this;
        float f3 = photoViewAttacher.mMidScale;
        Util.checkZoomLevels(f2, f3, photoViewAttacher.mMaxScale);
        this.mMinScale = f2;
    }

    public void setMediumScale(float f2) {
        Util.checkZoomLevels(this.mMinScale, f2, this.mMaxScale);
        this.mMidScale = f2;
    }

    public void setMaximumScale(float f2) {
        Util.checkZoomLevels(this.mMinScale, this.mMidScale, f2);
        this.mMaxScale = f2;
    }

    public void setScaleLevels(float f2, float f3, float f4) {
        PhotoViewAttacher photoViewAttacher = this;
        Util.checkZoomLevels(f2, f3, f4);
        photoViewAttacher.mMinScale = f2;
        photoViewAttacher.mMidScale = f3;
        photoViewAttacher.mMaxScale = f4;
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mLongClickListener = onLongClickListener;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener onMatrixChangedListener) {
        this.mMatrixChangeListener = onMatrixChangedListener;
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
        this.mPhotoTapListener = onPhotoTapListener;
    }

    public void setOnOutsidePhotoTapListener(OnOutsidePhotoTapListener onOutsidePhotoTapListener) {
        this.mOutsidePhotoTapListener = onOutsidePhotoTapListener;
    }

    public void setScale(float f2) {
        this.setScale(f2, false);
    }

    public void setScale(float f2, boolean bl) {
        PhotoViewAttacher photoViewAttacher = this;
        float f3 = photoViewAttacher.mImageView.getRight() / 2;
        this.setScale(f2, f3, photoViewAttacher.mImageView.getBottom() / 2, bl);
    }

    public void setScale(float f2, float f3, float f4, boolean bl) {
        if (!(f2 < this.mMinScale) && !(f2 > this.mMaxScale)) {
            if (bl) {
                PhotoViewAttacher photoViewAttacher = this;
                this.mImageView.post((Runnable)new AnimatedZoomRunnable(photoViewAttacher, photoViewAttacher.getScale(), f2, f3, f4));
            } else {
                PhotoViewAttacher photoViewAttacher = this;
                float f5 = f2;
                photoViewAttacher.mSuppMatrix.setScale(f5, f5, f3, f4);
                photoViewAttacher.checkAndDisplayMatrix();
            }
            return;
        }
        throw new IllegalArgumentException("Scale must be within the range of minScale and maxScale");
    }

    public void setZoomInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (Util.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    public void setZoomable(boolean bl) {
        this.mZoomEnabled = bl;
        this.update();
    }

    public void update() {
        if (this.mZoomEnabled) {
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.updateBaseMatrix(photoViewAttacher.mImageView.getDrawable());
        } else {
            this.resetMatrix();
        }
    }

    public void getDisplayMatrix(Matrix matrix) {
        matrix.set(this.getDrawMatrix());
    }

    public void getSuppMatrix(Matrix matrix) {
        matrix.set(this.mSuppMatrix);
    }

    public Matrix getImageMatrix() {
        return this.mDrawMatrix;
    }

    public void setZoomTransitionDuration(int n2) {
        this.mZoomDuration = n2;
    }

    private class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            OverScroller overScroller;
            FlingRunnable flingRunnable = overScroller;
            overScroller = new OverScroller(context);
            v1.mScroller = flingRunnable;
        }

        public void cancelFling() {
            this.mScroller.forceFinished(true);
        }

        public void fling(int n2, int n3, int n4, int n5) {
            int n6;
            int n7;
            float f2;
            int n8;
            int n9;
            float f3;
            RectF rectF = PhotoViewAttacher.this.getDisplayRect();
            if (rectF == null) {
                return;
            }
            int n10 = n2;
            n2 = Math.round(-rectF.left);
            float f4 = n10;
            if (f3 < rectF.width()) {
                n9 = 0;
                n8 = Math.round(rectF.width() - f4);
            } else {
                n9 = n2;
                n8 = n2;
            }
            int n11 = n3;
            n3 = Math.round(-rectF.top);
            float f5 = n11;
            if (f2 < rectF.height()) {
                n7 = 0;
                n6 = Math.round(rectF.height() - f5);
            } else {
                n7 = n3;
                n6 = n3;
            }
            FlingRunnable flingRunnable = this;
            flingRunnable.mCurrentX = n2;
            flingRunnable.mCurrentY = n3;
            if (n2 != n8 || n3 != n6) {
                this.mScroller.fling(n2, n3, n4, n5, n9, n8, n7, n6, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            if (this.mScroller.computeScrollOffset()) {
                FlingRunnable flingRunnable = this;
                int n2 = flingRunnable.mScroller.getCurrX();
                int n3 = flingRunnable.mScroller.getCurrY();
                flingRunnable.PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - n2), (float)(this.mCurrentY - n3));
                PhotoViewAttacher photoViewAttacher = flingRunnable.PhotoViewAttacher.this;
                photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
                flingRunnable.mCurrentX = n2;
                flingRunnable.mCurrentY = n3;
                Compat.postOnAnimation((View)flingRunnable.PhotoViewAttacher.this.mImageView, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;
        final /* synthetic */ PhotoViewAttacher this$0;

        public AnimatedZoomRunnable(PhotoViewAttacher photoViewAttacher, float f2, float f3, float f4, float f5) {
            AnimatedZoomRunnable animatedZoomRunnable = this;
            this.this$0 = photoViewAttacher;
            this.mFocalX = f4;
            animatedZoomRunnable.mFocalY = f5;
            animatedZoomRunnable.mStartTime = System.currentTimeMillis();
            this.mZoomStart = f2;
            this.mZoomEnd = f3;
        }

        private float interpolate() {
            float f2 = Math.min(1.0f, (float)(System.currentTimeMillis() - this.mStartTime) * 1.0f / (float)this.this$0.mZoomDuration);
            return this.this$0.mInterpolator.getInterpolation(f2);
        }

        @Override
        public void run() {
            float f2;
            float f3 = this.interpolate();
            AnimatedZoomRunnable animatedZoomRunnable = this;
            float f4 = animatedZoomRunnable.mZoomStart;
            float f5 = f3 = (f4 + f3 * (this.mZoomEnd - f4)) / this.this$0.getScale();
            AnimatedZoomRunnable animatedZoomRunnable2 = this;
            f3 = animatedZoomRunnable2.mFocalX;
            animatedZoomRunnable.this$0.onScale(f5, f3, animatedZoomRunnable2.mFocalY);
            if (f2 < 1.0f) {
                Compat.postOnAnimation((View)this.this$0.mImageView, this);
            }
        }
    }
}

