/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CapsuleLayout
extends LinearLayout {
    public static final int STYLE_LIGHT = 1;
    public static final int STYLE_DARK = 2;
    public Paint mPaint;
    public float mAngle;
    public int mStrokeColor;
    public int mStrokeWidth;
    public int mBackgroundColor;
    CapsuleDrawable mDrawable;
    private List<View> mIntervals;
    private int mSelectColor;
    private int mStyle = 1;
    public boolean isDiy = false;

    public CapsuleLayout(@NonNull Context context, float f2) {
        super(context);
        this.mAngle = f2;
        this.mIntervals = new ArrayList<View>();
        this.setRoundColor(Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffe5e5e5"), 1);
        this.mSelectColor = Color.parseColor((String)"#CBCCCD");
    }

    private void updateBackground() {
        if (this.mDrawable == null) {
            CapsuleDrawable capsuleDrawable;
            CapsuleDrawable capsuleDrawable2 = capsuleDrawable;
            this.mDrawable = new CapsuleDrawable();
            if (Build.VERSION.SDK_INT < 16) {
                this.setBackgroundDrawable((Drawable)capsuleDrawable2);
            } else {
                this.setBackground((Drawable)capsuleDrawable2);
            }
        }
        CapsuleLayout capsuleLayout = this;
        capsuleLayout.mDrawable.setCornerRadius(this.mAngle);
        CapsuleLayout capsuleLayout2 = this;
        int n2 = capsuleLayout2.mStrokeWidth;
        capsuleLayout.mDrawable.setStroke(n2, capsuleLayout2.mStrokeColor);
        capsuleLayout.mDrawable.setColor(this.mBackgroundColor);
        capsuleLayout.mDrawable.invalidateSelf();
    }

    private void initButtonBackground(View view, ButtonType buttonType) {
        CapsuleDrawable capsuleDrawable;
        CapsuleDrawable capsuleDrawable2;
        StateListDrawable stateListDrawable;
        StateListDrawable stateListDrawable2 = stateListDrawable;
        stateListDrawable = new StateListDrawable();
        CapsuleDrawable capsuleDrawable3 = capsuleDrawable2;
        capsuleDrawable2 = new CapsuleDrawable();
        CapsuleDrawable capsuleDrawable4 = capsuleDrawable;
        capsuleDrawable = new CapsuleDrawable();
        float[] fArray = new float[]{};
        int n2 = 1.$SwitchMap$com$dcloud$android$widget$CapsuleLayout$ButtonType[buttonType.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3) {
                    float[] fArray2 = new float[8];
                    fArray = fArray2;
                    fArray2[0] = 0.0f;
                    fArray2[1] = 0.0f;
                    fArray2[2] = 0.0f;
                    fArray2[3] = 0.0f;
                    fArray2[4] = 0.0f;
                    fArray2[5] = 0.0f;
                    fArray2[6] = 0.0f;
                    fArray2[7] = 0.0f;
                }
            } else {
                float f2;
                float[] fArray3 = new float[8];
                fArray = fArray3;
                fArray[0] = 0.0f;
                fArray[1] = 0.0f;
                fArray3[2] = f2 = this.mAngle;
                fArray3[3] = f2;
                fArray3[4] = f2;
                fArray3[5] = f2;
                fArray3[6] = 0.0f;
                fArray3[7] = 0.0f;
                capsuleDrawable4.setStroke(this.mStrokeWidth, 0);
            }
        } else {
            float f3;
            float[] fArray4 = new float[8];
            fArray = fArray4;
            fArray4[0] = f3 = this.mAngle;
            fArray4[1] = f3;
            fArray4[2] = 0.0f;
            fArray4[3] = 0.0f;
            fArray4[4] = 0.0f;
            fArray4[5] = 0.0f;
            fArray4[6] = f3;
            fArray4[7] = f3;
            capsuleDrawable4.setStroke(this.mStrokeWidth, 0);
        }
        StateListDrawable stateListDrawable3 = stateListDrawable2;
        CapsuleDrawable capsuleDrawable5 = capsuleDrawable3;
        capsuleDrawable4.setCornerRadii(fArray);
        capsuleDrawable5.setCornerRadii(fArray);
        capsuleDrawable5.setColor(0);
        capsuleDrawable4.setColor(this.mSelectColor);
        stateListDrawable3.addState(new int[]{16842919, 16842910}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[]{16842910, 16842908}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[]{16842910}, (Drawable)capsuleDrawable3);
        stateListDrawable3.addState(new int[]{16842908}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[]{16842909}, (Drawable)capsuleDrawable4);
        stateListDrawable3.addState(new int[0], (Drawable)capsuleDrawable3);
        if (Build.VERSION.SDK_INT < 16) {
            view.setBackgroundDrawable((Drawable)stateListDrawable2);
        } else {
            view.setBackground((Drawable)stateListDrawable2);
        }
    }

    private void updateIntervalColor() {
        Iterator<View> iterator = this.mIntervals.iterator();
        while (iterator.hasNext()) {
            iterator.next().setBackgroundColor(this.mStrokeColor);
        }
    }

    public void setBackgroundColor(int n2) {
        this.mBackgroundColor = n2;
        this.updateBackground();
    }

    public void setBackground(Drawable drawable2) {
        if (drawable2 instanceof CapsuleDrawable) {
            super.setBackground(drawable2);
        }
    }

    public void setBackgroundResource(int n2) {
    }

    public void setRoundColor(int n2, int n3, int n4) {
        this.mBackgroundColor = n2;
        this.mStrokeColor = n3;
        this.mStrokeWidth = n4;
        this.updateBackground();
    }

    public void setRoundColor(int n2) {
        this.mStrokeColor = n2;
        this.updateBackground();
    }

    public void setButtonSelectColor(View view, ButtonType buttonType, int n2) {
        if (view != null && view.getParent() != null) {
            this.mSelectColor = n2;
            this.initButtonBackground((View)view.getParent(), buttonType);
        }
    }

    public void setAngle(float f2) {
        this.mAngle = f2;
        this.updateBackground();
    }

    public int checkColorToStyle(int n2) {
        if (this.isDiy) {
            return 1;
        }
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2;
        n2 = n4 >> 8 & 0xFF;
        int n5 = n4 & 0xFF;
        if (n3 > 235 && n2 > 235 && n5 > 235) {
            if (this.mStyle == 2) {
                CapsuleLayout capsuleLayout = this;
                capsuleLayout.mStyle = 1;
                capsuleLayout.setRoundColor(Color.parseColor((String)"#ffffffff"), Color.parseColor((String)"#ffe5e5e5"), 1);
                capsuleLayout.updateIntervalColor();
            }
        } else if (this.mStyle == 1) {
            CapsuleLayout capsuleLayout = this;
            capsuleLayout.mStyle = 2;
            capsuleLayout.setRoundColor(Color.parseColor((String)"#1a000000"), Color.parseColor((String)"#4de5e5e5"), 1);
            capsuleLayout.updateIntervalColor();
        }
        return this.mStyle;
    }

    public void addIntervalView(float f2) {
        LinearLayout.LayoutParams layoutParams;
        View view;
        CapsuleLayout capsuleLayout = this;
        View view2 = view;
        view2(this.getContext());
        view.setBackgroundColor(this.mStrokeColor);
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        int n2 = this.mStrokeWidth;
        layoutParams = new LinearLayout.LayoutParams(n2, (int)(f2 * 18.0f));
        capsuleLayout.addView(view, (ViewGroup.LayoutParams)layoutParams2);
        capsuleLayout.mIntervals.add(view2);
    }

    public void addButtonView(View view, LinearLayout.LayoutParams layoutParams, ButtonType buttonType, View.OnClickListener onClickListener) {
        LinearLayout linearLayout;
        LinearLayout linearLayout2;
        LinearLayout.LayoutParams layoutParams2;
        LinearLayout.LayoutParams layoutParams3 = layoutParams2;
        new LinearLayout.LayoutParams((int)-1, (int)-1).weight = 1.0f;
        new LinearLayout.LayoutParams((int)-1, (int)-1).gravity = 17;
        LinearLayout linearLayout3 = linearLayout2 = linearLayout;
        linearLayout2(this.getContext());
        linearLayout3.addView(view, (ViewGroup.LayoutParams)layoutParams);
        this.addView((View)linearLayout3, (ViewGroup.LayoutParams)layoutParams3);
        linearLayout.setOnClickListener(onClickListener);
        this.initButtonBackground((View)linearLayout, buttonType);
    }

    public void removeAllViews() {
        CapsuleLayout capsuleLayout = this;
        super.removeAllViews();
        capsuleLayout.mIntervals.clear();
    }

    private class CapsuleDrawable
    extends GradientDrawable {
        private CapsuleDrawable() {
        }
    }

    public static final class ButtonType
    extends Enum<ButtonType> {
        public static final /* enum */ ButtonType LIFT;
        public static final /* enum */ ButtonType MIDDLE;
        public static final /* enum */ ButtonType RIGHT;
        private static final /* synthetic */ ButtonType[] $VALUES;

        public static ButtonType[] values() {
            return (ButtonType[])$VALUES.clone();
        }

        public static ButtonType valueOf(String string2) {
            return Enum.valueOf(ButtonType.class, string2);
        }

        static {
            ButtonType buttonType;
            ButtonType buttonType2;
            ButtonType buttonType3;
            ButtonType buttonType4 = buttonType3;
            LIFT = new ButtonType();
            ButtonType buttonType5 = buttonType2;
            MIDDLE = new ButtonType();
            ButtonType buttonType6 = buttonType;
            RIGHT = new ButtonType();
            $VALUES = new ButtonType[]{buttonType4, buttonType5, buttonType6};
        }
    }
}

