/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import com.dcloud.android.v4.view.ViewCompat;

class CircleImageView
extends ImageView {
    private static final int KEY_SHADOW_COLOR = 0x5E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.0f;
    private static final float SHADOW_RADIUS = 2.5f;
    private static final int SHADOW_ELEVATION = 4;
    private Animation.AnimationListener mListener;
    private int mShadowRadius;
    boolean mUseElevation;

    public CircleImageView(Context context, int n2, float f2, boolean bl) {
        ShapeDrawable shapeDrawable;
        float f3;
        CircleImageView circleImageView = this;
        super(context);
        circleImageView.mUseElevation = true;
        float f4 = f3 = circleImageView.getContext().getResources().getDisplayMetrics().density;
        int n3 = (int)(f2 * f3 * 2.0f);
        int f6 = (int)(f4 * 1.0f);
        int f7 = (int)(f4 * 0.0f);
        this.mUseElevation = bl;
        circleImageView.mShadowRadius = (int)(f3 * 2.5f);
        if (circleImageView.elevationSupported()) {
            ShapeDrawable shapeDrawable2;
            ShapeDrawable shapeDrawable3 = shapeDrawable2;
            shapeDrawable2 = new ShapeDrawable((Shape)new OvalShape());
            ViewCompat.setElevation((View)this, f3 * 4.0f);
            shapeDrawable = shapeDrawable3;
        } else {
            ShapeDrawable shapeDrawable3;
            OvalShadow ovalShadow;
            CircleImageView circleImageView2 = this;
            OvalShadow ovalShadow2 = ovalShadow;
            CircleImageView circleImageView3 = this;
            ovalShadow = circleImageView3.new OvalShadow(circleImageView3.mShadowRadius, n3);
            shapeDrawable = shapeDrawable3;
            ViewCompat.setLayerType((View)circleImageView2, 1, new ShapeDrawable((Shape)ovalShadow2).getPaint());
            float f5 = this.mShadowRadius;
            float f8 = f7;
            float f9 = f6;
            shapeDrawable.getPaint().setShadowLayer(f5, f8, f9, 0x5E000000);
            int n4 = circleImageView2.mShadowRadius;
            circleImageView2.setPadding(n4, n4, n4, n4);
        }
        ShapeDrawable shapeDrawable4 = shapeDrawable;
        shapeDrawable4.getPaint().setColor(n2);
        this.setBackgroundDrawable((Drawable)shapeDrawable4);
    }

    public CircleImageView(Context context, int n2, float f2) {
        this(context, n2, f2, true);
    }

    private boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.mUseElevation;
    }

    static /* synthetic */ int access$002(CircleImageView circleImageView, int n2) {
        circleImageView.mShadowRadius = n2;
        return n2;
    }

    protected void onMeasure(int n2, int n3) {
        CircleImageView circleImageView = this;
        super.onMeasure(n2, n3);
        if (!circleImageView.elevationSupported()) {
            CircleImageView circleImageView2 = this;
            circleImageView2.setMeasuredDimension(circleImageView2.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    public void setAnimationListener(Animation.AnimationListener animationListener) {
        this.mListener = animationListener;
    }

    public void onAnimationStart() {
        CircleImageView circleImageView = this;
        super.onAnimationStart();
        Animation.AnimationListener animationListener = circleImageView.mListener;
        if (animationListener != null) {
            animationListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        CircleImageView circleImageView = this;
        super.onAnimationEnd();
        Animation.AnimationListener animationListener = circleImageView.mListener;
        if (animationListener != null) {
            animationListener.onAnimationEnd(this.getAnimation());
        }
    }

    public void setBackgroundColorRes(int n2) {
        CircleImageView circleImageView = this;
        circleImageView.setBackgroundColor(circleImageView.getContext().getResources().getColor(n2));
    }

    public void setBackgroundColor(int n2) {
        if (this.getBackground() instanceof ShapeDrawable) {
            ((ShapeDrawable)this.getBackground()).getPaint().setColor(n2);
        }
    }

    private class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private Paint mShadowPaint = new Paint();
        private int mCircleDiameter;

        public OvalShadow(int n2, int n3) {
            RadialGradient radialGradient;
            CircleImageView.access$002(CircleImageView.this, n2);
            this.mCircleDiameter = n3;
            RadialGradient radialGradient2 = radialGradient;
            int n4 = this.mCircleDiameter;
            float f2 = n4 / 2;
            float f3 = n4 / 2;
            float f4 = CircleImageView.this.mShadowRadius;
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = 0x3D000000;
            nArray[1] = 0;
            CircleImageView.this = Shader.TileMode.CLAMP;
            this.mRadialGradient = new RadialGradient(f2, f3, f4, nArray2, null, (Shader.TileMode)CircleImageView.this);
            this.mShadowPaint.setShader((Shader)radialGradient2);
        }

        public void draw(Canvas canvas, Paint paint) {
            Canvas canvas2 = canvas;
            OvalShadow ovalShadow = this;
            int n2 = ovalShadow.CircleImageView.this.getWidth();
            float f2 = n2 / 2;
            float f3 = ovalShadow.CircleImageView.this.getHeight() / 2;
            float f4 = ovalShadow.mCircleDiameter / 2 + CircleImageView.this.mShadowRadius;
            Paint paint2 = ovalShadow.mShadowPaint;
            canvas2.drawCircle(f2, f3, f4, paint2);
            canvas2.drawCircle(f2, f3, (float)(this.mCircleDiameter / 2), paint);
        }
    }
}

