/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.view.accessibility;

import android.graphics.Rect;
import android.os.Build;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompat;
import com.dcloud.android.v4.view.accessibility.AccessibilityWindowInfoCompatApi21;

public class AccessibilityWindowInfoCompat {
    private static final AccessibilityWindowInfoImpl IMPL = Build.VERSION.SDK_INT >= 21 ? new AccessibilityWindowInfoApi21Impl() : new AccessibilityWindowInfoStubImpl();
    private static final int UNDEFINED = -1;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_INPUT_METHOD = 2;
    public static final int TYPE_SYSTEM = 3;
    public static final int TYPE_ACCESSIBILITY_OVERLAY = 4;
    private Object mInfo;

    static AccessibilityWindowInfoCompat wrapNonNullInstance(Object object) {
        if (object != null) {
            return new AccessibilityWindowInfoCompat(object);
        }
        return null;
    }

    private AccessibilityWindowInfoCompat(Object object) {
        this.mInfo = object;
    }

    public static AccessibilityWindowInfoCompat obtain() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.obtain());
    }

    public static AccessibilityWindowInfoCompat obtain(AccessibilityWindowInfoCompat accessibilityWindowInfoCompat) {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.obtain(accessibilityWindowInfoCompat.mInfo));
    }

    private static String typeToString(int n2) {
        switch (n2) {
            default: {
                return "<UNKNOWN>";
            }
            case 4: {
                return "TYPE_ACCESSIBILITY_OVERLAY";
            }
            case 3: {
                return "TYPE_SYSTEM";
            }
            case 2: {
                return "TYPE_INPUT_METHOD";
            }
            case 1: 
        }
        return "TYPE_APPLICATION";
    }

    public int getType() {
        return IMPL.getType(this.mInfo);
    }

    public int getLayer() {
        return IMPL.getLayer(this.mInfo);
    }

    public AccessibilityNodeInfoCompat getRoot() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getRoot(this.mInfo));
    }

    public AccessibilityWindowInfoCompat getParent() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getParent(this.mInfo));
    }

    public int getId() {
        return IMPL.getId(this.mInfo);
    }

    public void getBoundsInScreen(Rect rect) {
        IMPL.getBoundsInScreen(this.mInfo, rect);
    }

    public boolean isActive() {
        return IMPL.isActive(this.mInfo);
    }

    public boolean isFocused() {
        return IMPL.isFocused(this.mInfo);
    }

    public boolean isAccessibilityFocused() {
        return IMPL.isAccessibilityFocused(this.mInfo);
    }

    public int getChildCount() {
        return IMPL.getChildCount(this.mInfo);
    }

    public AccessibilityWindowInfoCompat getChild(int n2) {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getChild(this.mInfo, n2));
    }

    public void recycle() {
        IMPL.recycle(this.mInfo);
    }

    public int hashCode() {
        Object object = ((AccessibilityWindowInfoCompat)object).mInfo;
        return object == null ? 0 : object.hashCode();
    }

    public boolean equals(Object object) {
        if (accessibilityWindowInfoCompat2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (accessibilityWindowInfoCompat2.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityWindowInfoCompat accessibilityWindowInfoCompat = accessibilityWindowInfoCompat2;
        AccessibilityWindowInfoCompat accessibilityWindowInfoCompat2 = (AccessibilityWindowInfoCompat)object;
        object = accessibilityWindowInfoCompat.mInfo;
        return !(object == null ? accessibilityWindowInfoCompat2.mInfo != null : !object.equals(accessibilityWindowInfoCompat2.mInfo));
    }

    public String toString() {
        Rect rect;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        Object object = rect;
        ((AccessibilityWindowInfoCompat)((Object)stringBuilder3)).getBoundsInScreen(new Rect());
        stringBuilder.append("AccessibilityWindowInfo[");
        stringBuilder.append("id=").append(((AccessibilityWindowInfoCompat)((Object)stringBuilder3)).getId());
        stringBuilder.append(", type=").append(AccessibilityWindowInfoCompat.typeToString(((AccessibilityWindowInfoCompat)((Object)stringBuilder3)).getType()));
        stringBuilder.append(", layer=").append(((AccessibilityWindowInfoCompat)((Object)stringBuilder3)).getLayer());
        stringBuilder.append(", bounds=").append(object);
        stringBuilder.append(", focused=").append(((AccessibilityWindowInfoCompat)((Object)stringBuilder3)).isFocused());
        stringBuilder.append(", active=").append(((AccessibilityWindowInfoCompat)((Object)stringBuilder3)).isActive());
        object = stringBuilder.append(", hasParent=");
        boolean bl = ((AccessibilityWindowInfoCompat)((Object)stringBuilder3)).getParent() != null;
        AccessibilityWindowInfoCompat accessibilityWindowInfoCompat = stringBuilder3;
        ((StringBuilder)object).append(bl);
        StringBuilder stringBuilder3 = stringBuilder2.append(", hasChildren=");
        boolean bl2 = accessibilityWindowInfoCompat.getChildCount() > 0;
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder3.append(bl2);
        stringBuilder4.append(']');
        return stringBuilder4.toString();
    }

    private static class AccessibilityWindowInfoApi21Impl
    extends AccessibilityWindowInfoStubImpl {
        private AccessibilityWindowInfoApi21Impl() {
        }

        @Override
        public Object obtain() {
            return AccessibilityWindowInfoCompatApi21.obtain();
        }

        @Override
        public Object obtain(Object object) {
            return AccessibilityWindowInfoCompatApi21.obtain(object);
        }

        @Override
        public int getType(Object object) {
            return AccessibilityWindowInfoCompatApi21.getType(object);
        }

        @Override
        public int getLayer(Object object) {
            return AccessibilityWindowInfoCompatApi21.getLayer(object);
        }

        @Override
        public Object getRoot(Object object) {
            return AccessibilityWindowInfoCompatApi21.getRoot(object);
        }

        @Override
        public Object getParent(Object object) {
            return AccessibilityWindowInfoCompatApi21.getParent(object);
        }

        @Override
        public int getId(Object object) {
            return AccessibilityWindowInfoCompatApi21.getId(object);
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
            AccessibilityWindowInfoCompatApi21.getBoundsInScreen(object, rect);
        }

        @Override
        public boolean isActive(Object object) {
            return AccessibilityWindowInfoCompatApi21.isActive(object);
        }

        @Override
        public boolean isFocused(Object object) {
            return AccessibilityWindowInfoCompatApi21.isFocused(object);
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return AccessibilityWindowInfoCompatApi21.isAccessibilityFocused(object);
        }

        @Override
        public int getChildCount(Object object) {
            return AccessibilityWindowInfoCompatApi21.getChildCount(object);
        }

        @Override
        public Object getChild(Object object, int n2) {
            return AccessibilityWindowInfoCompatApi21.getChild(object, n2);
        }

        @Override
        public void recycle(Object object) {
            AccessibilityWindowInfoCompatApi21.recycle(object);
        }
    }

    private static class AccessibilityWindowInfoStubImpl
    implements AccessibilityWindowInfoImpl {
        private AccessibilityWindowInfoStubImpl() {
        }

        @Override
        public Object obtain() {
            return null;
        }

        @Override
        public Object obtain(Object object) {
            return null;
        }

        @Override
        public int getType(Object object) {
            return -1;
        }

        @Override
        public int getLayer(Object object) {
            return -1;
        }

        @Override
        public Object getRoot(Object object) {
            return null;
        }

        @Override
        public Object getParent(Object object) {
            return null;
        }

        @Override
        public int getId(Object object) {
            return -1;
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
        }

        @Override
        public boolean isActive(Object object) {
            return true;
        }

        @Override
        public boolean isFocused(Object object) {
            return true;
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return true;
        }

        @Override
        public int getChildCount(Object object) {
            return 0;
        }

        @Override
        public Object getChild(Object object, int n2) {
            return null;
        }

        @Override
        public void recycle(Object object) {
        }
    }

    private static interface AccessibilityWindowInfoImpl {
        public Object obtain();

        public Object obtain(Object var1);

        public int getType(Object var1);

        public int getLayer(Object var1);

        public Object getRoot(Object var1);

        public Object getParent(Object var1);

        public int getId(Object var1);

        public void getBoundsInScreen(Object var1, Rect var2);

        public boolean isActive(Object var1);

        public boolean isFocused(Object var1);

        public boolean isAccessibilityFocused(Object var1);

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public void recycle(Object var1);
    }
}

