/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.wear.callback;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import androidx.annotation.NonNull;
import com.android.chileaf.bluetooth.connect.callback.profile.ProfileReadResponse;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.wear.callback.BodySportCallback;

public abstract class BodySportDataCallback
extends ProfileReadResponse
implements BodySportCallback {
    public BodySportDataCallback() {
    }

    protected BodySportDataCallback(Parcel in) {
        super(in);
    }

    @Override
    public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
        super.onDataReceived(device, data);
        if (data.size() < 2) {
            this.onInvalidDataReceived(device, data);
            return;
        }
        byte[] value = data.getValue();
        try {
            if (value.length == 20 && this.getByte(value[5]) == 1 && this.getByte(value[7]) == 1) {
                int step = this.getValue(value[10], value[11], value[12]);
                int distance = this.getValue(value[13], value[14], value[15]);
                int calorie = this.getValue(value[16], value[17], value[18]);
                this.onSportReceived(device, step, distance, calorie);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getValue(byte high, byte mid, byte low) {
        return (this.getByte(high) << 16) + (this.getByte(mid) << 8) + this.getByte(low);
    }

    private int getByte(byte value) {
        return value & 0xFF;
    }
}

