/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.wear;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.ParcelUuid;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.BleManager;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.connect.utils.ParserUtils;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerCompat;
import com.android.chileaf.bluetooth.scanner.ScanCallback;
import com.android.chileaf.bluetooth.scanner.ScanFilter;
import com.android.chileaf.bluetooth.scanner.ScanSettings;
import com.android.chileaf.fitness.FitnessManager;
import com.android.chileaf.fitness.common.heart.BodySensorLocationDataCallback;
import com.android.chileaf.fitness.common.heart.HeartRateMeasurementDataCallback;
import com.android.chileaf.fitness.common.parser.BodySensorLocationParser;
import com.android.chileaf.fitness.common.parser.HeartRateMeasurementParser;
import com.android.chileaf.wear.WearManagerCallbacks;
import com.android.chileaf.wear.callback.BodySportDataCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class WearManager
extends FitnessManager<WearManagerCallbacks> {
    private static final UUID HR_SERVICE_UUID = UUID.fromString("0000180D-0000-1000-8000-00805f9b34fb");
    private static final UUID BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID = UUID.fromString("00002A38-0000-1000-8000-00805f9b34fb");
    private static final UUID HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID = UUID.fromString("00002A37-0000-1000-8000-00805f9b34fb");
    private ScanCallback mScanCallback;
    private static WearManager managerInstance = null;
    private BluetoothGattCharacteristic mHeartRateCharacteristic;
    private BluetoothGattCharacteristic mBodySensorLocationCharacteristic;
    private final BodySensorLocationDataCallback mBodySensorLocationDataCallback = new BodySensorLocationDataCallback(){

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(4, BodySensorLocationParser.parse(data) + " received");
            super.onDataReceived(device, data);
        }

        @Override
        public void onBodySensorLocationReceived(@NonNull BluetoothDevice device, int sensorLocation) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onBodySensorLocationReceived(device, sensorLocation);
        }
    };
    private final HeartRateMeasurementDataCallback mHeartRateMeasureDataCallback = new HeartRateMeasurementDataCallback(){

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(4, HeartRateMeasurementParser.parse(data) + " received");
            super.onDataReceived(device, data);
        }

        @Override
        public void onHeartRateMeasurementReceived(@NonNull BluetoothDevice device, int heartRate, @Nullable Boolean contactDetected, @Nullable Integer energyExpanded, @Nullable List<Integer> rrIntervals) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onHeartRateMeasurementReceived(device, heartRate, contactDetected, energyExpanded, rrIntervals);
        }
    };
    private final BodySportDataCallback mBodySportDataCallback = new BodySportDataCallback(){

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(4, "receive:" + ParserUtils.parse(data.getValue()));
            super.onDataReceived(device, data);
        }

        @Override
        public void onSportReceived(@NonNull BluetoothDevice device, int step, int distance, int calorie) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onSportReceived(device, step, distance, calorie);
        }
    };

    public static synchronized WearManager getInstance(Context context) {
        if (managerInstance == null) {
            managerInstance = new WearManager(context.getApplicationContext());
        }
        return managerInstance;
    }

    private WearManager(Context context) {
        super(context);
    }

    @Override
    @NonNull
    protected BleManager.BleManagerGattCallback getGattCallback() {
        return new WearManagerGattCallback();
    }

    public void startScan(ScanCallback scanCallback) {
        this.mScanCallback = scanCallback;
        BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
        ScanSettings settings = new ScanSettings.Builder().setLegacy(false).setReportDelay(1000L).setUseHardwareBatchingIfSupported(false).setScanMode(2).build();
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        ParcelUuid uuid = new ParcelUuid(HR_SERVICE_UUID);
        filters.add(new ScanFilter.Builder().setServiceUuid(uuid).build());
        scanner.startScan(filters, settings, this.mScanCallback);
    }

    public void stopScan() {
        if (this.mScanCallback != null) {
            BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
            scanner.stopScan(this.mScanCallback);
        }
    }

    private final class WearManagerGattCallback
    extends FitnessManager.FitnessManagerGattCallback {
        private WearManagerGattCallback() {
        }

        @Override
        protected void initialize() {
            super.initialize();
            WearManager.this.readCharacteristic(WearManager.this.mBodySensorLocationCharacteristic).with(WearManager.this.mBodySensorLocationDataCallback).done(device -> WearManager.this.log(4, "Body Sensor Location readCharacteristic success")).fail((device, status) -> WearManager.this.log(5, "Body Sensor Location characteristic not found")).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mHeartRateCharacteristic).with(WearManager.this.mHeartRateMeasureDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mHeartRateCharacteristic).done(device -> WearManager.this.log(4, "Heart Rate notifications enabled")).fail((device, status) -> WearManager.this.log(5, "Heart Rate characteristic not found")).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mRXCharacteristic).with(WearManager.this.mBodySportDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mRXCharacteristic).done(device -> WearManager.this.log(4, "Rx notifications enabled")).fail((device, status) -> WearManager.this.log(5, "Rx characteristic not found")).enqueue();
        }

        @Override
        protected boolean isRequiredServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isRequiredServiceSupported(gatt);
            BluetoothGattService hrService = gatt.getService(HR_SERVICE_UUID);
            if (hrService != null) {
                WearManager.this.mHeartRateCharacteristic = hrService.getCharacteristic(HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mHeartRateCharacteristic != null;
        }

        @Override
        protected boolean isOptionalServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isOptionalServiceSupported(gatt);
            BluetoothGattService service = gatt.getService(HR_SERVICE_UUID);
            if (service != null) {
                WearManager.this.mBodySensorLocationCharacteristic = service.getCharacteristic(BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mBodySensorLocationCharacteristic != null;
        }

        @Override
        protected void onDeviceDisconnected() {
            super.onDeviceDisconnected();
            WearManager.this.mBodySensorLocationCharacteristic = null;
            WearManager.this.mHeartRateCharacteristic = null;
        }
    }
}

