/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HexUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Map<Character, byte[]> SPEC_CHARS = new HashMap<Character, byte[]>(){
        {
            this.put(Character.valueOf('\u00f3'), new byte[]{111});
            this.put(Character.valueOf('\u00d3'), new byte[]{79});
            this.put(Character.valueOf('\u00ed'), new byte[]{105});
            this.put(Character.valueOf('\u00cd'), new byte[]{73});
            this.put(Character.valueOf('\u00fa'), new byte[]{117});
            this.put(Character.valueOf('\u00da'), new byte[]{85});
            this.put(Character.valueOf('\u00c7'), new byte[]{-128});
            this.put(Character.valueOf('\u00fc'), new byte[]{-127});
            this.put(Character.valueOf('\u00e9'), new byte[]{-126});
            this.put(Character.valueOf('\u00e2'), new byte[]{-125});
            this.put(Character.valueOf('\u00e4'), new byte[]{-124});
            this.put(Character.valueOf('\u00e0'), new byte[]{-123});
            this.put(Character.valueOf('\u00e3'), new byte[]{-122});
            this.put(Character.valueOf('\u00e7'), new byte[]{-121});
            this.put(Character.valueOf('\u00ea'), new byte[]{-120});
            this.put(Character.valueOf('\u00eb'), new byte[]{-119});
            this.put(Character.valueOf('\u00cf'), new byte[]{-117});
            this.put(Character.valueOf('\u00e8'), new byte[]{-118});
            this.put(Character.valueOf('\u00ce'), new byte[]{-116});
            this.put(Character.valueOf('\u00cc'), new byte[]{-115});
            this.put(Character.valueOf('\u00c3'), new byte[]{-114});
            this.put(Character.valueOf('\u00c4'), new byte[]{-113});
            this.put(Character.valueOf('\u00c9'), new byte[]{-112});
            this.put(Character.valueOf('\u00e6'), new byte[]{-111});
            this.put(Character.valueOf('\u00c6'), new byte[]{-110});
            this.put(Character.valueOf('\u00f4'), new byte[]{-109});
            this.put(Character.valueOf('\u00f6'), new byte[]{-108});
            this.put(Character.valueOf('\u00f2'), new byte[]{-107});
            this.put(Character.valueOf('\u00fb'), new byte[]{-106});
            this.put(Character.valueOf('\u00f9'), new byte[]{-105});
            this.put(Character.valueOf('\u00ff'), new byte[]{-104});
            this.put(Character.valueOf('\u00d6'), new byte[]{-103});
            this.put(Character.valueOf('\u00dc'), new byte[]{-102});
            this.put(Character.valueOf('\u00a2'), new byte[]{-101});
            this.put(Character.valueOf('\u00a3'), new byte[]{-100});
            this.put(Character.valueOf('\u00a5'), new byte[]{-99});
            this.put(Character.valueOf('\u0192'), new byte[]{-97});
            this.put(Character.valueOf('\u00e1'), new byte[]{-96});
            this.put(Character.valueOf('\u00f1'), new byte[]{-92});
            this.put(Character.valueOf('\u00d1'), new byte[]{-91});
            this.put(Character.valueOf('\u00aa'), new byte[]{-90});
            this.put(Character.valueOf('\u00ba'), new byte[]{-89});
            this.put(Character.valueOf('\u00bf'), new byte[]{-88});
            this.put(Character.valueOf('\u00ac'), new byte[]{-86});
            this.put(Character.valueOf('\u00bd'), new byte[]{-85});
            this.put(Character.valueOf('\u00bc'), new byte[]{-84});
            this.put(Character.valueOf('\u00a1'), new byte[]{-83});
            this.put(Character.valueOf('\u00ab'), new byte[]{-82});
            this.put(Character.valueOf('\u00bb'), new byte[]{-81});
            this.put(Character.valueOf('\u00b0'), new byte[]{-95, -29});
        }
    };

    public static char[] encodeHex(byte[] data) {
        return HexUtil.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtil.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        if (data == null) {
            return new char[0];
        }
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtil.encodeHexStr(data, true);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexUtil.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexUtil.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtil.toDigit(data[j], j) << 4;
            f |= HexUtil.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return new byte[0];
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(HexUtil.charToByte(hexChars[pos]) << 4 | HexUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte[] fromHexString(String hexString) {
        if (null == hexString || "".equals(hexString.trim())) {
            return new byte[0];
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length() / 2; ++i) {
            String hex = hexString.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(hex, 16);
        }
        return bytes;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String byteArrayToString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte datum : data) {
            char temp = (char)datum;
            if (temp == '\u0000') continue;
            sb.append(temp);
        }
        return sb.toString();
    }

    public static String splitToHexString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            byte datum = data[i];
            String hex = Integer.toHexString(datum & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            if (datum == 44) {
                char ch = (char)datum;
                sb.append(ch);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String getAsciiString(byte[] data, int offset, int length) {
        return new String(data, offset, length, Charset.forName("US-ASCII"));
    }

    public static String getAsciiString(byte[] data) {
        return HexUtil.getAsciiString(data, 0, data.length);
    }

    public static String getUnicodeString(byte[] data) {
        return HexUtil.getAsciiString(data, 0, data.length);
    }

    public static byte[] string2Bytes(String data) {
        byte[] array = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            array[i] = (byte)data.charAt(i);
        }
        return array;
    }

    public static String bytes2HexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String hex2String(String hex) {
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int str = Integer.parseInt(output, 16);
            sb.append((char)str);
            temp.append(str);
        }
        return sb.toString();
    }

    public static String binaryToHex(String binary) {
        StringBuffer sb = new StringBuffer();
        String hex = Integer.toHexString(Integer.parseInt(binary, 2));
        if (hex.length() < 2) {
            sb.append(0);
        }
        sb.append(hex);
        return sb.toString();
    }

    public static byte[] compose(int ... bytes) {
        byte[] dest = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            dest[i] = (byte)(bytes[i] & 0xFF);
        }
        return dest;
    }

    public static byte[] compose(byte ... bytes) {
        byte[] dest = new byte[bytes.length];
        System.arraycopy(bytes, 0, dest, 0, bytes.length);
        return dest;
    }

    public static byte[] subByte(byte[] source, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(source, 0, dest, 0, dest.length);
        return dest;
    }

    public static byte[] subByte(byte[] source, int start, int end) {
        byte[] dest = new byte[end - start];
        System.arraycopy(source, start, dest, 0, dest.length);
        return dest;
    }

    public static byte[] subByteByLength(byte[] source, int start, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(source, start, dest, 0, dest.length);
        return dest;
    }

    public static int[] append(int source, int[] dest) {
        int[] result = new int[1 + dest.length];
        result[0] = source;
        System.arraycopy(dest, 0, result, 1, dest.length);
        return result;
    }

    public static byte[] append(byte source, byte[] dest) {
        byte[] temp = new byte[]{source};
        return HexUtil.append(temp, dest);
    }

    public static byte[] append(byte[] source, byte dest) {
        byte[] result = new byte[source.length + 1];
        byte[] temp = new byte[]{dest};
        System.arraycopy(source, 0, result, 0, source.length);
        System.arraycopy(temp, 0, result, result.length - 1, 1);
        return result;
    }

    public static byte[] append(byte[] source, byte[] dest) {
        byte[] result = new byte[source.length + dest.length];
        System.arraycopy(source, 0, result, 0, source.length);
        int offset = result.length - dest.length;
        System.arraycopy(dest, 0, result, offset, dest.length);
        return result;
    }

    public static byte[] append(byte[] ... bytes) {
        byte[] dest = new byte[]{};
        for (byte[] outs : bytes) {
            dest = HexUtil.append(dest, outs);
        }
        return dest;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] encodeString(String s, boolean isUnicode) {
        ArrayList<Byte> outBytes = new ArrayList<Byte>();
        for (int i = 0; i < s.length(); ++i) {
            int j0;
            byte[] cs;
            char c = s.charAt(i);
            if (SPEC_CHARS.containsKey(Character.valueOf(c))) {
                cs = SPEC_CHARS.get(Character.valueOf(c));
            } else {
                try {
                    cs = isUnicode ? Character.toString(c).getBytes("Unicode") : Character.toString(c).getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    cs = Character.toString(c).getBytes();
                }
            }
            for (int j = j0 = isUnicode && i != 0 ? 2 : 0; j < cs.length; ++j) {
                outBytes.add(cs[j]);
            }
        }
        return HexUtil.toPrimitive(outBytes.toArray(new Byte[0]));
    }

    public static byte[] stampToBytes(long stamp) {
        byte[] utcArray = new byte[]{(byte)(stamp >> 24 & 0xFFL), (byte)(stamp >> 16 & 0xFFL), (byte)(stamp >> 8 & 0xFFL), (byte)(stamp & 0xFFL)};
        return utcArray;
    }
}

