/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.fitness.common.parser;

import com.android.chileaf.bluetooth.connect.data.Data;
import java.util.Locale;

public class RSCMeasurementParser {
    private static final byte INSTANTANEOUS_STRIDE_LENGTH_PRESENT = 1;
    private static final byte TOTAL_DISTANCE_PRESENT = 2;
    private static final byte WALKING_OR_RUNNING_STATUS_BITS = 4;

    public static String parse(Data data) {
        int offset = 0;
        byte flags = data.getValue()[offset];
        boolean islmPresent = (flags & 1) > 0;
        boolean tdPreset = (flags & 2) > 0;
        boolean running = (flags & 4) > 0;
        boolean walking = !running;
        float instantaneousSpeed = (float)data.getIntValue(18, ++offset).intValue() / 256.0f;
        int instantaneousCadence = data.getIntValue(17, offset += 2);
        ++offset;
        float instantaneousStrideLength = 0.0f;
        if (islmPresent) {
            instantaneousStrideLength = (float)data.getIntValue(18, offset).intValue() / 100.0f;
            offset += 2;
        }
        float totalDistance = 0.0f;
        if (tdPreset) {
            totalDistance = (float)data.getIntValue(20, offset).intValue() / 10.0f;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(Locale.US, "Speed: %.2f m/s, Cadence: %d RPM,", Float.valueOf(instantaneousSpeed), instantaneousCadence));
        if (islmPresent) {
            builder.append(String.format(Locale.US, "Instantaneous Stride Length: %.2f m,", Float.valueOf(instantaneousStrideLength)));
        }
        if (tdPreset) {
            builder.append(String.format(Locale.US, "Total Distance: %.1f m,", Float.valueOf(totalDistance)));
        }
        if (walking) {
            builder.append("Status: WALKING");
        } else {
            builder.append("Status: RUNNING");
        }
        return builder.toString();
    }
}

