/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.scanner;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerCompat;
import com.android.chileaf.bluetooth.scanner.PendingIntentExecutor;
import com.android.chileaf.bluetooth.scanner.ScanCallback;
import com.android.chileaf.bluetooth.scanner.ScanFilter;
import com.android.chileaf.bluetooth.scanner.ScanSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ScannerService
extends Service {
    private static final String TAG = "ScannerService";
    static final String EXTRA_PENDING_INTENT = "com.android.chileaf.bluetooth.EXTRA_PENDING_INTENT";
    static final String EXTRA_FILTERS = "com.android.chileaf.bluetooth.EXTRA_FILTERS";
    static final String EXTRA_SETTINGS = "com.android.chileaf.bluetooth.EXTRA_SETTINGS";
    static final String EXTRA_START = "com.android.chileaf.bluetooth.EXTRA_START";
    @NonNull
    private final Object LOCK = new Object();
    private HashMap<PendingIntent, ScanCallback> callbacks;
    private Handler handler;

    public void onCreate() {
        super.onCreate();
        this.callbacks = new HashMap();
        this.handler = new Handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public int onStartCommand(Intent intent, int flags, int startId) {
        boolean knownCallback;
        boolean stop;
        PendingIntent callbackIntent = (PendingIntent)intent.getParcelableExtra(EXTRA_PENDING_INTENT);
        boolean start = intent.getBooleanExtra(EXTRA_START, false);
        boolean bl = stop = !start;
        if (callbackIntent == null) {
            boolean shouldStop;
            Object object = this.LOCK;
            synchronized (object) {
                shouldStop = this.callbacks.isEmpty();
            }
            if (shouldStop) {
                this.stopSelf();
            }
            return 2;
        }
        Object object = this.LOCK;
        synchronized (object) {
            knownCallback = this.callbacks.containsKey(callbackIntent);
        }
        if (start && !knownCallback) {
            ArrayList filters = intent.getParcelableArrayListExtra(EXTRA_FILTERS);
            ScanSettings settings = (ScanSettings)intent.getParcelableExtra(EXTRA_SETTINGS);
            this.startScan((List<ScanFilter>)(filters != null ? filters : Collections.emptyList()), settings != null ? settings : new ScanSettings.Builder().build(), callbackIntent);
        } else if (stop && knownCallback) {
            this.stopScan(callbackIntent);
        }
        return 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public void onDestroy() {
        BluetoothLeScannerCompat scannerCompat = BluetoothLeScannerCompat.getScanner();
        for (ScanCallback callback : this.callbacks.values()) {
            try {
                scannerCompat.stopScan(callback);
            }
            catch (Exception exception) {}
        }
        this.callbacks.clear();
        this.callbacks = null;
        this.handler = null;
        super.onDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    private void startScan(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull PendingIntent callbackIntent) {
        PendingIntentExecutor executor = new PendingIntentExecutor(callbackIntent, settings, this);
        Object object = this.LOCK;
        synchronized (object) {
            this.callbacks.put(callbackIntent, executor);
        }
        try {
            BluetoothLeScannerCompat scannerCompat = BluetoothLeScannerCompat.getScanner();
            scannerCompat.startScanInternal(filters, settings, executor, this.handler);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Starting scanning failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    private void stopScan(@NonNull PendingIntent callbackIntent) {
        boolean shouldStop;
        ScanCallback callback;
        Object object = this.LOCK;
        synchronized (object) {
            callback = this.callbacks.remove(callbackIntent);
            shouldStop = this.callbacks.isEmpty();
        }
        if (callback == null) {
            return;
        }
        try {
            BluetoothLeScannerCompat scannerCompat = BluetoothLeScannerCompat.getScanner();
            scannerCompat.stopScan(callback);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Stopping scanning failed", (Throwable)e);
        }
        if (shouldStop) {
            this.stopSelf();
        }
    }
}

