/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import androidx.annotation.NonNull;
import com.android.chileaf.bluetooth.connect.Operation;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.SimpleValueRequest;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.PhyCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;

public final class PhyRequest
extends SimpleValueRequest<PhyCallback>
implements Operation {
    public static final int PHY_LE_1M_MASK = 1;
    public static final int PHY_LE_2M_MASK = 2;
    public static final int PHY_LE_CODED_MASK = 4;
    public static final int PHY_OPTION_NO_PREFERRED = 0;
    public static final int PHY_OPTION_S2 = 1;
    public static final int PHY_OPTION_S8 = 2;
    private final int txPhy;
    private final int rxPhy;
    private final int phyOptions;

    PhyRequest(@NonNull Request.Type type) {
        super(type);
        this.txPhy = 0;
        this.rxPhy = 0;
        this.phyOptions = 0;
    }

    PhyRequest(@NonNull Request.Type type, int txPhy, int rxPhy, int phyOptions) {
        super(type);
        if ((txPhy & 0xFFFFFFF8) > 0) {
            txPhy = 1;
        }
        if ((rxPhy & 0xFFFFFFF8) > 0) {
            rxPhy = 1;
        }
        if (phyOptions < 0 || phyOptions > 2) {
            phyOptions = 0;
        }
        this.txPhy = txPhy;
        this.rxPhy = rxPhy;
        this.phyOptions = phyOptions;
    }

    @Override
    @NonNull
    PhyRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public PhyRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public PhyRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public PhyRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public PhyRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public PhyRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public PhyRequest with(@NonNull PhyCallback callback) {
        super.with(callback);
        return this;
    }

    void notifyPhyChanged(@NonNull BluetoothDevice device, int txPhy, int rxPhy) {
        this.handler.post(() -> {
            if (this.valueCallback != null) {
                ((PhyCallback)this.valueCallback).onPhyChanged(device, txPhy, rxPhy);
            }
        });
    }

    void notifyLegacyPhy(@NonNull BluetoothDevice device) {
        this.handler.post(() -> {
            if (this.valueCallback != null) {
                ((PhyCallback)this.valueCallback).onPhyChanged(device, 1, 1);
            }
        });
    }

    int getPreferredTxPhy() {
        return this.txPhy;
    }

    int getPreferredRxPhy() {
        return this.rxPhy;
    }

    int getPreferredPhyOptions() {
        return this.phyOptions;
    }
}

