/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.AwaitingRequest;
import com.android.chileaf.bluetooth.connect.Operation;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;

public final class ConditionalWaitRequest<T>
extends AwaitingRequest
implements Operation {
    @NonNull
    private final Condition<T> condition;
    @Nullable
    private final T parameter;
    private boolean expected = false;

    ConditionalWaitRequest(@NonNull Request.Type type, @NonNull Condition<T> condition, @Nullable T parameter) {
        super(type);
        this.condition = condition;
        this.parameter = parameter;
    }

    @Override
    @NonNull
    ConditionalWaitRequest<T> setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public ConditionalWaitRequest<T> negate() {
        this.expected = true;
        return this;
    }

    boolean isFulfilled() {
        try {
            return this.condition.predicate(this.parameter) == this.expected;
        }
        catch (Exception e) {
            Log.e((String)"ConditionalWaitRequest", (String)"Error while checking predicate", (Throwable)e);
            return true;
        }
    }

    public static interface Condition<T> {
        public boolean predicate(@Nullable T var1);
    }
}

