/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanResult;
import android.os.ParcelUuid;
import android.util.SparseArray;
import io.dcloud.common.util.PdrUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DCBluetoothDevice {
    private String deviceId;
    private String name;
    private int RSSI;
    private String advertisData;
    private JSONObject serviceData;
    private JSONArray advertisServiceUUIDs;
    private String localName;
    private static final int DATA_TYPE_FLAGS = 1;
    private static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL = 2;
    private static final int DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE = 3;
    private static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL = 4;
    private static final int DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE = 5;
    private static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL = 6;
    private static final int DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE = 7;
    private static final int DATA_TYPE_LOCAL_NAME_SHORT = 8;
    private static final int DATA_TYPE_LOCAL_NAME_COMPLETE = 9;
    private static final int DATA_TYPE_TX_POWER_LEVEL = 10;
    private static final int DATA_TYPE_SERVICE_DATA_16_BIT = 22;
    private static final int DATA_TYPE_SERVICE_DATA_32_BIT = 32;
    private static final int DATA_TYPE_SERVICE_DATA_128_BIT = 33;
    private static final int DATA_TYPE_MANUFACTURER_SPECIFIC_DATA = 255;
    public static final ParcelUuid BASE_UUID = ParcelUuid.fromString((String)"00000000-0000-1000-8000-00805F9B34FB");
    public static final int UUID_BYTES_16_BIT = 2;
    public static final int UUID_BYTES_32_BIT = 4;
    public static final int UUID_BYTES_128_BIT = 16;

    @TargetApi(value=21)
    public DCBluetoothDevice(ScanResult result) {
        this.setDeviceId(result.getDevice().getAddress());
        this.setName(PdrUtil.isEmpty((Object)result.getDevice().getName()) ? "" : result.getDevice().getName());
        this.setRSSI(result.getRssi());
        SparseArray mManufacturerSpecificData = result.getScanRecord().getManufacturerSpecificData();
        if (null != mManufacturerSpecificData && mManufacturerSpecificData.size() > 0) {
            this.setAdvertisData(DCBluetoothDevice.bytesToHexString((byte[])mManufacturerSpecificData.valueAt(0)));
        }
        this.setLocalName(PdrUtil.isEmpty((Object)result.getScanRecord().getDeviceName()) ? "" : result.getScanRecord().getDeviceName());
        try {
            this.setServiceData(this.map2Str(result.getScanRecord().getServiceData()));
            this.setAdvertisServiceUUIDs(this.list2Str(result.getScanRecord().getServiceUuids()));
        }
        catch (JSONException e) {
            this.setAdvertisServiceUUIDs(new JSONArray());
        }
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public DCBluetoothDevice(BluetoothDevice device, byte[] result) {
        this.setDeviceId(device.getAddress());
        this.setName(PdrUtil.isEmpty((Object)device.getName()) ? "" : device.getName());
        this.parseFromBytes(result);
    }

    private void parseFromBytes(byte[] scanRecord) {
        if (scanRecord == null) {
            return;
        }
        int advertiseFlag = -1;
        ArrayList<ParcelUuid> serviceUuids = new ArrayList<ParcelUuid>();
        String localName = "";
        int txPowerLevel = Integer.MIN_VALUE;
        SparseArray manufacturerData = new SparseArray();
        HashMap<ParcelUuid, byte[]> serviceData = new HashMap<ParcelUuid, byte[]>();
        try {
            int length;
            int dataLength;
            block14: for (int currentPos = 0; currentPos < scanRecord.length && (length = scanRecord[currentPos++] & 0xFF) != 0; currentPos += dataLength) {
                dataLength = length - 1;
                int fieldType = scanRecord[currentPos++] & 0xFF;
                switch (fieldType) {
                    case 1: {
                        advertiseFlag = scanRecord[currentPos] & 0xFF;
                        continue block14;
                    }
                    case 2: 
                    case 3: {
                        this.parseServiceUuid(scanRecord, currentPos, dataLength, 2, serviceUuids);
                        continue block14;
                    }
                    case 4: 
                    case 5: {
                        this.parseServiceUuid(scanRecord, currentPos, dataLength, 4, serviceUuids);
                        continue block14;
                    }
                    case 6: 
                    case 7: {
                        this.parseServiceUuid(scanRecord, currentPos, dataLength, 16, serviceUuids);
                        continue block14;
                    }
                    case 8: 
                    case 9: {
                        localName = new String(this.extractBytes(scanRecord, currentPos, dataLength));
                        continue block14;
                    }
                    case 10: {
                        txPowerLevel = scanRecord[currentPos];
                        continue block14;
                    }
                    case 22: 
                    case 32: 
                    case 33: {
                        int serviceUuidLength = 2;
                        if (fieldType == 32) {
                            serviceUuidLength = 4;
                        } else if (fieldType == 33) {
                            serviceUuidLength = 16;
                        }
                        byte[] serviceDataUuidBytes = this.extractBytes(scanRecord, currentPos, serviceUuidLength);
                        ParcelUuid serviceDataUuid = this.parseUuidFrom(serviceDataUuidBytes);
                        byte[] serviceDataArray = this.extractBytes(scanRecord, currentPos + serviceUuidLength, dataLength - serviceUuidLength);
                        serviceData.put(serviceDataUuid, serviceDataArray);
                        continue block14;
                    }
                    case 255: {
                        int manufacturerId = ((scanRecord[currentPos + 1] & 0xFF) << 8) + (scanRecord[currentPos] & 0xFF);
                        byte[] manufacturerDataBytes = this.extractBytes(scanRecord, currentPos, dataLength);
                        manufacturerData.put(manufacturerId, (Object)manufacturerDataBytes);
                        continue block14;
                    }
                }
            }
            if (serviceUuids.isEmpty()) {
                serviceUuids = null;
            }
        }
        catch (Exception length) {
            // empty catch block
        }
        this.setLocalName(PdrUtil.isEmpty((Object)localName) ? "" : localName);
        try {
            this.setServiceData(this.map2Str(serviceData));
            this.setAdvertisServiceUUIDs(this.list2Str(serviceUuids));
        }
        catch (JSONException e) {
            this.setAdvertisServiceUUIDs(new JSONArray());
        }
        if (manufacturerData.size() > 0) {
            byte[] all = new byte[]{};
            for (int i = 0; i < manufacturerData.size(); ++i) {
                if (manufacturerData.valueAt(i) == null) continue;
                all = DCBluetoothDevice.concat(all, (byte[])manufacturerData.valueAt(i));
            }
            this.setAdvertisData(DCBluetoothDevice.bytesToHexString(all));
        }
    }

    private int parseServiceUuid(byte[] scanRecord, int currentPos, int dataLength, int uuidLength, List<ParcelUuid> serviceUuids) {
        while (dataLength > 0) {
            byte[] uuidBytes = this.extractBytes(scanRecord, currentPos, uuidLength);
            serviceUuids.add(this.parseUuidFrom(uuidBytes));
            dataLength -= uuidLength;
            currentPos += uuidLength;
        }
        return currentPos;
    }

    public ParcelUuid parseUuidFrom(byte[] uuidBytes) {
        long shortUuid;
        if (uuidBytes == null) {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
        int length = uuidBytes.length;
        if (length != 2 && length != 4 && length != 16) {
            throw new IllegalArgumentException("uuidBytes length invalid - " + length);
        }
        if (length == 16) {
            ByteBuffer buf = ByteBuffer.wrap(uuidBytes).order(ByteOrder.LITTLE_ENDIAN);
            long msb = buf.getLong(8);
            long lsb = buf.getLong(0);
            return new ParcelUuid(new UUID(msb, lsb));
        }
        if (length == 2) {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
        } else {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
            shortUuid += (long)((uuidBytes[2] & 0xFF) << 16);
            shortUuid += (long)((uuidBytes[3] & 0xFF) << 24);
        }
        long msb = BASE_UUID.getUuid().getMostSignificantBits() + (shortUuid << 32);
        long lsb = BASE_UUID.getUuid().getLeastSignificantBits();
        return new ParcelUuid(new UUID(msb, lsb));
    }

    private byte[] extractBytes(byte[] scanRecord, int start, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(scanRecord, start, bytes, 0, length);
        return bytes;
    }

    private JSONObject map2Str(Map<ParcelUuid, byte[]> map) throws JSONException {
        JSONObject object = new JSONObject();
        if (null != map) {
            for (ParcelUuid key : map.keySet()) {
                object.put(key.toString().toUpperCase(), (Object)DCBluetoothDevice.bytesToHexString(map.get(key)));
            }
        }
        if (object.length() <= 0) {
            return null;
        }
        return object;
    }

    private JSONArray list2Str(List<ParcelUuid> list) {
        JSONArray array = new JSONArray();
        if (list != null) {
            for (ParcelUuid object : list) {
                array.put((Object)object.toString().toUpperCase());
            }
        }
        return array;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public DCBluetoothDevice(String deviceId, String name, int RSSI, String advertisData, JSONObject serviceData, JSONArray advertisServiceUUIDs) {
        this.deviceId = deviceId;
        this.name = name;
        this.RSSI = RSSI;
        this.advertisData = advertisData;
        this.serviceData = serviceData;
        this.advertisServiceUUIDs = advertisServiceUUIDs;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRSSI() {
        return this.RSSI;
    }

    public void setRSSI(int RSSI) {
        this.RSSI = RSSI;
    }

    public String getAdvertisData() {
        return this.advertisData;
    }

    public void setAdvertisData(String advertisData) {
        this.advertisData = advertisData;
    }

    public JSONObject getServiceData() {
        return this.serviceData;
    }

    public void setServiceData(JSONObject serviceData) {
        this.serviceData = serviceData;
    }

    public JSONArray getAdvertisServiceUUIDs() {
        return this.advertisServiceUUIDs;
    }

    public void setAdvertisServiceUUIDs(JSONArray advertisServiceUUIDs) {
        this.advertisServiceUUIDs = advertisServiceUUIDs;
    }

    public String toString() {
        JSONObject object = new JSONObject();
        try {
            object.put("deviceId", (Object)this.deviceId);
            object.put("name", (Object)this.name);
            object.put("RSSI", this.RSSI);
            object.put("localName", (Object)this.localName);
            object.put("advertisServiceUUIDs", (Object)this.advertisServiceUUIDs);
            if (null != this.advertisData) {
                object.put("advertisData", (Object)this.advertisData);
            }
            if (null != this.serviceData) {
                object.put("serviceData", (Object)this.serviceData);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object.toString();
    }
}

