/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.bluetooth.BluetoothBaseAdapter;
import io.dcloud.feature.bluetooth.DCBluetoothDevice;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class BluetoothUnder21
extends BluetoothBaseAdapter {
    private BTScanCallback m21ScanCallback;

    @Override
    public void closeBluetoothAdapter(IWebview pwebview, JSONArray args) {
        BluetoothAdapter adapter;
        super.closeBluetoothAdapter(pwebview, args);
        if (this.isSearchBTDevice && null != (adapter = BluetoothAdapter.getDefaultAdapter()) && null != this.m21ScanCallback) {
            adapter.stopLeScan((BluetoothAdapter.LeScanCallback)this.m21ScanCallback);
            this.isSearchBTDevice = false;
        }
    }

    @Override
    public void startBluetoothDevicesDiscovery(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        JSONObject param = args.optJSONObject(1);
        JSONArray serviceIds = param.optJSONArray("services");
        this.allowDuplicatesDevice = param.optBoolean("allowDuplicatesKey", false);
        String interval = param.optString("interval");
        if (this.isInit) {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null) {
                this.m21ScanCallback = new BTScanCallback();
                if (serviceIds != null) {
                    UUID[] uUIDArray = new UUID[serviceIds.length()];
                }
                if (adapter.startLeScan((BluetoothAdapter.LeScanCallback)this.m21ScanCallback)) {
                    Intent intent = new Intent();
                    intent.setAction(this.STATUS_ACTION);
                    intent.putExtra("android.bluetooth.adapter.extra.STATE", 12);
                    pwebview.getContext().sendBroadcast(intent);
                    this.isSearchBTDevice = true;
                    JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{0, "ok"}), (int)JSUtil.OK, (boolean)true, (boolean)false);
                } else {
                    JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10015, "startBluetoothDevicesDiscovery fail"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
                }
            } else {
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10010, "unsupport"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            }
        } else {
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10000, "not init"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    @Override
    public void stopBluetoothDevicesDiscovery(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        if (this.isInit) {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (null != this.m21ScanCallback && null != adapter) {
                adapter.stopLeScan((BluetoothAdapter.LeScanCallback)this.m21ScanCallback);
                this.isSearchBTDevice = false;
                Intent intent = new Intent();
                intent.setAction(this.STATUS_ACTION);
                intent.putExtra("android.bluetooth.adapter.extra.STATE", 12);
                pwebview.getContext().sendBroadcast(intent);
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{0, "ok"}), (int)JSUtil.OK, (boolean)true, (boolean)false);
            } else {
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10015, "stopBluetoothDevicesDiscovery fail"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            }
        } else {
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10000, "not init"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    @Override
    public void getBluetoothDevices(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        if (this.isInit) {
            StringBuilder builder = new StringBuilder();
            if (null != this.m21ScanCallback) {
                Map<String, DCBluetoothDevice> scanresult = this.m21ScanCallback.getScanList();
                for (String deviceid : scanresult.keySet()) {
                    builder.append(scanresult.get(deviceid).toString() + ",");
                }
            }
            if (builder.lastIndexOf(",") > 5) {
                builder.deleteCharAt(builder.lastIndexOf(","));
            }
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{devices:[%s]}", (Object[])new Object[]{builder.toString()}), (int)JSUtil.OK, (boolean)true, (boolean)false);
        } else {
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10000, "not init"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    @Override
    public void dispose(String pAppid) {
        super.dispose(pAppid);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.stopLeScan((BluetoothAdapter.LeScanCallback)this.m21ScanCallback);
            this.isSearchBTDevice = false;
        }
    }

    class BTScanCallback
    implements BluetoothAdapter.LeScanCallback {
        private Map<String, DCBluetoothDevice> scanList = new HashMap<String, DCBluetoothDevice>();
        private String __JS__FUNCTION = "{devices:[%s]}";

        public void onLeScan(BluetoothDevice device1, int rssi, byte[] scanRecord) {
            DCBluetoothDevice dcDevice = new DCBluetoothDevice(device1, scanRecord);
            dcDevice.setRSSI(rssi);
            if (BluetoothUnder21.this.allowDuplicatesDevice) {
                BluetoothUnder21.this.execJsCallback(BluetoothBaseAdapter.CALLBACK_DEVICE_FOUND, StringUtil.format((String)this.__JS__FUNCTION, (Object[])new Object[]{dcDevice.toString()}), true);
                this.scanList.put(device1.getAddress(), dcDevice);
            } else {
                String deviceId = device1.getAddress();
                if (!this.scanList.containsKey(deviceId)) {
                    this.scanList.put(deviceId, dcDevice);
                    BluetoothUnder21.this.execJsCallback(BluetoothBaseAdapter.CALLBACK_DEVICE_FOUND, StringUtil.format((String)this.__JS__FUNCTION, (Object[])new Object[]{dcDevice.toString()}), true);
                }
            }
        }

        public Map<String, DCBluetoothDevice> getScanList() {
            return this.scanList;
        }
    }
}

