/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Intent;
import android.os.Build;
import android.os.ParcelUuid;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.bluetooth.BluetoothBaseAdapter;
import io.dcloud.feature.bluetooth.DCBluetoothDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class BluetoothOver21
extends BluetoothBaseAdapter {
    private BTScanCallback mScanCallback;
    private BluetoothLeScanner scanner;

    @Override
    public void closeBluetoothAdapter(IWebview pwebview, JSONArray args) {
        super.closeBluetoothAdapter(pwebview, args);
        if (this.isSearchBTDevice && Build.VERSION.SDK_INT >= 21 && null != this.scanner && null != this.mScanCallback) {
            this.scanner.stopScan((ScanCallback)this.mScanCallback);
            this.isSearchBTDevice = false;
        }
    }

    @Override
    public void getBluetoothDevices(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        if (this.isInit) {
            StringBuilder builder = new StringBuilder();
            if (null != this.mScanCallback) {
                Map<String, DCBluetoothDevice> scanresult = this.mScanCallback.getScanList();
                for (String deviceid : scanresult.keySet()) {
                    builder.append(scanresult.get(deviceid).toString() + ",");
                }
            }
            if (builder.lastIndexOf(",") > 5) {
                builder.deleteCharAt(builder.lastIndexOf(","));
            }
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{devices:[%s]}", (Object[])new Object[]{builder.toString()}), (int)JSUtil.OK, (boolean)true, (boolean)false);
        } else {
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10000, "not init"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    @Override
    public void startBluetoothDevicesDiscovery(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        JSONObject param = args.optJSONObject(1);
        JSONArray serviceIds = param.optJSONArray("services");
        this.allowDuplicatesDevice = param.optBoolean("allowDuplicatesKey", false);
        String interval = param.optString("interval");
        if (this.isInit) {
            this.mScanCallback = new BTScanCallback();
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter != null && Build.VERSION.SDK_INT >= 21) {
                this.scanner = adapter.getBluetoothLeScanner();
                ArrayList<ScanFilter> scanFilters = null;
                ScanSettings.Builder settings = new ScanSettings.Builder();
                if (null != serviceIds && serviceIds.length() > 0) {
                    scanFilters = new ArrayList<ScanFilter>();
                    for (int i = 0; i < serviceIds.length(); ++i) {
                        ScanFilter.Builder filter = new ScanFilter.Builder();
                        filter.setServiceUuid(new ParcelUuid(UUID.fromString(serviceIds.optString(i))));
                        scanFilters.add(filter.build());
                    }
                }
                if (!PdrUtil.isEmpty((Object)interval)) {
                    try {
                        settings.setReportDelay(Long.parseLong(interval));
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                this.scanner.startScan(scanFilters, settings.build(), (ScanCallback)this.mScanCallback);
                Intent intent = new Intent();
                intent.setAction(this.STATUS_ACTION);
                intent.putExtra("android.bluetooth.adapter.extra.STATE", 12);
                pwebview.getContext().sendBroadcast(intent);
                this.isSearchBTDevice = true;
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{0, "ok"}), (int)JSUtil.OK, (boolean)true, (boolean)false);
            }
        } else {
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10000, "not init"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    @Override
    public void stopBluetoothDevicesDiscovery(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        if (this.isInit) {
            if (Build.VERSION.SDK_INT >= 21 && null != this.scanner && null != this.mScanCallback) {
                this.scanner.stopScan((ScanCallback)this.mScanCallback);
                this.isSearchBTDevice = false;
                Intent intent = new Intent();
                intent.setAction(this.STATUS_ACTION);
                intent.putExtra("android.bluetooth.adapter.extra.STATE", 12);
                pwebview.getContext().sendBroadcast(intent);
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{0, "ok"}), (int)JSUtil.OK, (boolean)true, (boolean)false);
            }
        } else {
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10000, "not init"}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    @Override
    public void dispose(String pAppid) {
        super.dispose(pAppid);
        if (this.isSearchBTDevice && Build.VERSION.SDK_INT >= 21) {
            this.scanner.stopScan((ScanCallback)this.mScanCallback);
            this.isSearchBTDevice = false;
        }
    }

    @TargetApi(value=21)
    private class BTScanCallback
    extends ScanCallback {
        private Map<String, DCBluetoothDevice> scanList;
        private IWebview pwebview;
        private String callbackId;
        private String __JS__FUNCTION = "{devices:[%s]}";

        public BTScanCallback() {
            this(null, null);
        }

        public BTScanCallback(IWebview pwebview, String callbackId) {
            this.pwebview = pwebview;
            this.callbackId = callbackId;
            this.scanList = new HashMap<String, DCBluetoothDevice>();
        }

        public void onScanResult(int callbackType, ScanResult result) {
            DCBluetoothDevice device = new DCBluetoothDevice(result);
            if (BluetoothOver21.this.allowDuplicatesDevice) {
                BluetoothOver21.this.execJsCallback(BluetoothBaseAdapter.CALLBACK_DEVICE_FOUND, StringUtil.format((String)this.__JS__FUNCTION, (Object[])new Object[]{device.toString()}), true);
            } else {
                String deviceId = result.getDevice().getAddress();
                if (!this.scanList.containsKey(deviceId)) {
                    this.scanList.put(deviceId, device);
                    BluetoothOver21.this.execJsCallback(BluetoothBaseAdapter.CALLBACK_DEVICE_FOUND, StringUtil.format((String)this.__JS__FUNCTION, (Object[])new Object[]{device.toString()}), true);
                }
            }
        }

        public void onScanFailed(int errorCode) {
        }

        public Map<String, DCBluetoothDevice> getScanList() {
            return this.scanList;
        }
    }
}

