/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.bluetooth;

import android.app.Activity;
import android.content.Context;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.DHInterface.StandardFeature;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.feature.bluetooth.BluetoothBaseAdapter;
import io.dcloud.feature.bluetooth.BluetoothUnder21;
import org.json.JSONArray;

public class BluetoothFeature
extends StandardFeature {
    private BluetoothBaseAdapter bluetoothF;

    public void init(AbsMgr pFeatureMgr, String pFeatureName) {
        super.init(pFeatureMgr, pFeatureName);
        this.bluetoothF = new BluetoothUnder21();
    }

    public void openBluetoothAdapter(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-openBluetoothAdapter");
        this.bluetoothF.openBluetoothAdapter(pwebview, args);
    }

    public void closeBluetoothAdapter(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-closeBluetoothAdapter");
        this.bluetoothF.closeBluetoothAdapter(pwebview, args);
    }

    public void getBluetoothAdapterState(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-getBluetoothAdapterState");
        this.bluetoothF.getBluetoothAdapterState(pwebview, args);
    }

    public void onBluetoothAdapterStateChange(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-onBluetoothAdapterStateChange");
        this.bluetoothF.onBluetoothAdapterStateChange(pwebview, args);
    }

    public void onBluetoothDeviceFound(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-onBluetoothDeviceFound");
        this.bluetoothF.onBluetoothDeviceFound(pwebview, args);
    }

    public void getBluetoothDevices(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-getBluetoothDevices");
        this.bluetoothF.getBluetoothDevices(pwebview, args);
    }

    public void getConnectedBluetoothDevices(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-getConnectedBluetoothDevices");
        this.bluetoothF.getConnectedBluetoothDevices(pwebview, args);
    }

    public void startBluetoothDevicesDiscovery(final IWebview pwebview, final JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-startBluetoothDevicesDiscovery");
        PermissionUtil.useSystemPermissions((Activity)pwebview.getActivity(), (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, (PermissionUtil.Request)new PermissionUtil.Request(){
            int times = 0;

            public void onGranted(String streamPerName) {
                ++this.times;
                if (this.times == 2) {
                    BluetoothFeature.this.bluetoothF.startBluetoothDevicesDiscovery(pwebview, args);
                }
            }

            public void onDenied(String streamPerName) {
                ++this.times;
                if (this.times == 2) {
                    BluetoothFeature.this.bluetoothF.startBluetoothDevicesDiscovery(pwebview, args);
                }
            }
        });
    }

    public void stopBluetoothDevicesDiscovery(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-stopBluetoothDevicesDiscovery");
        this.bluetoothF.stopBluetoothDevicesDiscovery(pwebview, args);
    }

    public void createBLEConnection(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-createBLEConnection");
        this.bluetoothF.createBLEConnection(pwebview, args);
    }

    public void setBLEMTU(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-setBLEMTU");
        this.bluetoothF.setBLEMTU(pwebview, args);
    }

    public void getBLEDeviceRSSI(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-getBLEDeviceRSSI");
        this.bluetoothF.getBLEDeviceRSSI(pwebview, args);
    }

    public void closeBLEConnection(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-closeBLEConnection");
        this.bluetoothF.closeBLEConnection(pwebview, args);
    }

    public void getBLEDeviceCharacteristics(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-getBLEDeviceCharacteristics");
        this.bluetoothF.getBLEDeviceCharacteristics(pwebview, args);
    }

    public void getBLEDeviceServices(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-getBLEDeviceServices");
        this.bluetoothF.getBLEDeviceServices(pwebview, args);
    }

    public void notifyBLECharacteristicValueChange(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-notifyBLECharacteristicValueChange");
        this.bluetoothF.notifyBLECharacteristicValueChange(pwebview, args);
    }

    public void onBLECharacteristicValueChange(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-onBLECharacteristicValueChange");
        this.bluetoothF.onBLECharacteristicValueChange(pwebview, args);
    }

    public void onBLEConnectionStateChange(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-onBLEConnectionStateChange");
        this.bluetoothF.onBLEConnectionStateChange(pwebview, args);
    }

    public void readBLECharacteristicValue(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-readBLECharacteristicValue");
        this.bluetoothF.readBLECharacteristicValue(pwebview, args);
    }

    public void writeBLECharacteristicValue(IWebview pwebview, JSONArray args) {
        AppRuntime.checkPrivacyComplianceAndPrompt((Context)pwebview.getContext(), (String)"Bluetooth-writeBLECharacteristicValue");
        this.bluetoothF.writeBLECharacteristicValue(pwebview, args);
    }

    public void dispose(String pAppid) {
        this.bluetoothF.dispose(pAppid);
    }
}

