/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BluetoothBaseAdapter
implements MessageHandler.IMessages {
    boolean allowDuplicatesDevice = false;
    private Map<String, BluetoothGatt> bleConnected;
    boolean isInit = false;
    boolean isSearchBTDevice = false;
    final String _JS_FUNCTION = "{code:%d,message:'%s'}";
    String STATUS_ACTION = "io.dcloud.bluetooth.sendsearch";
    private Map<String, HashMap<String, IWebview>> callbacks;
    private static String CALLBACK_ADAPTER_STATUS_CHANGED = "callback_adapter_status_changed";
    static String CALLBACK_DEVICE_FOUND = "callback_device_found";
    private static String CALLBACK_BLECHARACTERISTIC_VALUE_CHANGE = "callback_blecharacteristicvaluechange";
    private static String CALLBACK_CONNECTION_STATUS_CHANGED = "callback_connection_status_change";
    private BTBluetoothGattCallback gattCallback;
    private HashMap<String, BluetoothGatt> createGatt;
    private IWebview getDeviceRSSIWebview;
    private String getDeviceRSSICallback;
    public static String CLIENT_CHARACTERISTIC_CONFIG = "00002902-0000-1000-8000-00805f9b34fb";
    private BroadcastReceiver bluetoothStatuReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                BluetoothBaseAdapter.this.execJsCallback(CALLBACK_ADAPTER_STATUS_CHANGED, StringUtil.format((String)"{discovering:%b,available:%b}", (Object[])new Object[]{BluetoothBaseAdapter.this.isSearchBTDevice, blueState == 12}), true);
            } else if (action.equalsIgnoreCase(BluetoothBaseAdapter.this.STATUS_ACTION)) {
                BluetoothBaseAdapter.this.execJsCallback(CALLBACK_ADAPTER_STATUS_CHANGED, StringUtil.format((String)"{discovering:%b,available:%b}", (Object[])new Object[]{BluetoothBaseAdapter.this.isSearchBTDevice, true}), true);
            }
        }
    };

    public void openBluetoothAdapter(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (!pwebview.getContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            this.execCallback(pwebview, callbackid, 10009, "system not support", JSUtil.ERROR);
            return;
        }
        if (adapter == null) {
            this.execCallback(pwebview, callbackid, 10010, "unsupport", JSUtil.ERROR);
            return;
        }
        if (!adapter.isEnabled()) {
            this.execCallback(pwebview, callbackid, 10001, "not available", JSUtil.ERROR);
            return;
        }
        adapter.enable();
        this.isInit = true;
        this.gattCallback = new BTBluetoothGattCallback();
        this.execCallback(pwebview, callbackid, 0, "ok", JSUtil.OK);
    }

    public void dispose(String pAppid) {
        if (null != this.callbacks) {
            HashMap<String, IWebview> adapters = this.callbacks.get(CALLBACK_ADAPTER_STATUS_CHANGED);
            if (adapters != null) {
                for (String key : adapters.keySet()) {
                    if (null == adapters.get(key)) continue;
                    adapters.get(key).getContext().unregisterReceiver(this.bluetoothStatuReceiver);
                }
            }
            this.callbacks.clear();
        }
        this.isInit = false;
        if (this.bleConnected != null && this.bleConnected.size() > 0) {
            for (String key : this.bleConnected.keySet()) {
                BluetoothGatt gatt = this.bleConnected.get(key);
                gatt.disconnect();
                gatt.close();
            }
            this.bleConnected.clear();
        }
    }

    public void closeBluetoothAdapter(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (!pwebview.getContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            this.execCallback(pwebview, callbackid, 10009, "system not support", JSUtil.ERROR);
            return;
        }
        if (adapter == null) {
            this.execCallback(pwebview, callbackid, 10010, "unsupport", JSUtil.ERROR);
            return;
        }
        if (!adapter.isEnabled()) {
            this.execCallback(pwebview, callbackid, 10001, "not available", JSUtil.ERROR);
            return;
        }
        this.isInit = false;
        if (this.bleConnected != null && this.bleConnected.size() > 0) {
            for (String key : this.bleConnected.keySet()) {
                BluetoothGatt gatt = this.bleConnected.get(key);
                gatt.disconnect();
                gatt.close();
            }
            this.bleConnected.clear();
        }
        if (this.createGatt != null) {
            this.createGatt.clear();
        }
        this.execCallback(pwebview, callbackid, 0, "ok", JSUtil.OK);
    }

    public void getBluetoothAdapterState(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        if (this.isInit) {
            JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{discovering:%b,available:true}", (Object[])new Object[]{this.isSearchBTDevice}), (int)JSUtil.OK, (boolean)true, (boolean)false);
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    public void onBluetoothDeviceFound(IWebview pwebview, JSONArray args) {
        HashMap<String, IWebview> adapter = this.getStringIWebviewHashMap(CALLBACK_DEVICE_FOUND);
        adapter.put(args.optString(0), pwebview);
        this.callbacks.put(CALLBACK_DEVICE_FOUND, adapter);
    }

    public void getBluetoothDevices(IWebview pwebview, JSONArray args) {
    }

    public void startBluetoothDevicesDiscovery(IWebview pwebview, JSONArray args) {
    }

    public void stopBluetoothDevicesDiscovery(IWebview pwebview, JSONArray args) {
    }

    public void onBluetoothAdapterStateChange(IWebview pwebview, JSONArray args) {
        HashMap<String, IWebview> adapter = this.getStringIWebviewHashMap(CALLBACK_ADAPTER_STATUS_CHANGED);
        adapter.put(args.optString(0), pwebview);
        this.callbacks.put(CALLBACK_ADAPTER_STATUS_CHANGED, adapter);
        IntentFilter stateChangeFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        IntentFilter connectedFilter = new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED");
        IntentFilter disConnectedFilter = new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED");
        IntentFilter statusFilter = new IntentFilter(this.STATUS_ACTION);
        pwebview.getContext().registerReceiver(this.bluetoothStatuReceiver, statusFilter);
        pwebview.getContext().registerReceiver(this.bluetoothStatuReceiver, stateChangeFilter);
        pwebview.getContext().registerReceiver(this.bluetoothStatuReceiver, connectedFilter);
        pwebview.getContext().registerReceiver(this.bluetoothStatuReceiver, disConnectedFilter);
    }

    private HashMap<String, IWebview> getStringIWebviewHashMap(String key) {
        if (null == this.callbacks) {
            this.callbacks = new HashMap<String, HashMap<String, IWebview>>();
        }
        return new HashMap<String, IWebview>();
    }

    public void getConnectedBluetoothDevices(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        JSONArray services = args.optJSONObject(1).optJSONArray("services");
        if (this.isInit) {
            BluetoothManager bluetoothManager = (BluetoothManager)pwebview.getContext().getSystemService("bluetooth");
            if (bluetoothManager != null) {
                List devices = bluetoothManager.getConnectedDevices(7);
                JSONArray array = new JSONArray();
                if (null != this.bleConnected && this.bleConnected.size() > 0) {
                    try {
                        for (BluetoothDevice device : devices) {
                            JSONObject object = new JSONObject();
                            if (!this.bleConnected.containsKey(device.getAddress())) continue;
                            object.put("name", (Object)device.getName());
                            object.put("deviceId", (Object)device.getAddress());
                            array.put((Object)object);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{devices:%s}", (Object[])new Object[]{array.toString()}), (int)JSUtil.OK, (boolean)true, (boolean)false);
            }
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    public void createBLEConnection(IWebview pwebview, JSONArray args) {
        block10: {
            String callbackid = args.optString(0);
            JSONObject param = args.optJSONObject(1);
            String deviceid = param.optString("deviceId");
            String timeout = param.optString("timeout");
            if (this.checkNull(pwebview, callbackid, deviceid)) {
                return;
            }
            if (this.isInit) {
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                if (this.bleConnected == null) {
                    this.bleConnected = new HashMap<String, BluetoothGatt>();
                }
                if (this.createGatt == null) {
                    this.createGatt = new HashMap();
                }
                try {
                    BluetoothDevice device = adapter.getRemoteDevice(deviceid);
                    if (this.bleConnected.containsKey(deviceid) && this.bleConnected.get(deviceid) != null) {
                        this.execCallback(pwebview, callbackid, -1, "already connect", JSUtil.ERROR);
                        return;
                    }
                    HashMap<String, IWebview> create = this.getStringIWebviewHashMap("");
                    create.put(callbackid, pwebview);
                    this.callbacks.put(deviceid, create);
                    BluetoothGatt gatt = Build.VERSION.SDK_INT >= 23 ? device.connectGatt(pwebview.getContext(), false, (BluetoothGattCallback)this.gattCallback, 2) : device.connectGatt(pwebview.getContext(), false, (BluetoothGattCallback)this.gattCallback);
                    this.createGatt.put(deviceid, gatt);
                    if (!param.has("timeout") || PdrUtil.isEmpty((Object)timeout)) break block10;
                    try {
                        long delay = Long.parseLong(timeout);
                        MessageHandler.sendMessage((MessageHandler.IMessages)this, (long)delay, (Object)gatt);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    this.execCallback(pwebview, callbackid, 10002, "no device", JSUtil.ERROR);
                }
            } else {
                this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
            }
        }
    }

    public void setBLEMTU(IWebview pwebview, JSONArray args) {
        String deviceid = args.optJSONObject(1).optString("deviceId");
        String callbackid = args.optString(0);
        String mtuStr = args.optJSONObject(1).optString("mtu");
        if (Build.VERSION.SDK_INT < 21) {
            this.execCallback(pwebview, callbackid, 10004, "not support", JSUtil.ERROR);
            return;
        }
        if (!this.isInit) {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
            return;
        }
        if (this.checkNull(pwebview, callbackid, deviceid, mtuStr)) {
            return;
        }
        try {
            int mtu = Integer.parseInt(mtuStr);
            if (mtu > 22 && mtu <= 512) {
                if (null != this.bleConnected && this.bleConnected.containsKey(deviceid)) {
                    BluetoothGatt gatt = this.bleConnected.get(deviceid);
                    if (gatt != null) {
                        gatt.requestMtu(mtu);
                        this.execCallback(pwebview, callbackid, 0, "ok", JSUtil.OK);
                    } else {
                        this.execCallback(pwebview, callbackid, 10004, "no service", JSUtil.ERROR);
                    }
                } else {
                    this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
                }
            } else {
                this.execCallback(pwebview, callbackid, 10013, "invalid data", JSUtil.ERROR);
            }
        }
        catch (Exception e) {
            this.execCallback(pwebview, callbackid, 10013, "parameter.mtu should be Number", JSUtil.ERROR);
        }
    }

    public void getBLEDeviceRSSI(IWebview pwebview, JSONArray args) {
        String deviceid = args.optJSONObject(1).optString("deviceId");
        String callbackid = args.optString(0);
        if (!this.isInit) {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
            return;
        }
        if (this.checkNull(pwebview, callbackid, deviceid)) {
            return;
        }
        if (this.bleConnected != null && this.bleConnected.containsKey(deviceid) && this.bleConnected.get(deviceid) != null) {
            BluetoothGatt currentService = this.bleConnected.get(deviceid);
            if (currentService == null) {
                this.execCallback(pwebview, callbackid, 10004, "no service", JSUtil.ERROR);
            } else {
                this.getDeviceRSSIWebview = pwebview;
                this.getDeviceRSSICallback = callbackid;
                currentService.readRemoteRssi();
            }
        } else {
            this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
        }
    }

    public void closeBLEConnection(IWebview pwebview, JSONArray args) {
        String deviceid = args.optJSONObject(1).optString("deviceId");
        String callbackid = args.optString(0);
        if (this.checkNull(pwebview, callbackid, deviceid)) {
            return;
        }
        if (this.isInit) {
            if (this.bleConnected == null) {
                this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
                return;
            }
            if (this.bleConnected.containsKey(deviceid) && this.bleConnected.get(deviceid) != null) {
                this.bleConnected.get(deviceid).disconnect();
            } else if (this.createGatt != null && this.createGatt.containsKey(deviceid) && this.createGatt.get(deviceid) != null) {
                this.createGatt.get(deviceid).disconnect();
            }
            this.execCallback(pwebview, callbackid, 0, "ok", JSUtil.OK);
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    public void getBLEDeviceCharacteristics(IWebview pwebview, JSONArray args) {
        String serviceId;
        JSONObject param;
        String deviceid;
        String callbackid = args.optString(0);
        if (this.checkNull(pwebview, callbackid, deviceid = (param = args.optJSONObject(1)).optString("deviceId"), serviceId = param.optString("serviceId"))) {
            return;
        }
        if (this.isInit) {
            if (this.bleConnected != null && this.bleConnected.containsKey(deviceid) && this.bleConnected.get(deviceid) != null) {
                BluetoothGattService currentService = this.bleConnected.get(deviceid).getService(UUID.fromString(serviceId));
                if (currentService == null) {
                    this.execCallback(pwebview, callbackid, 10004, "no service", JSUtil.ERROR);
                    return;
                }
                List characteristics = currentService.getCharacteristics();
                JSONArray characteristicArray = new JSONArray();
                for (int i = 0; i < characteristics.size(); ++i) {
                    BluetoothGattCharacteristic characteristic = (BluetoothGattCharacteristic)characteristics.get(i);
                    JSONObject characteristicItem = null;
                    try {
                        characteristicItem = new JSONObject();
                        characteristicItem.put("uuid", (Object)characteristic.getUuid().toString().toUpperCase());
                        JSONObject properties = new JSONObject();
                        int property = characteristic.getProperties();
                        properties.put("read", (property & 2) > 0);
                        boolean isWrite = (property & 8) > 0 || (property & 4) > 0;
                        properties.put("write", isWrite);
                        properties.put("notify", (property & 0x10) > 0);
                        properties.put("indicate", (property & 0x20) > 0);
                        characteristicItem.put("properties", (Object)properties);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    characteristicArray.put((Object)characteristicItem);
                }
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{'characteristics':%s}", (Object[])new Object[]{characteristicArray.toString()}), (int)JSUtil.OK, (boolean)true, (boolean)false);
            } else {
                this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
            }
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    public void getBLEDeviceServices(IWebview pwebview, JSONArray args) {
        String deviceid = args.optJSONObject(1).optString("deviceId");
        String callbackid = args.optString(0);
        if (this.checkNull(pwebview, callbackid, deviceid)) {
            return;
        }
        if (this.isInit) {
            BluetoothGatt gatt = this.getBluetoothGatt(deviceid);
            if (null != gatt) {
                List services = gatt.getServices();
                JSONArray serviceArray = new JSONArray();
                for (BluetoothGattService service : services) {
                    JSONObject serviceObject = new JSONObject();
                    try {
                        serviceObject.put("uuid", (Object)service.getUuid().toString().toUpperCase());
                        serviceObject.put("isPrimary", service.getType() == 0);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    serviceArray.put((Object)serviceObject);
                }
                JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{'services':%s}", (Object[])new Object[]{serviceArray.toString()}), (int)JSUtil.OK, (boolean)true, (boolean)false);
            } else {
                this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
            }
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    public void notifyBLECharacteristicValueChange(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        JSONObject param = args.optJSONObject(1);
        String serviceId = param.optString("serviceId");
        String deviceid = param.optString("deviceId");
        String characteristicId = param.optString("characteristicId");
        boolean state = param.optBoolean("state", true);
        if (this.checkNull(pwebview, callbackid, serviceId, deviceid, characteristicId)) {
            return;
        }
        if (this.isInit) {
            BluetoothGatt gatt = this.getBluetoothGatt(deviceid);
            if (gatt != null) {
                BluetoothGattService service = gatt.getService(UUID.fromString(serviceId));
                if (service != null) {
                    BluetoothGattCharacteristic characteristic = service.getCharacteristic(UUID.fromString(characteristicId));
                    if (characteristic == null) {
                        this.execCallback(pwebview, callbackid, 10005, "no characteristic", JSUtil.ERROR);
                        return;
                    }
                    boolean notification = gatt.setCharacteristicNotification(characteristic, true);
                    BluetoothGattDescriptor descriptor = characteristic.getDescriptor(UUID.fromString(CLIENT_CHARACTERISTIC_CONFIG));
                    if (descriptor != null) {
                        if (!state) {
                            descriptor.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                            gatt.writeDescriptor(descriptor);
                        } else if ((characteristic.getProperties() & 0x20) == 32) {
                            descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                            gatt.writeDescriptor(descriptor);
                        } else {
                            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                            gatt.writeDescriptor(descriptor);
                        }
                    } else {
                        this.execCallback(pwebview, callbackid, 10008, "no descriptor", JSUtil.ERROR);
                        return;
                    }
                    if (notification) {
                        this.execCallback(pwebview, callbackid, 0, "ok", JSUtil.OK);
                    } else {
                        this.execCallback(pwebview, callbackid, 10011, "notify fail", JSUtil.ERROR);
                    }
                } else {
                    this.execCallback(pwebview, callbackid, 10004, "no service", JSUtil.ERROR);
                }
            } else {
                this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
            }
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    private void execCallback(IWebview pwebview, String callbackid, int i, String s, int error) {
        JSUtil.execCallback((IWebview)pwebview, (String)callbackid, (String)StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{i, s}), (int)error, (boolean)true, (boolean)false);
    }

    private BluetoothGatt getBluetoothGatt(String deviceid) {
        if (this.bleConnected != null && this.bleConnected.containsKey(deviceid) && this.bleConnected.get(deviceid) != null) {
            return this.bleConnected.get(deviceid);
        }
        return null;
    }

    public void onBLECharacteristicValueChange(IWebview pwebview, JSONArray args) {
        HashMap<String, IWebview> adapter = this.getStringIWebviewHashMap(CALLBACK_BLECHARACTERISTIC_VALUE_CHANGE);
        adapter.put(args.optString(0), pwebview);
        this.callbacks.put(CALLBACK_BLECHARACTERISTIC_VALUE_CHANGE, adapter);
    }

    public void onBLEConnectionStateChange(IWebview pwebview, JSONArray args) {
        HashMap<String, IWebview> adapter = this.getStringIWebviewHashMap(CALLBACK_CONNECTION_STATUS_CHANGED);
        adapter.put(args.optString(0), pwebview);
        this.callbacks.put(CALLBACK_CONNECTION_STATUS_CHANGED, adapter);
    }

    public void readBLECharacteristicValue(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        JSONObject param = args.optJSONObject(1);
        String serviceId = param.optString("serviceId");
        String deviceid = param.optString("deviceId");
        String characteristicId = param.optString("characteristicId");
        if (this.checkNull(pwebview, callbackid, serviceId, deviceid, characteristicId)) {
            return;
        }
        if (this.isInit) {
            BluetoothGatt gatt = this.getBluetoothGatt(deviceid);
            if (gatt != null) {
                BluetoothGattService service = gatt.getService(UUID.fromString(serviceId));
                if (service != null) {
                    BluetoothGattCharacteristic characteristic = service.getCharacteristic(UUID.fromString(characteristicId));
                    if (characteristic == null) {
                        this.execCallback(pwebview, callbackid, 10005, "no characteristic", JSUtil.ERROR);
                        return;
                    }
                    if (gatt.readCharacteristic(characteristic)) {
                        this.execCallback(pwebview, callbackid, 0, "ok", JSUtil.OK);
                    } else {
                        this.execCallback(pwebview, callbackid, 10007, "property not support", JSUtil.ERROR);
                    }
                }
            } else {
                this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
            }
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    public static byte[] hexToByte(String str) {
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < str.length() / 2; ++i) {
            String subStr = str.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return bytes;
    }

    public static String bytesToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte b : bArray) {
            String sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public void writeBLECharacteristicValue(IWebview pwebview, JSONArray args) {
        String callbackid = args.optString(0);
        JSONObject param = args.optJSONObject(1);
        String serviceId = param.optString("serviceId");
        String deviceid = param.optString("deviceId");
        String characteristicId = param.optString("characteristicId");
        String valueOpt = param.optString("value");
        if (this.checkNull(pwebview, callbackid, serviceId, deviceid, characteristicId, valueOpt)) {
            return;
        }
        byte[] value = BluetoothBaseAdapter.hexToByte(valueOpt);
        if (this.isInit) {
            BluetoothGatt gatt = this.getBluetoothGatt(deviceid);
            if (gatt != null) {
                BluetoothGattService service = gatt.getService(UUID.fromString(serviceId));
                if (service != null) {
                    BluetoothGattCharacteristic characteristic = service.getCharacteristic(UUID.fromString(characteristicId));
                    if (characteristic == null) {
                        this.execCallback(pwebview, callbackid, 10005, "no characteristic", JSUtil.ERROR);
                        return;
                    }
                    characteristic.setValue(value);
                    if (gatt.writeCharacteristic(characteristic)) {
                        this.execCallback(pwebview, callbackid, 0, "ok", JSUtil.OK);
                    } else {
                        this.execCallback(pwebview, callbackid, 10007, "property not support", JSUtil.ERROR);
                    }
                }
            } else {
                this.execCallback(pwebview, callbackid, 10004, "no connection", JSUtil.ERROR);
            }
        } else {
            this.execCallback(pwebview, callbackid, 10000, "not init", JSUtil.ERROR);
        }
    }

    boolean checkNull(IWebview pwebview, String callbackid, String ... param) {
        for (String p : param) {
            if (!PdrUtil.isEmpty((Object)p)) continue;
            this.execCallback(pwebview, callbackid, 10013, "invalid data,please check parameters", JSUtil.ERROR);
            return true;
        }
        return false;
    }

    protected void execJsCallback(String type, String msg, boolean keepCallback) {
        if (this.callbacks == null) {
            return;
        }
        HashMap<String, IWebview> jscallback = this.callbacks.get(type);
        if (jscallback != null) {
            for (String key : jscallback.keySet()) {
                JSUtil.execCallback((IWebview)jscallback.get(key), (String)key, (String)msg, (int)JSUtil.OK, (boolean)true, (boolean)keepCallback);
            }
        }
    }

    public void execute(Object pArgs) {
        try {
            Iterator<Map.Entry<String, IWebview>> iterator;
            HashMap<String, IWebview> cb;
            BluetoothGatt gatt = (BluetoothGatt)pArgs;
            String deviceId = gatt.getDevice().getAddress();
            if ((!this.bleConnected.containsKey(deviceId) || this.bleConnected.get(deviceId) == null) && (cb = this.callbacks.get(deviceId)) != null && cb.size() > 0 && (iterator = cb.entrySet().iterator()).hasNext()) {
                Map.Entry<String, IWebview> entry = iterator.next();
                IWebview webView = entry.getValue();
                String callbackId = entry.getKey();
                BluetoothManager bluetoothManager = (BluetoothManager)webView.getContext().getSystemService("bluetooth");
                List devices = bluetoothManager.getConnectedDevices(7);
                for (BluetoothDevice device : devices) {
                    if (!device.getAddress().equals(deviceId)) continue;
                    return;
                }
                gatt.disconnect();
                this.execCallback(webView, callbackId, 10012, "operate time out", JSUtil.ERROR);
                this.callbacks.remove(deviceId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class BTBluetoothGattCallback
    extends BluetoothGattCallback {
        private BTBluetoothGattCallback() {
        }

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            String deviceid = gatt.getDevice().getAddress();
            if (status == 0 && newState == 2) {
                gatt.discoverServices();
                BluetoothBaseAdapter.this.bleConnected.put(deviceid, gatt);
                BluetoothBaseAdapter.this.execJsCallback(deviceid, StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{0, "ok"}), false);
                BluetoothBaseAdapter.this.callbacks.remove(deviceid);
                BluetoothBaseAdapter.this.execJsCallback(CALLBACK_CONNECTION_STATUS_CHANGED, StringUtil.format((String)"{deviceId:'%s',connected:%b}", (Object[])new Object[]{deviceid, true}), true);
            } else {
                if (null != BluetoothBaseAdapter.this.bleConnected && BluetoothBaseAdapter.this.bleConnected.containsKey(deviceid)) {
                    ((BluetoothGatt)BluetoothBaseAdapter.this.bleConnected.get(deviceid)).disconnect();
                    ((BluetoothGatt)BluetoothBaseAdapter.this.bleConnected.get(deviceid)).close();
                    BluetoothBaseAdapter.this.bleConnected.remove(deviceid);
                }
                if (newState == 0) {
                    BluetoothBaseAdapter.this.execJsCallback(deviceid, StringUtil.format((String)"{code:%d,message:'%s'}", (Object[])new Object[]{10012, "operate time out"}), false);
                    BluetoothBaseAdapter.this.callbacks.remove(deviceid);
                }
                BluetoothBaseAdapter.this.execJsCallback(CALLBACK_CONNECTION_STATUS_CHANGED, StringUtil.format((String)"{deviceId:'%s',connected:%b}", (Object[])new Object[]{deviceid, false}), true);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            BluetoothBaseAdapter.this.execJsCallback(CALLBACK_BLECHARACTERISTIC_VALUE_CHANGE, StringUtil.format((String)"{deviceId:'%s',serviceId:'%s',characteristicId:'%s',value:'%s'}", (Object[])new Object[]{gatt.getDevice().getAddress().toUpperCase(), characteristic.getService().getUuid().toString().toUpperCase(), characteristic.getUuid().toString().toUpperCase(), BluetoothBaseAdapter.bytesToHexString(characteristic.getValue())}), true);
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            BluetoothBaseAdapter.this.execJsCallback(CALLBACK_BLECHARACTERISTIC_VALUE_CHANGE, StringUtil.format((String)"{deviceId:'%s',serviceId:'%s',characteristicId:'%s',value:'%s'}", (Object[])new Object[]{gatt.getDevice().getAddress().toUpperCase(), characteristic.getService().getUuid().toString().toUpperCase(), characteristic.getUuid().toString().toUpperCase(), BluetoothBaseAdapter.bytesToHexString(characteristic.getValue())}), true);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            if (BluetoothBaseAdapter.this.getDeviceRSSIWebview != null && BluetoothBaseAdapter.this.getDeviceRSSICallback != null) {
                JSUtil.execCallback((IWebview)BluetoothBaseAdapter.this.getDeviceRSSIWebview, (String)BluetoothBaseAdapter.this.getDeviceRSSICallback, (String)StringUtil.format((String)"{RSSI:%d,code:%d}", (Object[])new Object[]{rssi, 0}), (int)JSUtil.OK, (boolean)true, (boolean)false);
                BluetoothBaseAdapter.this.getDeviceRSSIWebview = null;
                BluetoothBaseAdapter.this.getDeviceRSSICallback = null;
            }
        }
    }
}

