/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.glutil;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.google.mediapipe.glutil.CommonShaders;
import com.google.mediapipe.glutil.ShaderUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class TextureRenderer {
    private static final FloatBuffer TEXTURE_VERTICES = ShaderUtil.floatBuffer(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    private static final FloatBuffer FLIPPED_TEXTURE_VERTICES = ShaderUtil.floatBuffer(0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    private static final String TAG = "TextureRenderer";
    private static final int ATTRIB_POSITION = 1;
    private static final int ATTRIB_TEXTURE_COORDINATE = 2;
    private int program = 0;
    private int frameUniform;
    private int textureTransformUniform;
    private float[] textureTransformMatrix = new float[16];
    private boolean flipY;

    public void setup() {
        HashMap<String, Integer> attributeLocations = new HashMap<String, Integer>();
        attributeLocations.put("position", 1);
        attributeLocations.put("texture_coordinate", 2);
        this.program = ShaderUtil.createProgram("uniform mat4 texture_transform;\nattribute vec4 position;\nattribute mediump vec4 texture_coordinate;\nvarying mediump vec2 sample_coordinate;\n\nvoid main() {\n  gl_Position = position;\n  sample_coordinate = (texture_transform * texture_coordinate).xy;\n}", "varying mediump vec2 sample_coordinate;\nuniform sampler2D video_frame;\n\nvoid main() {\n  gl_FragColor = texture2D(video_frame, sample_coordinate);\n}", attributeLocations);
        this.frameUniform = GLES20.glGetUniformLocation((int)this.program, (String)"video_frame");
        this.textureTransformUniform = GLES20.glGetUniformLocation((int)this.program, (String)"texture_transform");
        ShaderUtil.checkGlError("glGetUniformLocation");
        Matrix.setIdentityM((float[])this.textureTransformMatrix, (int)0);
    }

    public void setFlipY(boolean flip) {
        this.flipY = flip;
    }

    public void render(int textureName) {
        GLES20.glClear((int)16384);
        GLES20.glActiveTexture((int)33984);
        ShaderUtil.checkGlError("glActiveTexture");
        GLES20.glBindTexture((int)3553, (int)textureName);
        ShaderUtil.checkGlError("glBindTexture");
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        ShaderUtil.checkGlError("glTexParameteri");
        GLES20.glUseProgram((int)this.program);
        ShaderUtil.checkGlError("glUseProgram");
        GLES20.glUniform1i((int)this.frameUniform, (int)0);
        ShaderUtil.checkGlError("glUniform1i");
        GLES20.glUniformMatrix4fv((int)this.textureTransformUniform, (int)1, (boolean)false, (float[])this.textureTransformMatrix, (int)0);
        ShaderUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)1);
        GLES20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)CommonShaders.SQUARE_VERTICES);
        GLES20.glEnableVertexAttribArray((int)2);
        GLES20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)(this.flipY ? FLIPPED_TEXTURE_VERTICES : TEXTURE_VERTICES));
        ShaderUtil.checkGlError("program setup");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        ShaderUtil.checkGlError("glDrawArrays");
        GLES20.glBindTexture((int)3553, (int)0);
        ShaderUtil.checkGlError("glBindTexture");
        GLES20.glFlush();
    }

    public void release() {
        GLES20.glDeleteProgram((int)this.program);
    }
}

