/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.mediapipe.framework.GlSyncToken;
import com.google.mediapipe.framework.TextureFrame;

public class GraphTextureFrame
implements TextureFrame {
    private long nativeBufferHandle;
    private int textureName;
    private int width;
    private int height;
    private long timestamp = Long.MIN_VALUE;

    GraphTextureFrame(long nativeHandle, long timestamp) {
        this.nativeBufferHandle = nativeHandle;
        this.textureName = this.nativeGetTextureName(this.nativeBufferHandle);
        this.width = this.nativeGetWidth(this.nativeBufferHandle);
        this.height = this.nativeGetHeight(this.nativeBufferHandle);
        this.timestamp = timestamp;
    }

    @Override
    public int getTextureName() {
        return this.textureName;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void release() {
        if (this.nativeBufferHandle != 0L) {
            this.nativeReleaseBuffer(this.nativeBufferHandle);
            this.nativeBufferHandle = 0L;
        }
    }

    @Override
    public void release(GlSyncToken syncToken) {
        syncToken.release();
        this.release();
    }

    private native void nativeReleaseBuffer(long var1);

    private native int nativeGetTextureName(long var1);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);
}

