/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.mediapipe.framework.GraphProfiler;
import com.google.mediapipe.framework.GraphService;
import com.google.mediapipe.framework.MediaPipeException;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.PacketCallback;
import com.google.mediapipe.framework.PacketListCallback;
import com.google.mediapipe.framework.SurfaceOutput;
import com.google.mediapipe.proto.CalculatorProto;
import com.google.mediapipe.proto.GraphTemplateProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Graph {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final int MAX_BUFFER_SIZE = 20;
    private long nativeGraphHandle;
    private final List<Object> callbacks = new ArrayList<Object>();
    private Map<String, Packet> sidePackets = new HashMap<String, Packet>();
    private Map<String, Packet> streamHeaders = new HashMap<String, Packet>();
    private boolean stepMode = false;
    private boolean startRunningGraphCalled = false;
    private boolean graphRunning = false;
    private Map<String, ArrayList<PacketBufferItem>> packetBuffers = new HashMap<String, ArrayList<PacketBufferItem>>();
    private final Object terminationLock = new Object();

    public Graph() {
        this.nativeGraphHandle = this.nativeCreateGraph();
    }

    public synchronized long getNativeHandle() {
        return this.nativeGraphHandle;
    }

    public synchronized void setStepMode(boolean stepMode) {
        this.stepMode = stepMode;
    }

    public synchronized boolean getStepMode() {
        return this.stepMode;
    }

    public synchronized void loadBinaryGraph(String path) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        this.nativeLoadBinaryGraph(this.nativeGraphHandle, path);
    }

    public synchronized void loadBinaryGraph(byte[] data) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        this.nativeLoadBinaryGraphBytes(this.nativeGraphHandle, data);
    }

    public synchronized void loadBinaryGraph(CalculatorProto.CalculatorGraphConfig config) {
        this.loadBinaryGraph(config.toByteArray());
    }

    public synchronized void loadBinaryGraphTemplate(GraphTemplateProto.CalculatorGraphTemplate template) {
        this.nativeLoadBinaryGraphTemplate(this.nativeGraphHandle, template.toByteArray());
    }

    public synchronized void setGraphType(String graphType) {
        this.nativeSetGraphType(this.nativeGraphHandle, graphType);
    }

    public synchronized void setGraphOptions(CalculatorProto.CalculatorGraphConfig.Node options) {
        this.nativeSetGraphOptions(this.nativeGraphHandle, options.toByteArray());
    }

    public synchronized CalculatorProto.CalculatorGraphConfig getCalculatorGraphConfig() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        byte[] data = this.nativeGetCalculatorGraphConfig(this.nativeGraphHandle);
        if (data != null) {
            try {
                return CalculatorProto.CalculatorGraphConfig.parseFrom(data);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public synchronized void addPacketCallback(String streamName, PacketCallback callback) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        Preconditions.checkNotNull((Object)streamName);
        Preconditions.checkNotNull((Object)callback);
        Preconditions.checkState((!this.graphRunning && !this.startRunningGraphCalled ? 1 : 0) != 0);
        this.callbacks.add(callback);
        this.nativeAddPacketCallback(this.nativeGraphHandle, streamName, callback);
    }

    public synchronized void addMultiStreamCallback(List<String> streamNames, PacketListCallback callback) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        Preconditions.checkNotNull(streamNames);
        Preconditions.checkNotNull((Object)callback);
        Preconditions.checkState((!this.graphRunning && !this.startRunningGraphCalled ? 1 : 0) != 0);
        this.callbacks.add(callback);
        this.nativeAddMultiStreamCallback(this.nativeGraphHandle, streamNames, callback);
    }

    public synchronized SurfaceOutput addSurfaceOutput(String streamName) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        Preconditions.checkNotNull((Object)streamName);
        Preconditions.checkState((!this.graphRunning && !this.startRunningGraphCalled ? 1 : 0) != 0);
        return new SurfaceOutput(this, Packet.create(this.nativeAddSurfaceOutput(this.nativeGraphHandle, streamName)));
    }

    public synchronized void setInputSidePackets(Map<String, Packet> sidePackets) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        Preconditions.checkState((!this.graphRunning && !this.startRunningGraphCalled ? 1 : 0) != 0);
        for (Map.Entry<String, Packet> entry : sidePackets.entrySet()) {
            this.sidePackets.put(entry.getKey(), entry.getValue().copy());
        }
    }

    public synchronized <T> void setServiceObject(GraphService<T> service, T object) {
        service.installServiceObject(this.nativeGraphHandle, object);
    }

    public synchronized void addStreamNameExpectingHeader(String streamName) {
        Preconditions.checkState((!this.graphRunning && !this.startRunningGraphCalled ? 1 : 0) != 0);
        this.streamHeaders.put(streamName, null);
    }

    public synchronized void setStreamHeader(String streamName, Packet streamHeader) {
        this.setStreamHeader(streamName, streamHeader, false);
    }

    public synchronized void setStreamHeader(String streamName, Packet streamHeader, boolean override) {
        Packet header = this.streamHeaders.get(streamName);
        if (header != null) {
            if (override) {
                if (this.graphRunning) {
                    throw new IllegalArgumentException("Can't override an existing stream header, after graph started running.");
                }
                header.release();
            } else {
                return;
            }
        }
        this.streamHeaders.put(streamName, streamHeader.copy());
        if (!this.graphRunning && this.startRunningGraphCalled && this.hasAllStreamHeaders()) {
            this.startRunningGraph();
        }
    }

    public synchronized void runGraphUntilClose() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        Preconditions.checkNotNull(this.sidePackets);
        String[] streamNames = new String[this.sidePackets.size()];
        long[] packets = new long[this.sidePackets.size()];
        Graph.splitStreamNamePacketMap(this.sidePackets, streamNames, packets);
        this.nativeRunGraphUntilClose(this.nativeGraphHandle, streamNames, packets);
    }

    public synchronized void startRunningGraph() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        this.startRunningGraphCalled = true;
        if (!this.hasAllStreamHeaders()) {
            ((FluentLogger.Api)logger.atInfo()).log("MediaPipe graph won't start until all stream headers are available.");
            return;
        }
        String[] sidePacketNames = new String[this.sidePackets.size()];
        long[] sidePacketHandles = new long[this.sidePackets.size()];
        Graph.splitStreamNamePacketMap(this.sidePackets, sidePacketNames, sidePacketHandles);
        String[] streamNamesWithHeader = new String[this.streamHeaders.size()];
        long[] streamHeaderHandles = new long[this.streamHeaders.size()];
        Graph.splitStreamNamePacketMap(this.streamHeaders, streamNamesWithHeader, streamHeaderHandles);
        this.nativeStartRunningGraph(this.nativeGraphHandle, sidePacketNames, sidePacketHandles, streamNamesWithHeader, streamHeaderHandles);
        this.graphRunning = true;
        this.moveBufferedPacketsToInputStream();
    }

    public synchronized void setGraphInputStreamBlockingMode(boolean mode) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        Preconditions.checkState((!this.graphRunning ? 1 : 0) != 0);
        this.nativeSetGraphInputStreamBlockingMode(this.nativeGraphHandle, mode);
    }

    public synchronized void addPacketToInputStream(String streamName, Packet packet, long timestamp) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        if (!this.graphRunning) {
            this.addPacketToBuffer(streamName, packet.copy(), timestamp);
        } else {
            this.nativeAddPacketToInputStream(this.nativeGraphHandle, streamName, packet.getNativeHandle(), timestamp);
        }
    }

    public synchronized void addConsumablePacketToInputStream(String streamName, Packet packet, long timestamp) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        if (!this.graphRunning) {
            this.addPacketToBuffer(streamName, packet.copy(), timestamp);
            packet.release();
        } else {
            this.nativeMovePacketToInputStream(this.nativeGraphHandle, streamName, packet.getNativeHandle(), timestamp);
            packet.release();
        }
    }

    public synchronized void closeInputStream(String streamName) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        this.nativeCloseInputStream(this.nativeGraphHandle, streamName);
    }

    public synchronized void closeAllInputStreams() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        this.nativeCloseAllInputStreams(this.nativeGraphHandle);
    }

    public synchronized void closeAllPacketSources() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        this.nativeCloseAllPacketSources(this.nativeGraphHandle);
    }

    public synchronized void waitUntilGraphDone() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        this.nativeWaitUntilGraphDone(this.nativeGraphHandle);
    }

    public synchronized void waitUntilGraphIdle() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called.");
        this.nativeWaitUntilGraphIdle(this.nativeGraphHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tearDown() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        for (Map.Entry<String, Packet> entry : this.sidePackets.entrySet()) {
            entry.getValue().release();
        }
        this.sidePackets.clear();
        for (Map.Entry<String, Packet> entry : this.streamHeaders.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().release();
        }
        this.streamHeaders.clear();
        for (Map.Entry<String, Object> entry : this.packetBuffers.entrySet()) {
            for (PacketBufferItem item : (ArrayList)entry.getValue()) {
                item.packet.release();
            }
        }
        this.packetBuffers.clear();
        Object object = this.terminationLock;
        synchronized (object) {
            if (this.nativeGraphHandle != 0L) {
                this.nativeReleaseGraph(this.nativeGraphHandle);
                this.nativeGraphHandle = 0L;
            }
        }
        this.callbacks.clear();
    }

    public synchronized void updatePacketReference(Packet referencePacket, Packet newPacket) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        this.nativeUpdatePacketReference(referencePacket.getNativeHandle(), newPacket.getNativeHandle());
    }

    @Deprecated
    public synchronized void createGlRunner(String name, long javaGlContext) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        Preconditions.checkArgument((boolean)name.equals("gpu_shared"));
        this.setParentGlContext(javaGlContext);
    }

    public synchronized void setParentGlContext(long javaGlContext) {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        Preconditions.checkState((!this.graphRunning ? 1 : 0) != 0);
        this.nativeSetParentGlContext(this.nativeGraphHandle, javaGlContext);
    }

    public synchronized void cancelGraph() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        this.nativeCancelGraph(this.nativeGraphHandle);
    }

    public GraphProfiler getProfiler() {
        Preconditions.checkState((this.nativeGraphHandle != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
        return new GraphProfiler(this.nativeGetProfiler(this.nativeGraphHandle), this);
    }

    private boolean addPacketToBuffer(String streamName, Packet packet, long timestamp) {
        List buffer;
        if (!this.packetBuffers.containsKey(streamName)) {
            this.packetBuffers.put(streamName, new ArrayList());
        }
        if ((buffer = (List)this.packetBuffers.get(streamName)).size() > 20) {
            for (Map.Entry<String, Packet> entry : this.streamHeaders.entrySet()) {
                if (entry.getValue() != null) continue;
                ((FluentLogger.Api)logger.atSevere()).log("Stream: %s might be missing.", (Object)entry.getKey());
            }
            throw new RuntimeException("Graph is not started because of missing streams");
        }
        buffer.add(new PacketBufferItem(packet, timestamp));
        return true;
    }

    private void moveBufferedPacketsToInputStream() {
        if (!this.packetBuffers.isEmpty()) {
            for (Map.Entry<String, ArrayList<PacketBufferItem>> entry : this.packetBuffers.entrySet()) {
                for (PacketBufferItem item : entry.getValue()) {
                    try {
                        this.nativeMovePacketToInputStream(this.nativeGraphHandle, entry.getKey(), item.packet.getNativeHandle(), item.timestamp);
                    }
                    catch (MediaPipeException e) {
                        ((FluentLogger.Api)logger.atSevere()).log("AddPacket for stream: %s failed: %s.", (Object)entry.getKey(), (Object)e.getMessage());
                        throw e;
                    }
                    item.packet.release();
                }
            }
            this.packetBuffers.clear();
        }
    }

    private static void splitStreamNamePacketMap(Map<String, Packet> namePacketMap, String[] streamNames, long[] packets) {
        if (namePacketMap.size() != streamNames.length || namePacketMap.size() != packets.length) {
            throw new RuntimeException("Input array length doesn't match the map size!");
        }
        int i = 0;
        for (Map.Entry<String, Packet> entry : namePacketMap.entrySet()) {
            streamNames[i] = entry.getKey();
            packets[i] = entry.getValue().getNativeHandle();
            ++i;
        }
    }

    private boolean hasAllStreamHeaders() {
        for (Map.Entry<String, Packet> entry : this.streamHeaders.entrySet()) {
            if (entry.getValue() != null) continue;
            return false;
        }
        return true;
    }

    private native long nativeCreateGraph();

    private native void nativeReleaseGraph(long var1);

    private native void nativeAddPacketCallback(long var1, String var3, PacketCallback var4);

    private native void nativeAddMultiStreamCallback(long var1, List<String> var3, PacketListCallback var4);

    private native long nativeAddSurfaceOutput(long var1, String var3);

    private native void nativeLoadBinaryGraph(long var1, String var3);

    private native void nativeLoadBinaryGraphBytes(long var1, byte[] var3);

    private native void nativeLoadBinaryGraphTemplate(long var1, byte[] var3);

    private native void nativeSetGraphType(long var1, String var3);

    private native void nativeSetGraphOptions(long var1, byte[] var3);

    private native byte[] nativeGetCalculatorGraphConfig(long var1);

    private native void nativeRunGraphUntilClose(long var1, String[] var3, long[] var4);

    private native void nativeStartRunningGraph(long var1, String[] var3, long[] var4, String[] var5, long[] var6);

    private native void nativeAddPacketToInputStream(long var1, String var3, long var4, long var6);

    private native void nativeMovePacketToInputStream(long var1, String var3, long var4, long var6);

    private native void nativeSetGraphInputStreamBlockingMode(long var1, boolean var3);

    private native void nativeCloseInputStream(long var1, String var3);

    private native void nativeCloseAllInputStreams(long var1);

    private native void nativeCloseAllPacketSources(long var1);

    private native void nativeWaitUntilGraphDone(long var1);

    private native void nativeWaitUntilGraphIdle(long var1);

    private native void nativeUpdatePacketReference(long var1, long var3);

    private native void nativeSetParentGlContext(long var1, long var3);

    private native void nativeCancelGraph(long var1);

    private native long nativeGetProfiler(long var1);

    private static class PacketBufferItem {
        final Packet packet;
        final Long timestamp;

        private PacketBufferItem(Packet packet, Long timestamp) {
            this.packet = packet;
            this.timestamp = timestamp;
        }
    }
}

