/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import android.graphics.Bitmap;
import com.google.mediapipe.framework.Graph;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.PacketCreator;

public class AndroidPacketCreator
extends PacketCreator {
    public AndroidPacketCreator(Graph context) {
        super(context);
    }

    public Packet createRgbImageFrame(Bitmap bitmap) {
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new RuntimeException("bitmap must use ARGB_8888 config.");
        }
        return Packet.create(this.nativeCreateRgbImageFrame(this.mediapipeGraph.getNativeHandle(), bitmap));
    }

    public Packet createRgbaImageFrame(Bitmap bitmap) {
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new RuntimeException("bitmap must use ARGB_8888 config.");
        }
        return Packet.create(this.nativeCreateRgbaImageFrame(this.mediapipeGraph.getNativeHandle(), bitmap));
    }

    private native long nativeCreateRgbImageFrame(long var1, Bitmap var3);

    private native long nativeCreateRgbaImageFrame(long var1, Bitmap var3);
}

