/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.components;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import android.view.Surface;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mediapipe.components.CameraHelper;
import com.google.mediapipe.glutil.EglManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nullable;
import javax.microedition.khronos.egl.EGLSurface;

public class CameraXPreviewHelper
extends CameraHelper {
    private static final String TAG = "CameraXPreviewHelper";
    private static final Size TARGET_SIZE = new Size(1280, 720);
    private static final int CLOCK_OFFSET_CALIBRATION_ATTEMPTS = 3;
    private final SingleThreadHandlerExecutor renderExecutor = new SingleThreadHandlerExecutor("RenderThread", 0);
    private ProcessCameraProvider cameraProvider;
    private Preview preview;
    private Camera camera;
    private Size frameSize;
    private int frameRotation;
    @Nullable
    private CameraCharacteristics cameraCharacteristics = null;
    private float focalLengthPixels = Float.MIN_VALUE;
    private int cameraTimestampSource = 0;

    @Override
    public void startCamera(Activity activity, CameraHelper.CameraFacing cameraFacing, SurfaceTexture unusedSurfaceTexture) {
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, TARGET_SIZE);
    }

    public void startCamera(Activity activity, CameraHelper.CameraFacing cameraFacing, SurfaceTexture unusedSurfaceTexture, @Nullable Size targetSize) {
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, targetSize);
    }

    public void startCamera(Context context, LifecycleOwner lifecycleOwner, CameraHelper.CameraFacing cameraFacing, @Nullable Size targetSize) {
        Executor mainThreadExecutor = ContextCompat.getMainExecutor((Context)context);
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)context);
        targetSize = targetSize == null ? TARGET_SIZE : targetSize;
        Size rotatedSize = new Size(targetSize.getHeight(), targetSize.getWidth());
        cameraProviderFuture.addListener(() -> {
            try {
                this.cameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                Log.e((String)TAG, (String)"Unable to get ProcessCameraProvider: ", (Throwable)e);
                return;
            }
            this.preview = new Preview.Builder().setTargetResolution(rotatedSize).build();
            CameraSelector cameraSelector = cameraFacing == CameraHelper.CameraFacing.FRONT ? CameraSelector.DEFAULT_FRONT_CAMERA : CameraSelector.DEFAULT_BACK_CAMERA;
            this.preview.setSurfaceProvider((Executor)this.renderExecutor, request -> {
                Size resolution = request.getResolution();
                Log.d((String)TAG, (String)String.format("Received surface request for resolution %dx%d", resolution.getWidth(), resolution.getHeight()));
                SurfaceTexture previewFrameTexture = CameraXPreviewHelper.createSurfaceTexture();
                previewFrameTexture.setDefaultBufferSize(resolution.getWidth(), resolution.getHeight());
                previewFrameTexture.setOnFrameAvailableListener(frameTexture -> {
                    if (frameTexture != previewFrameTexture) {
                        return;
                    }
                    this.onInitialFrameReceived(context, frameTexture);
                }, this.renderExecutor.getHandler());
                Surface surface = new Surface(previewFrameTexture);
                Log.d((String)TAG, (String)"Providing surface");
                request.provideSurface(surface, (Executor)this.renderExecutor, result -> {
                    Log.d((String)TAG, (String)("Surface request result: " + result));
                    previewFrameTexture.release();
                    surface.release();
                });
            });
            this.cameraProvider.unbindAll();
            this.camera = this.cameraProvider.bindToLifecycle(lifecycleOwner, cameraSelector, new UseCase[]{this.preview});
        }, mainThreadExecutor);
    }

    @Override
    public boolean isCameraRotated() {
        return this.frameRotation % 180 == 90;
    }

    @Override
    public Size computeDisplaySizeFromViewSize(Size viewSize) {
        return this.frameSize;
    }

    @Nullable
    private Size getOptimalViewSize(Size targetSize) {
        if (this.cameraCharacteristics != null) {
            StreamConfigurationMap map = (StreamConfigurationMap)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Size[] outputSizes = map.getOutputSizes(SurfaceTexture.class);
            int selectedWidth = -1;
            int selectedHeight = -1;
            float selectedAspectRatioDifference = 1000.0f;
            float targetAspectRatio = (float)targetSize.getWidth() / (float)targetSize.getHeight();
            for (Size size : outputSizes) {
                float aspectRatio = (float)size.getWidth() / (float)size.getHeight();
                float aspectRatioDifference = Math.abs(aspectRatio - targetAspectRatio);
                if (!(aspectRatioDifference <= selectedAspectRatioDifference) || (selectedWidth != -1 || selectedHeight != -1) && (size.getWidth() > selectedWidth || size.getWidth() < this.frameSize.getWidth() || size.getHeight() > selectedHeight || size.getHeight() < this.frameSize.getHeight())) continue;
                selectedWidth = size.getWidth();
                selectedHeight = size.getHeight();
                selectedAspectRatioDifference = aspectRatioDifference;
            }
            if (selectedWidth != -1 && selectedHeight != -1) {
                return new Size(selectedWidth, selectedHeight);
            }
        }
        return null;
    }

    public long getTimeOffsetToMonoClockNanos() {
        if (this.cameraTimestampSource == 1) {
            return CameraXPreviewHelper.getOffsetFromRealtimeTimestampSource();
        }
        return CameraXPreviewHelper.getOffsetFromUnknownTimestampSource();
    }

    private static long getOffsetFromUnknownTimestampSource() {
        return 0L;
    }

    private static long getOffsetFromRealtimeTimestampSource() {
        long offset = Long.MAX_VALUE;
        long lowestGap = Long.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            long startMonoTs = System.nanoTime();
            long realTs = SystemClock.elapsedRealtimeNanos();
            long endMonoTs = System.nanoTime();
            long gapMonoTs = endMonoTs - startMonoTs;
            if (gapMonoTs >= lowestGap) continue;
            lowestGap = gapMonoTs;
            offset = (startMonoTs + endMonoTs) / 2L - realTs;
        }
        return offset;
    }

    public float getFocalLengthPixels() {
        return this.focalLengthPixels;
    }

    public Size getFrameSize() {
        return this.frameSize;
    }

    private void onInitialFrameReceived(Context context, SurfaceTexture previewFrameTexture) {
        CameraHelper.OnCameraStartedListener listener;
        previewFrameTexture.setOnFrameAvailableListener(null);
        previewFrameTexture.updateTexImage();
        previewFrameTexture.detachFromGLContext();
        if (!this.preview.getAttachedSurfaceResolution().equals((Object)this.frameSize)) {
            this.frameSize = this.preview.getAttachedSurfaceResolution();
            this.frameRotation = this.camera.getCameraInfo().getSensorRotationDegrees();
            if (this.frameSize.getWidth() == 0 || this.frameSize.getHeight() == 0) {
                Log.d((String)TAG, (String)"Invalid frameSize.");
                return;
            }
        }
        Integer selectedLensFacing = this.cameraFacing == CameraHelper.CameraFacing.FRONT ? 0 : 1;
        this.cameraCharacteristics = CameraXPreviewHelper.getCameraCharacteristics(context, selectedLensFacing);
        if (this.cameraCharacteristics != null) {
            this.cameraTimestampSource = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE);
            this.focalLengthPixels = this.calculateFocalLengthInPixels();
        }
        if ((listener = this.onCameraStartedListener) != null) {
            ContextCompat.getMainExecutor((Context)context).execute(() -> listener.onCameraStarted(previewFrameTexture));
        }
    }

    private float calculateFocalLengthInPixels() {
        float focalLengthMm = ((float[])this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS))[0];
        float sensorWidthMm = ((SizeF)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE)).getWidth();
        return (float)this.frameSize.getWidth() * focalLengthMm / sensorWidthMm;
    }

    private static SurfaceTexture createSurfaceTexture() {
        EglManager eglManager = new EglManager(null);
        EGLSurface tempEglSurface = eglManager.createOffscreenSurface(1, 1);
        eglManager.makeCurrent(tempEglSurface, tempEglSurface);
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        SurfaceTexture previewFrameTexture = new SurfaceTexture(textures[0]);
        return previewFrameTexture;
    }

    @Nullable
    private static CameraCharacteristics getCameraCharacteristics(Context context, Integer lensFacing) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            List<String> cameraList = Arrays.asList(cameraManager.getCameraIdList());
            for (String availableCameraId : cameraList) {
                CameraCharacteristics availableCameraCharacteristics = cameraManager.getCameraCharacteristics(availableCameraId);
                Integer availableLensFacing = (Integer)availableCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (availableLensFacing == null || !availableLensFacing.equals(lensFacing)) continue;
                return availableCameraCharacteristics;
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Accessing camera ID info got error: " + (Object)((Object)e)));
        }
        return null;
    }

    private static final class SingleThreadHandlerExecutor
    implements Executor {
        private final HandlerThread handlerThread;
        private final Handler handler;

        SingleThreadHandlerExecutor(String threadName, int priority) {
            this.handlerThread = new HandlerThread(threadName, priority);
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
        }

        Handler getHandler() {
            return this.handler;
        }

        @Override
        public void execute(Runnable command) {
            if (!this.handler.post(command)) {
                throw new RejectedExecutionException(this.handlerThread.getName() + " is shutting down.");
            }
        }

        boolean shutdown() {
            return this.handlerThread.quitSafely();
        }
    }
}

