/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.glutil;

import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.mediapipe.glutil.EglManager;
import com.google.mediapipe.glutil.ShaderUtil;
import javax.annotation.Nullable;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;

public class GlThread
extends Thread {
    private static final String TAG = "GlThread";
    private static final String THREAD_NAME = "mediapipe.glutil.GlThread";
    private boolean doneStarting;
    private boolean startedSuccessfully;
    private final Object startLock = new Object();
    protected volatile EglManager eglManager;
    protected EGLSurface eglSurface = null;
    protected Handler handler = null;
    protected Looper looper = null;
    protected int framebuffer = 0;

    public GlThread(@Nullable Object parentContext) {
        this(parentContext, null);
    }

    public GlThread(@Nullable Object parentContext, @Nullable int[] additionalConfigAttributes) {
        this.eglManager = new EglManager(parentContext, additionalConfigAttributes);
        this.setName(THREAD_NAME);
    }

    public Handler getHandler() {
        return this.handler;
    }

    public Looper getLooper() {
        return this.looper;
    }

    public EglManager getEglManager() {
        return this.eglManager;
    }

    public EGLContext getEGLContext() {
        return this.eglManager.getContext();
    }

    public int getFramebuffer() {
        return this.framebuffer;
    }

    public void bindFramebuffer(int texture, int width, int height) {
        GLES20.glBindFramebuffer((int)36160, (int)this.framebuffer);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException("Framebuffer not complete, status=" + status);
        }
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        ShaderUtil.checkGlError("glViewport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
            this.handler = this.createHandler();
            this.looper = Looper.myLooper();
            Log.d((String)TAG, (String)String.format("Starting GL thread %s", this.getName()));
            this.prepareGl();
            this.startedSuccessfully = true;
        }
        finally {
            Object object = this.startLock;
            synchronized (object) {
                this.doneStarting = true;
                this.startLock.notify();
            }
        }
        try {
            Looper.loop();
            this.looper = null;
            this.releaseGl();
            this.eglManager.release();
        }
        catch (Throwable throwable) {
            this.looper = null;
            this.releaseGl();
            this.eglManager.release();
            Log.d((String)TAG, (String)String.format("Stopping GL thread %s", this.getName()));
            throw throwable;
        }
        Log.d((String)TAG, (String)String.format("Stopping GL thread %s", this.getName()));
    }

    public boolean quitSafely() {
        if (this.looper == null) {
            return false;
        }
        this.looper.quitSafely();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilReady() throws InterruptedException {
        Object object = this.startLock;
        synchronized (object) {
            while (!this.doneStarting) {
                this.startLock.wait();
            }
        }
        return this.startedSuccessfully;
    }

    public void prepareGl() {
        this.eglSurface = this.createEglSurface();
        this.eglManager.makeCurrent(this.eglSurface, this.eglSurface);
        GLES20.glDisable((int)2929);
        GLES20.glDisable((int)2884);
        int[] values = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])values, (int)0);
        this.framebuffer = values[0];
    }

    public void releaseGl() {
        if (this.framebuffer != 0) {
            int[] values = new int[]{this.framebuffer};
            GLES20.glDeleteFramebuffers((int)1, (int[])values, (int)0);
            this.framebuffer = 0;
        }
        this.eglManager.makeNothingCurrent();
        if (this.eglSurface != null) {
            this.eglManager.releaseSurface(this.eglSurface);
            this.eglSurface = null;
        }
    }

    protected Handler createHandler() {
        return new Handler();
    }

    protected EGLSurface createEglSurface() {
        return this.eglManager.createOffscreenSurface(1, 1);
    }
}

