/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.mediapipe.framework.Graph;
import com.google.mediapipe.framework.GraphGlSyncToken;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.ProtoUtil;
import com.google.mediapipe.framework.TextureFrame;
import com.google.mediapipe.framework.TextureReleaseCallback;
import com.google.protobuf.MessageLite;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class PacketCreator {
    protected Graph mediapipeGraph;

    public PacketCreator(Graph context) {
        this.mediapipeGraph = context;
    }

    public Packet createReferencePacket(Packet packet) {
        return Packet.create(this.nativeCreateReferencePacket(this.mediapipeGraph.getNativeHandle(), packet.getNativeHandle()));
    }

    public Packet createRgbImage(ByteBuffer buffer, int width, int height) {
        int widthStep = (width * 3 + 3) / 4 * 4;
        if (widthStep * height != buffer.capacity()) {
            throw new RuntimeException("The size of the buffer should be: " + widthStep * height);
        }
        return Packet.create(this.nativeCreateRgbImage(this.mediapipeGraph.getNativeHandle(), buffer, width, height));
    }

    public Packet createAudioPacket(byte[] data, int numChannels, int numSamples) {
        PacketCreator.checkAudioDataSize(data.length, numChannels, numSamples);
        return Packet.create(this.nativeCreateAudioPacket(this.mediapipeGraph.getNativeHandle(), data, 0, numChannels, numSamples));
    }

    public Packet createAudioPacket(ByteBuffer data, int numChannels, int numSamples) {
        PacketCreator.checkAudioDataSize(data.remaining(), numChannels, numSamples);
        if (data.isDirect()) {
            return Packet.create(this.nativeCreateAudioPacketDirect(this.mediapipeGraph.getNativeHandle(), data.slice(), numChannels, numSamples));
        }
        if (data.hasArray()) {
            return Packet.create(this.nativeCreateAudioPacket(this.mediapipeGraph.getNativeHandle(), data.array(), data.arrayOffset() + data.position(), numChannels, numSamples));
        }
        throw new IllegalArgumentException("Data must be either a direct byte buffer or be backed by a byte array.");
    }

    private static void checkAudioDataSize(int length, int numChannels, int numSamples) {
        int expectedLength = numChannels * numSamples * 2;
        if (expectedLength != length) {
            throw new IllegalArgumentException("Please check the audio data size, has to be num_channels * num_samples * 2 = " + expectedLength + " but was " + length);
        }
    }

    public Packet createRgbImageFromRgba(ByteBuffer buffer, int width, int height) {
        if (width * height * 4 != buffer.capacity()) {
            throw new RuntimeException("The size of the buffer should be: " + width * height * 4);
        }
        return Packet.create(this.nativeCreateRgbImageFromRgba(this.mediapipeGraph.getNativeHandle(), buffer, width, height));
    }

    public Packet createGrayscaleImage(ByteBuffer buffer, int width, int height) {
        if (width * height != buffer.capacity()) {
            throw new RuntimeException("The size of the buffer should be: " + width * height + " but is " + buffer.capacity());
        }
        return Packet.create(this.nativeCreateGrayscaleImage(this.mediapipeGraph.getNativeHandle(), buffer, width, height));
    }

    public Packet createRgbaImageFrame(ByteBuffer buffer, int width, int height) {
        if (buffer.capacity() != width * height * 4) {
            throw new RuntimeException("buffer doesn't have the correct size.");
        }
        return Packet.create(this.nativeCreateRgbaImageFrame(this.mediapipeGraph.getNativeHandle(), buffer, width, height));
    }

    public Packet createFloatImageFrame(FloatBuffer buffer, int width, int height) {
        if (buffer.capacity() != width * height * 4) {
            throw new RuntimeException("buffer doesn't have the correct size.");
        }
        return Packet.create(this.nativeCreateFloatImageFrame(this.mediapipeGraph.getNativeHandle(), buffer, width, height));
    }

    public Packet createInt16(short value) {
        return Packet.create(this.nativeCreateInt16(this.mediapipeGraph.getNativeHandle(), value));
    }

    public Packet createInt32(int value) {
        return Packet.create(this.nativeCreateInt32(this.mediapipeGraph.getNativeHandle(), value));
    }

    public Packet createInt64(long value) {
        return Packet.create(this.nativeCreateInt64(this.mediapipeGraph.getNativeHandle(), value));
    }

    public Packet createFloat32(float value) {
        return Packet.create(this.nativeCreateFloat32(this.mediapipeGraph.getNativeHandle(), value));
    }

    public Packet createFloat64(double value) {
        return Packet.create(this.nativeCreateFloat64(this.mediapipeGraph.getNativeHandle(), value));
    }

    public Packet createBool(boolean value) {
        return Packet.create(this.nativeCreateBool(this.mediapipeGraph.getNativeHandle(), value));
    }

    public Packet createString(String value) {
        return Packet.create(this.nativeCreateString(this.mediapipeGraph.getNativeHandle(), value));
    }

    public Packet createInt16Vector(short[] data) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Packet createInt32Vector(int[] data) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Packet createInt64Vector(long[] data) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Packet createFloat32Vector(float[] data) {
        return Packet.create(this.nativeCreateFloat32Vector(this.mediapipeGraph.getNativeHandle(), data));
    }

    public Packet createFloat64Vector(double[] data) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Packet createInt32Array(int[] data) {
        return Packet.create(this.nativeCreateInt32Array(this.mediapipeGraph.getNativeHandle(), data));
    }

    public Packet createFloat32Array(float[] data) {
        return Packet.create(this.nativeCreateFloat32Array(this.mediapipeGraph.getNativeHandle(), data));
    }

    public Packet createByteArray(byte[] data) {
        return Packet.create(this.nativeCreateStringFromByteArray(this.mediapipeGraph.getNativeHandle(), data));
    }

    public Packet createVideoHeader(int width, int height) {
        return Packet.create(this.nativeCreateVideoHeader(this.mediapipeGraph.getNativeHandle(), width, height));
    }

    public Packet createTimeSeriesHeader(int numChannels, double sampleRate) {
        return Packet.create(this.nativeCreateTimeSeriesHeader(this.mediapipeGraph.getNativeHandle(), numChannels, sampleRate));
    }

    public Packet createMatrix(int rows, int cols, float[] data) {
        return Packet.create(this.nativeCreateMatrix(this.mediapipeGraph.getNativeHandle(), rows, cols, data));
    }

    public Packet createSerializedProto(MessageLite message) {
        return Packet.create(this.nativeCreateStringFromByteArray(this.mediapipeGraph.getNativeHandle(), message.toByteArray()));
    }

    public Packet createCalculatorOptions(MessageLite message) {
        return Packet.create(this.nativeCreateCalculatorOptions(this.mediapipeGraph.getNativeHandle(), message.toByteArray()));
    }

    public Packet createProto(MessageLite message) {
        ProtoUtil.SerializedMessage serialized = ProtoUtil.pack(message);
        return Packet.create(this.nativeCreateProto(this.mediapipeGraph.getNativeHandle(), serialized));
    }

    public Packet createCameraIntrinsics(float fx, float fy, float cx, float cy, float width, float height) {
        return Packet.create(this.nativeCreateCameraIntrinsics(this.mediapipeGraph.getNativeHandle(), fx, fy, cx, cy, width, height));
    }

    public Packet createGpuBuffer(int name, int width, int height, TextureReleaseCallback releaseCallback) {
        return Packet.create(this.nativeCreateGpuBuffer(this.mediapipeGraph.getNativeHandle(), name, width, height, releaseCallback));
    }

    @Deprecated
    public Packet createGpuBuffer(int name, int width, int height) {
        return Packet.create(this.nativeCreateGpuBuffer(this.mediapipeGraph.getNativeHandle(), name, width, height, null));
    }

    public Packet createGpuBuffer(TextureFrame frame) {
        return Packet.create(this.nativeCreateGpuBuffer(this.mediapipeGraph.getNativeHandle(), frame.getTextureName(), frame.getWidth(), frame.getHeight(), frame));
    }

    private void releaseWithSyncToken(long nativeSyncToken, TextureReleaseCallback releaseCallback) {
        releaseCallback.release(new GraphGlSyncToken(nativeSyncToken));
    }

    private native long nativeCreateReferencePacket(long var1, long var3);

    private native long nativeCreateRgbImage(long var1, ByteBuffer var3, int var4, int var5);

    private native long nativeCreateAudioPacket(long var1, byte[] var3, int var4, int var5, int var6);

    private native long nativeCreateAudioPacketDirect(long var1, ByteBuffer var3, int var4, int var5);

    private native long nativeCreateRgbImageFromRgba(long var1, ByteBuffer var3, int var4, int var5);

    private native long nativeCreateGrayscaleImage(long var1, ByteBuffer var3, int var4, int var5);

    private native long nativeCreateRgbaImageFrame(long var1, ByteBuffer var3, int var4, int var5);

    private native long nativeCreateFloatImageFrame(long var1, FloatBuffer var3, int var4, int var5);

    private native long nativeCreateInt16(long var1, short var3);

    private native long nativeCreateInt32(long var1, int var3);

    private native long nativeCreateInt64(long var1, long var3);

    private native long nativeCreateFloat32(long var1, float var3);

    private native long nativeCreateFloat64(long var1, double var3);

    private native long nativeCreateBool(long var1, boolean var3);

    private native long nativeCreateString(long var1, String var3);

    private native long nativeCreateVideoHeader(long var1, int var3, int var4);

    private native long nativeCreateTimeSeriesHeader(long var1, int var3, double var4);

    private native long nativeCreateMatrix(long var1, int var3, int var4, float[] var5);

    private native long nativeCreateGpuBuffer(long var1, int var3, int var4, int var5, TextureReleaseCallback var6);

    private native long nativeCreateInt32Array(long var1, int[] var3);

    private native long nativeCreateFloat32Array(long var1, float[] var3);

    private native long nativeCreateFloat32Vector(long var1, float[] var3);

    private native long nativeCreateStringFromByteArray(long var1, byte[] var3);

    private native long nativeCreateProto(long var1, ProtoUtil.SerializedMessage var3);

    private native long nativeCreateCalculatorOptions(long var1, byte[] var3);

    private native long nativeCreateCameraIntrinsics(long var1, float var3, float var4, float var5, float var6, float var7, float var8);
}

