/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;
import com.google.common.flogger.FluentLogger;
import java.io.File;

public class AssetCacheDbHelper
extends SQLiteOpenHelper {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    public static final int DATABASE_VERSION = 2;
    public static final String DATABASE_NAME = "mediapipe.db";
    private static final String INT_TYPE = " INTEGER";
    private static final String TEXT_TYPE = " TEXT";
    private static final String TEXT_UNIQUE_TYPE = " TEXT NOT NULL UNIQUE";
    private static final String COMMA_SEP = ",";
    private static final String SQL_CREATE_TABLE = "CREATE TABLE AssetVersion (_id INTEGER PRIMARY KEY,asset TEXT NOT NULL UNIQUE,cache_path TEXT,version INTEGER )";
    private static final String SQL_DELETE_TABLE = "DROP TABLE IF EXISTS AssetVersion";

    public AssetCacheDbHelper(Context context) {
        super(context, DATABASE_NAME, null, 2);
    }

    public boolean checkVersion(String assetPath, int currentAppVersion) {
        String[] selectionArgs;
        String selection;
        String[] projection;
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = this.queryAssetCacheTable(db, projection = new String[]{"version"}, selection = "asset = ?", selectionArgs = new String[]{assetPath});
        if (cursor.getCount() == 0) {
            return false;
        }
        cursor.moveToFirst();
        int cachedVersion = cursor.getInt(cursor.getColumnIndexOrThrow("version"));
        cursor.close();
        return cachedVersion == currentAppVersion;
    }

    public void invalidateCache(int currentAppVersion) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "version != ?";
        String[] selectionArgs = new String[]{Integer.toString(currentAppVersion)};
        this.removeCachedFiles(db, selection, selectionArgs);
        db.delete("AssetVersion", selection, selectionArgs);
    }

    public void insertAsset(String asset, String cachePath, int appVersion) {
        SQLiteDatabase db = this.getWritableDatabase();
        String selection = "asset = ? and cache_path != ?";
        String[] selectionArgs = new String[]{asset, cachePath};
        this.removeCachedFiles(db, selection, selectionArgs);
        ContentValues values = new ContentValues();
        values.put("asset", asset);
        values.put("cache_path", cachePath);
        values.put("version", Integer.valueOf(appVersion));
        long newRowId = db.insertWithOnConflict("AssetVersion", null, values, 5);
        if (newRowId == -1L) {
            throw new RuntimeException("Can't insert entry into the mediapipe db.");
        }
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(SQL_CREATE_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(SQL_DELETE_TABLE);
        this.onCreate(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    private Cursor queryAssetCacheTable(SQLiteDatabase db, String[] projection, String selection, String[] selectionArgs) {
        return db.query("AssetVersion", projection, selection, selectionArgs, null, null, null);
    }

    private void removeCachedFiles(SQLiteDatabase db, String selection, String[] selectionArgs) {
        String[] projection = new String[]{"cache_path"};
        Cursor cursor = this.queryAssetCacheTable(db, projection, selection, selectionArgs);
        if (cursor.moveToFirst()) {
            do {
                String cachedPath;
                File file;
                if (!(file = new File(cachedPath = cursor.getString(cursor.getColumnIndexOrThrow("cache_path")))).exists() || file.delete()) continue;
                ((FluentLogger.Api)logger.atWarning()).log("Stale cached file: %s can't be deleted.", (Object)cachedPath);
            } while (cursor.moveToNext());
        }
        cursor.close();
    }

    public static abstract class AssetCacheEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "AssetVersion";
        public static final String COLUMN_NAME_ASSET = "asset";
        public static final String COLUMN_NAME_CACHE_PATH = "cache_path";
        public static final String COLUMN_NAME_VERSION = "version";
    }
}

