/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.components;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.util.Log;
import com.google.mediapipe.components.TextureFrameConsumer;
import com.google.mediapipe.components.TextureFrameProducer;
import com.google.mediapipe.framework.AppTextureFrame;
import com.google.mediapipe.framework.GlSyncToken;
import com.google.mediapipe.glutil.ExternalTextureRenderer;
import com.google.mediapipe.glutil.GlThread;
import com.google.mediapipe.glutil.ShaderUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.microedition.khronos.egl.EGLContext;

public class ExternalTextureConverter
implements TextureFrameProducer {
    private static final String TAG = "ExternalTextureConv";
    private static final int DEFAULT_NUM_BUFFERS = 2;
    private static final String THREAD_NAME = "ExternalTextureConverter";
    private RenderThread thread;
    private Throwable startupException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalTextureConverter(EGLContext parentContext, int numBuffers) {
        block7: {
            this.startupException = null;
            this.thread = this.makeRenderThread(parentContext, numBuffers);
            this.thread.setName(THREAD_NAME);
            Object threadExceptionLock = new Object();
            this.thread.setUncaughtExceptionHandler((t, e) -> {
                Object object = threadExceptionLock;
                synchronized (object) {
                    this.startupException = e;
                    threadExceptionLock.notify();
                }
            });
            this.thread.start();
            try {
                boolean success = this.thread.waitUntilReady();
                if (success) break block7;
                Object object = threadExceptionLock;
                synchronized (object) {
                    while (this.startupException == null) {
                        threadExceptionLock.wait();
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                Log.e((String)TAG, (String)("thread was unexpectedly interrupted: " + ie.getMessage()));
                throw new RuntimeException(ie);
            }
        }
        this.thread.setUncaughtExceptionHandler(null);
        if (this.startupException != null) {
            this.thread.quitSafely();
            throw new RuntimeException(this.startupException);
        }
    }

    public void setFlipY(boolean flip) {
        this.thread.setFlipY(flip);
    }

    public void setRotation(int rotation) {
        this.thread.setRotation(rotation);
    }

    public void setTimestampOffsetNanos(long offsetInNanos) {
        this.thread.setTimestampOffsetNanos(offsetInNanos);
    }

    public ExternalTextureConverter(EGLContext parentContext) {
        this(parentContext, 2);
    }

    public ExternalTextureConverter(EGLContext parentContext, SurfaceTexture texture, int targetWidth, int targetHeight) {
        this(parentContext);
        this.thread.setSurfaceTexture(texture, targetWidth, targetHeight);
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.thread.setUncaughtExceptionHandler(handler);
    }

    public void setSurfaceTexture(SurfaceTexture texture, int width, int height) {
        if (texture != null && (width == 0 || height == 0)) {
            throw new RuntimeException("ExternalTextureConverter: setSurfaceTexture dimensions cannot be zero");
        }
        this.thread.getHandler().post(() -> this.thread.setSurfaceTexture(texture, width, height));
    }

    public void setSurfaceTextureAndAttachToGLContext(SurfaceTexture texture, int width, int height) {
        if (texture != null && (width == 0 || height == 0)) {
            throw new RuntimeException("ExternalTextureConverter: setSurfaceTexture dimensions cannot be zero");
        }
        this.thread.getHandler().post(() -> this.thread.setSurfaceTextureAndAttachToGLContext(texture, width, height));
    }

    @Override
    public void setConsumer(TextureFrameConsumer next) {
        this.thread.setConsumer(next);
    }

    public void addConsumer(TextureFrameConsumer consumer) {
        this.thread.addConsumer(consumer);
    }

    public void removeConsumer(TextureFrameConsumer consumer) {
        this.thread.removeConsumer(consumer);
    }

    public void close() {
        if (this.thread == null) {
            return;
        }
        this.thread.quitSafely();
        try {
            this.thread.join();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Log.e((String)TAG, (String)("thread was unexpectedly interrupted: " + ie.getMessage()));
            throw new RuntimeException(ie);
        }
    }

    protected RenderThread makeRenderThread(EGLContext parentContext, int numBuffers) {
        return new RenderThread(parentContext, numBuffers);
    }

    protected static class RenderThread
    extends GlThread
    implements SurfaceTexture.OnFrameAvailableListener {
        private static final long NANOS_PER_MICRO = 1000L;
        private volatile SurfaceTexture surfaceTexture = null;
        private final List<TextureFrameConsumer> consumers;
        private final Queue<PoolTextureFrame> framesAvailable = new ArrayDeque<PoolTextureFrame>();
        private int framesInUse = 0;
        private final int framesToKeep;
        private ExternalTextureRenderer renderer = null;
        private long nextFrameTimestampOffset = 0L;
        private long timestampOffsetNanos = 0L;
        private long previousTimestamp = 0L;
        private boolean previousTimestampValid = false;
        protected int destinationWidth = 0;
        protected int destinationHeight = 0;

        public RenderThread(EGLContext parentContext, int numBuffers) {
            super(parentContext);
            this.framesToKeep = numBuffers;
            this.renderer = new ExternalTextureRenderer();
            this.consumers = new ArrayList<TextureFrameConsumer>();
        }

        public void setFlipY(boolean flip) {
            this.renderer.setFlipY(flip);
        }

        public void setRotation(int rotation) {
            this.renderer.setRotation(rotation);
        }

        public void setSurfaceTexture(SurfaceTexture texture, int width, int height) {
            if (this.surfaceTexture != null) {
                this.surfaceTexture.setOnFrameAvailableListener(null);
            }
            this.surfaceTexture = texture;
            if (this.surfaceTexture != null) {
                this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            }
            this.destinationWidth = width;
            this.destinationHeight = height;
        }

        public void setSurfaceTextureAndAttachToGLContext(SurfaceTexture texture, int width, int height) {
            this.setSurfaceTexture(texture, width, height);
            int[] textures = new int[1];
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            this.surfaceTexture.attachToGLContext(textures[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setConsumer(TextureFrameConsumer consumer) {
            List<TextureFrameConsumer> list = this.consumers;
            synchronized (list) {
                this.consumers.clear();
                this.consumers.add(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addConsumer(TextureFrameConsumer consumer) {
            List<TextureFrameConsumer> list = this.consumers;
            synchronized (list) {
                this.consumers.add(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeConsumer(TextureFrameConsumer consumer) {
            List<TextureFrameConsumer> list = this.consumers;
            synchronized (list) {
                this.consumers.remove(consumer);
            }
        }

        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            this.handler.post(() -> this.renderNext(surfaceTexture));
        }

        @Override
        public void prepareGl() {
            super.prepareGl();
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.renderer.setup();
        }

        @Override
        public void releaseGl() {
            this.setSurfaceTexture(null, 0, 0);
            while (!this.framesAvailable.isEmpty()) {
                RenderThread.teardownFrame(this.framesAvailable.remove());
            }
            this.renderer.release();
            super.releaseGl();
        }

        public void setTimestampOffsetNanos(long offsetInNanos) {
            this.timestampOffsetNanos = offsetInNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void renderNext(SurfaceTexture fromTexture) {
            if (fromTexture != this.surfaceTexture) {
                return;
            }
            List<TextureFrameConsumer> list = this.consumers;
            synchronized (list) {
                boolean frameUpdated = false;
                for (TextureFrameConsumer consumer : this.consumers) {
                    AppTextureFrame outputFrame = this.nextOutputFrame();
                    this.updateOutputFrame(outputFrame);
                    frameUpdated = true;
                    if (consumer == null) continue;
                    if (Log.isLoggable((String)ExternalTextureConverter.TAG, (int)2)) {
                        Log.v((String)ExternalTextureConverter.TAG, (String)String.format("Locking tex: %d width: %d height: %d", outputFrame.getTextureName(), outputFrame.getWidth(), outputFrame.getHeight()));
                    }
                    outputFrame.setInUse();
                    consumer.onNewFrame(outputFrame);
                }
                if (!frameUpdated) {
                    AppTextureFrame outputFrame = this.nextOutputFrame();
                    this.updateOutputFrame(outputFrame);
                }
            }
        }

        private static void teardownFrame(AppTextureFrame frame) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{frame.getTextureName()}, (int)0);
        }

        private PoolTextureFrame createFrame() {
            int destinationTextureId = ShaderUtil.createRgbaTexture(this.destinationWidth, this.destinationHeight);
            Log.d((String)ExternalTextureConverter.TAG, (String)String.format("Created output texture: %d width: %d height: %d", destinationTextureId, this.destinationWidth, this.destinationHeight));
            this.bindFramebuffer(destinationTextureId, this.destinationWidth, this.destinationHeight);
            return new PoolTextureFrame(destinationTextureId, this.destinationWidth, this.destinationHeight);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AppTextureFrame nextOutputFrame() {
            PoolTextureFrame outputFrame;
            RenderThread renderThread = this;
            synchronized (renderThread) {
                outputFrame = this.framesAvailable.poll();
                ++this.framesInUse;
            }
            if (outputFrame == null) {
                outputFrame = this.createFrame();
            } else if (outputFrame.getWidth() != this.destinationWidth || outputFrame.getHeight() != this.destinationHeight) {
                this.waitUntilReleased(outputFrame);
                RenderThread.teardownFrame(outputFrame);
                outputFrame = this.createFrame();
            } else {
                this.waitUntilReleased(outputFrame);
            }
            return outputFrame;
        }

        protected synchronized void poolFrameReleased(PoolTextureFrame frame) {
            this.framesAvailable.offer(frame);
            --this.framesInUse;
            int keep = Math.max(this.framesToKeep - this.framesInUse, 0);
            while (this.framesAvailable.size() > keep) {
                PoolTextureFrame textureFrameToRemove = this.framesAvailable.remove();
                this.handler.post(() -> RenderThread.teardownFrame(textureFrameToRemove));
            }
        }

        private void updateOutputFrame(AppTextureFrame outputFrame) {
            this.bindFramebuffer(outputFrame.getTextureName(), this.destinationWidth, this.destinationHeight);
            this.renderer.render(this.surfaceTexture);
            long textureTimestamp = (this.surfaceTexture.getTimestamp() + this.timestampOffsetNanos) / 1000L;
            if (this.previousTimestampValid && textureTimestamp + this.nextFrameTimestampOffset <= this.previousTimestamp) {
                this.nextFrameTimestampOffset = this.previousTimestamp + 1L - textureTimestamp;
            }
            outputFrame.setTimestamp(textureTimestamp + this.nextFrameTimestampOffset);
            this.previousTimestamp = outputFrame.getTimestamp();
            this.previousTimestampValid = true;
        }

        private void waitUntilReleased(AppTextureFrame frame) {
            try {
                if (Log.isLoggable((String)ExternalTextureConverter.TAG, (int)2)) {
                    Log.v((String)ExternalTextureConverter.TAG, (String)String.format("Waiting for tex: %d width: %d height: %d timestamp: %d", frame.getTextureName(), frame.getWidth(), frame.getHeight(), frame.getTimestamp()));
                }
                frame.waitUntilReleased();
                if (Log.isLoggable((String)ExternalTextureConverter.TAG, (int)2)) {
                    Log.v((String)ExternalTextureConverter.TAG, (String)String.format("Finished waiting for tex: %d width: %d height: %d timestamp: %d", frame.getTextureName(), frame.getWidth(), frame.getHeight(), frame.getTimestamp()));
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                Log.e((String)ExternalTextureConverter.TAG, (String)("thread was unexpectedly interrupted: " + ie.getMessage()));
                throw new RuntimeException(ie);
            }
        }

        private class PoolTextureFrame
        extends AppTextureFrame {
            public PoolTextureFrame(int textureName, int width, int height) {
                super(textureName, width, height);
            }

            @Override
            public void release(GlSyncToken syncToken) {
                super.release(syncToken);
                RenderThread.this.poolFrameReleased(this);
            }

            @Override
            public void release() {
                super.release();
                RenderThread.this.poolFrameReleased(this);
            }
        }
    }
}

