/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.common.R;
import com.serenegiant.view.MeasureSpecDelegater;
import com.serenegiant.widget.IScaledView;
import com.serenegiant.widget.TransformTextureView;

public class AspectScaledTextureView
extends TransformTextureView
implements TextureView.SurfaceTextureListener,
IScaledView {
    private static final boolean DEBUG = false;
    private static final String TAG = AspectScaledTextureView.class.getSimpleName();
    protected final Matrix mImageMatrix = new Matrix();
    private int mScaleMode;
    private double mRequestedAspect;
    private boolean mNeedResizeToKeepAspect;
    private volatile boolean mHasSurface;
    private TextureView.SurfaceTextureListener mListener;
    private int prevWidth = -1;
    private int prevHeight = -1;

    public AspectScaledTextureView(@NonNull Context context) {
        this(context, null, 0);
    }

    public AspectScaledTextureView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectScaledTextureView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IScaledView, defStyleAttr, 0);
        try {
            this.mRequestedAspect = a.getFloat(R.styleable.IScaledView_aspect_ratio, -1.0f);
            this.mScaleMode = a.getInt(R.styleable.IScaledView_scale_mode, 0);
            this.mNeedResizeToKeepAspect = a.getBoolean(R.styleable.IScaledView_resize_to_keep_aspect, true);
        }
        finally {
            a.recycle();
        }
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecDelegater.MeasureSpec spec = MeasureSpecDelegater.onMeasure((View)this, this.mRequestedAspect, this.mScaleMode, this.mNeedResizeToKeepAspect, widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(spec.widthMeasureSpec, spec.heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.prevWidth != this.getWidth() || this.prevHeight != this.getHeight()) {
            this.prevWidth = this.getWidth();
            this.prevHeight = this.getHeight();
            this.onResize(this.prevWidth, this.prevHeight);
        }
        this.init();
    }

    public final void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        this.mListener = listener;
    }

    public TextureView.SurfaceTextureListener getSurfaceTextureListener() {
        return this.mListener;
    }

    protected void onResize(int width, int height) {
    }

    public boolean hasSurface() {
        return this.mHasSurface;
    }

    public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surface, int width, int height) {
        this.mHasSurface = true;
        this.init();
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(@NonNull SurfaceTexture surface) {
        this.mHasSurface = false;
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureDestroyed(surface);
        }
        return false;
    }

    public void onSurfaceTextureUpdated(@NonNull SurfaceTexture surface) {
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureUpdated(surface);
        }
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.setAspectRatio((double)width / (double)height);
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    @Override
    public void setScaleMode(int scale_mode) {
        if (this.mScaleMode != scale_mode) {
            this.mScaleMode = scale_mode;
            this.requestLayout();
        }
    }

    @Override
    public int getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public void setNeedResizeToKeepAspect(boolean keepAspect) {
        if (this.mNeedResizeToKeepAspect != keepAspect) {
            this.mNeedResizeToKeepAspect = keepAspect;
            this.requestLayout();
        }
    }

    protected void init() {
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        this.mImageMatrix.reset();
        switch (this.mScaleMode) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                double contentWidth = this.mRequestedAspect > 0.0 ? this.mRequestedAspect * (double)viewHeight : (double)viewHeight;
                double contentHeight = viewHeight;
                double scaleX = (double)viewWidth / contentWidth;
                double scaleY = (double)viewHeight / contentHeight;
                double scale = this.mScaleMode == 2 ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
                double width = scale * contentWidth;
                double height = scale * contentHeight;
                this.mImageMatrix.postScale((float)(width / (double)viewWidth), (float)(height / (double)viewHeight), (float)viewWidth / 2.0f, (float)viewHeight / 2.0f);
            }
        }
        this.setTransform(this.mImageMatrix);
    }
}

