/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.opengl.Matrix;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.serenegiant.common.R;
import com.serenegiant.view.MeasureSpecDelegater;
import com.serenegiant.widget.GLView;
import com.serenegiant.widget.IScaledView;

public class AspectScaledGLView
extends GLView
implements IScaledView {
    private static final boolean DEBUG = false;
    private static final String TAG = AspectScaledGLView.class.getSimpleName();
    private int mScaleMode;
    private double mRequestedAspect;
    private boolean mNeedResizeToKeepAspect;
    private int prevWidth = -1;
    private int prevHeight = -1;

    public AspectScaledGLView(@Nullable Context context) {
        this(context, null, 0);
    }

    public AspectScaledGLView(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AspectScaledGLView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IScaledView, defStyleAttr, 0);
        try {
            this.mRequestedAspect = a.getFloat(R.styleable.IScaledView_aspect_ratio, -1.0f);
            this.mScaleMode = a.getInt(R.styleable.IScaledView_scale_mode, 0);
            this.mNeedResizeToKeepAspect = a.getBoolean(R.styleable.IScaledView_resize_to_keep_aspect, true);
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecDelegater.MeasureSpec spec = MeasureSpecDelegater.onMeasure((View)this, this.mRequestedAspect, this.mScaleMode, this.mNeedResizeToKeepAspect, widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(spec.widthMeasureSpec, spec.heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = right - left;
        int height = bottom - top;
        if (width == 0 || height == 0) {
            return;
        }
        if (this.prevWidth != width || this.prevHeight != height) {
            this.prevWidth = width;
            this.prevHeight = height;
            this.onResize(width, height);
        }
        this.init();
    }

    protected void onResize(int width, int height) {
    }

    @Override
    public void setAspectRatio(double aspectRatio) {
        if (this.mRequestedAspect != aspectRatio) {
            this.mRequestedAspect = aspectRatio;
            this.requestLayout();
        }
    }

    @Override
    public void setAspectRatio(int width, int height) {
        if (width > 0 && height > 0) {
            this.setAspectRatio((double)width / (double)height);
        }
    }

    @Override
    public double getAspectRatio() {
        return this.mRequestedAspect;
    }

    @Override
    public void setScaleMode(int scaleMode) {
        if (this.mScaleMode != scaleMode) {
            this.mScaleMode = scaleMode;
            this.requestLayout();
        }
    }

    @Override
    public int getScaleMode() {
        return this.mScaleMode;
    }

    @Override
    public void setNeedResizeToKeepAspect(boolean keepAspect) {
        if (this.mNeedResizeToKeepAspect != keepAspect) {
            this.mNeedResizeToKeepAspect = keepAspect;
            this.requestLayout();
        }
    }

    protected void init() {
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        double videoWidth = this.mRequestedAspect > 0.0 ? this.mRequestedAspect * (double)viewHeight : (double)viewHeight;
        double videoHeight = viewHeight;
        float[] transform = new float[16];
        Matrix.setIdentityM((float[])transform, (int)0);
        switch (this.mScaleMode) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                double scaleX = (double)viewWidth / videoWidth;
                double scaleY = (double)viewHeight / videoHeight;
                double scale = this.mScaleMode == 2 ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
                float width = (float)(scale * videoWidth);
                float height = (float)(scale * videoHeight);
                Matrix.scaleM((float[])transform, (int)0, (float)(width / (float)viewWidth), (float)(height / (float)viewHeight), (float)1.0f);
            }
        }
        this.setTransform(transform);
    }
}

