/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view.animation;

import android.os.Build;
import android.view.View;

public class DepthPageTransformer {
    private static final float MIN_SCALE = 0.75f;

    public void transformPage(View view, float position) {
        int pageWidth = view.getWidth();
        if (position < -1.0f) {
            view.setAlpha(0.0f);
        } else if (position <= 0.0f) {
            view.setAlpha(1.0f);
            view.setTranslationX(0.0f);
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(0.0f);
            }
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
        } else if (position <= 1.0f) {
            view.setAlpha(1.0f - position);
            view.setTranslationX((float)pageWidth * -position);
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(-1.0f);
            }
            float scaleFactor = 0.75f + 0.25f * (1.0f - Math.abs(position));
            view.setScaleX(scaleFactor);
            view.setScaleY(scaleFactor);
        } else {
            view.setAlpha(0.0f);
        }
    }
}

