/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.graphics.PointF;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.serenegiant.view.IGLViewTransformer;
import com.serenegiant.widget.IGLTransformView;

public class GLViewTransformer
implements IGLViewTransformer {
    private static final boolean DEBUG = false;
    private static final String TAG = GLViewTransformer.class.getSimpleName();
    private final IGLTransformView mTargetView;
    @Size(min=16L)
    @NonNull
    private final float[] mTransform = new float[16];
    @Size(min=16L)
    @NonNull
    private final float[] mDefaultTransform = new float[16];
    @Size(min=16L)
    @NonNull
    private final float[] work = new float[16];
    private float mCurrentTransX;
    private float mCurrentTransY;
    private float mCurrentScaleX;
    private float mCurrentScaleY;
    private float mCurrentRotate;

    public GLViewTransformer(@NonNull IGLTransformView view) {
        this.mTargetView = view;
        this.updateTransform(true);
    }

    @NonNull
    public IGLTransformView getTargetView() {
        return this.mTargetView;
    }

    @Override
    @NonNull
    public GLViewTransformer updateTransform(boolean saveAsDefault) {
        this.internalGetTransform(this.mTransform);
        if (saveAsDefault) {
            System.arraycopy(this.mTransform, 0, this.mDefaultTransform, 0, 16);
            this.resetValues();
        } else {
            this.calcValues(this.mTransform);
        }
        return this;
    }

    @Override
    @NonNull
    public final GLViewTransformer setTransform(@Nullable @Size(min=16L) float[] transform) {
        if (transform != null && transform.length >= 16) {
            System.arraycopy(transform, 0, this.mTransform, 0, 16);
        } else {
            Matrix.setIdentityM((float[])this.mTransform, (int)0);
        }
        this.internalSetTransform(this.mTransform);
        this.calcValues(this.mTransform);
        return this;
    }

    @Override
    @NonNull
    public float[] getTransform(@Nullable float[] transform) {
        float[] result = transform;
        if (result == null && transform.length < 16) {
            result = new float[16];
        }
        System.arraycopy(this.mTransform, 0, result, 0, 16);
        return result;
    }

    @Override
    @NonNull
    public GLViewTransformer setDefault(@Nullable @Size(min=16L) float[] transform) {
        if (transform == null || transform.length < 16) {
            Matrix.setIdentityM((float[])this.mDefaultTransform, (int)0);
        } else {
            System.arraycopy(transform, 0, this.mDefaultTransform, 0, 16);
        }
        return this;
    }

    @Override
    @NonNull
    public GLViewTransformer reset() {
        this.setTransform(this.mDefaultTransform);
        return this;
    }

    public GLViewTransformer setTranslate(float x, float y) {
        return this.setTransform(x, y, this.mCurrentScaleX, this.mCurrentScaleY, this.mCurrentRotate);
    }

    public GLViewTransformer translate(float dx, float dy) {
        return this.setTransform(this.mCurrentTransX + dx, this.mCurrentTransY + dy, this.mCurrentScaleX, this.mCurrentScaleY, this.mCurrentRotate);
    }

    public PointF getTranslate(@Nullable PointF tr) {
        if (tr != null) {
            tr.set(this.mCurrentTransX, this.mCurrentTransY);
            return tr;
        }
        return new PointF(this.mCurrentTransX, this.mCurrentTransY);
    }

    public float getTranslateX() {
        return this.mCurrentTransX;
    }

    public float getTranslateY() {
        return this.mCurrentTransY;
    }

    public GLViewTransformer setScale(float scaleX, float scaleY) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, scaleX, scaleY, this.mCurrentRotate);
    }

    public GLViewTransformer setScale(float scale) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, scale, scale, this.mCurrentRotate);
    }

    public GLViewTransformer scale(float scaleX, float scaleY) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX * scaleX, this.mCurrentScaleY * scaleY, this.mCurrentRotate);
    }

    public GLViewTransformer scale(float scale) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX * scale, this.mCurrentScaleY * scale, this.mCurrentRotate);
    }

    public float getScaleX() {
        return this.mCurrentScaleX;
    }

    public float getScaleY() {
        return this.mCurrentScaleY;
    }

    public float getScale() {
        return Math.min(this.mCurrentScaleX, this.mCurrentScaleY);
    }

    public GLViewTransformer setRotate(float degrees) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX, this.mCurrentScaleY, degrees);
    }

    public GLViewTransformer rotate(float degrees) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX, this.mCurrentScaleY, this.mCurrentRotate + degrees);
    }

    public float getRotation() {
        return this.mCurrentRotate;
    }

    public void mapPoints(@NonNull float[] points) {
        throw new UnsupportedOperationException();
    }

    public void mapPoints(@NonNull float[] dst, @NonNull float[] src) {
        throw new UnsupportedOperationException();
    }

    protected void internalSetTransform(@Nullable float[] transform) {
        if (transform != null) {
            Matrix.multiplyMM((float[])this.work, (int)0, (float[])transform, (int)0, (float[])this.mDefaultTransform, (int)0);
            this.mTargetView.setTransform(this.work);
        } else {
            this.mTargetView.setTransform(this.mDefaultTransform);
        }
    }

    @NonNull
    protected float[] internalGetTransform(@Nullable float[] transform) {
        return this.mTargetView.getTransform(transform);
    }

    protected GLViewTransformer setTransform(float transX, float transY, float scaleX, float scaleY, float degrees) {
        if (this.mCurrentTransX != transX || this.mCurrentTransY != transY || this.mCurrentScaleX != scaleX || this.mCurrentScaleY != scaleY || this.mCurrentRotate != degrees) {
            this.mCurrentScaleX = scaleX;
            this.mCurrentScaleY = scaleY;
            this.mCurrentTransX = transX;
            this.mCurrentTransY = transY;
            this.mCurrentRotate = degrees;
            if (degrees != Float.MAX_VALUE) {
                while (this.mCurrentRotate > 360.0f) {
                    this.mCurrentRotate -= 360.0f;
                }
                while (this.mCurrentRotate < -360.0f) {
                    this.mCurrentRotate += 360.0f;
                }
            }
            int w2 = this.mTargetView.getView().getWidth() >> 1;
            int h2 = this.mTargetView.getView().getHeight() >> 1;
            Matrix.setIdentityM((float[])this.mTransform, (int)0);
            Matrix.multiplyMM((float[])this.mTransform, (int)0, (float[])this.mTransform, (int)0, (float[])this.mDefaultTransform, (int)0);
            Matrix.translateM((float[])this.mTransform, (int)0, (float)transX, (float)transY, (float)0.0f);
            Matrix.scaleM((float[])this.mTransform, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
            if (degrees != Float.MAX_VALUE) {
                Matrix.rotateM((float[])this.mTransform, (int)0, (float)this.mCurrentRotate, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.internalSetTransform(this.mTransform);
        }
        return this;
    }

    protected void calcValues(@NonNull @Size(min=16L) float[] transform) {
    }

    protected void resetValues() {
        this.mCurrentTransY = 0.0f;
        this.mCurrentTransX = 0.0f;
        this.mCurrentScaleY = 1.0f;
        this.mCurrentScaleX = 1.0f;
        this.mCurrentRotate = 0.0f;
    }
}

