/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import androidx.annotation.ArrayRes;
import androidx.annotation.NonNull;

public class TypedArrayUtils {
    private TypedArrayUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static float[] readArray(@NonNull Resources res, @ArrayRes int arrayId, float defaultValue) {
        float[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new float[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getFloat(i, defaultValue);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static boolean[] readArray(@NonNull Resources res, @ArrayRes int arrayId, boolean defaultValue) {
        boolean[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new boolean[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getBoolean(i, defaultValue);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static String[] readArray(@NonNull Resources res, @ArrayRes int arrayId, String defaultValue) {
        String[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new String[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getString(i);
                if (result[i] != null) continue;
                result[i] = defaultValue;
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static CharSequence[] readArray(@NonNull Resources res, @ArrayRes int arrayId, CharSequence defaultValue) {
        CharSequence[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new CharSequence[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getText(i);
                if (result[i] != null) continue;
                result[i] = defaultValue;
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static int[] readArray(@NonNull Resources res, @ArrayRes int arrayId, int defaultValue) {
        int[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new int[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getInt(i, defaultValue);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static int[] readArrayWithException(@NonNull Resources res, @ArrayRes int arrayId, int defaultValue) throws UnsupportedOperationException {
        int[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new int[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getInteger(i, defaultValue);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static int[] readColorArray(@NonNull Resources res, @ArrayRes int arrayId, int defaultValue) {
        int[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new int[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getColor(i, defaultValue);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static float[] readDimensionArray(@NonNull Resources res, @ArrayRes int arrayId, float defaultValue) {
        float[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new float[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getDimension(i, defaultValue);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Drawable[] readDrawableArray(@NonNull Resources res, @ArrayRes int arrayId) {
        Drawable[] result;
        TypedArray a = res.obtainTypedArray(arrayId);
        try {
            int n = a.length();
            result = new Drawable[n];
            for (int i = 0; i < n; ++i) {
                result[i] = a.getDrawable(i);
            }
        }
        finally {
            a.recycle();
        }
        return result;
    }

    public static int getAttr(@NonNull Context context, int attr2, int fallbackAttr) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(attr2, value, true);
        if (value.resourceId != 0) {
            return attr2;
        }
        return fallbackAttr;
    }
}

