/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = JSONHelper.class.getSimpleName();

    private JSONHelper() {
    }

    public static long getLong(JSONObject payload, String key, long defaultValue) throws JSONException {
        long result = defaultValue;
        if (payload.has(key)) {
            try {
                result = payload.getLong(key);
            }
            catch (JSONException e) {
                try {
                    result = Long.parseLong(payload.getString(key));
                }
                catch (Exception e1) {
                    result = payload.getBoolean(key) ? 1L : 0L;
                }
            }
        }
        return result;
    }

    public static long optLong(JSONObject payload, String key, long defaultValue) {
        long result = defaultValue;
        if (payload.has(key)) {
            try {
                result = payload.getLong(key);
            }
            catch (JSONException e) {
                try {
                    result = Long.parseLong(payload.getString(key));
                }
                catch (Exception e1) {
                    try {
                        result = payload.getBoolean(key) ? 1L : 0L;
                    }
                    catch (Exception e2) {
                        Log.w((String)TAG, (Throwable)e2);
                    }
                }
            }
        }
        return result;
    }

    public static long optLong(JSONArray payload, int index, long defaultValue) {
        long result = defaultValue;
        if (payload.length() > index) {
            try {
                result = payload.getLong(index);
            }
            catch (JSONException e) {
                try {
                    result = Long.parseLong(payload.getString(index));
                }
                catch (Exception e1) {
                    try {
                        result = payload.getBoolean(index) ? 1L : 0L;
                    }
                    catch (Exception e2) {
                        Log.w((String)TAG, (Throwable)e2);
                    }
                }
            }
        }
        return result;
    }

    public static int getInt(JSONObject payload, String key, int defaultValue) throws JSONException {
        int result = defaultValue;
        if (payload.has(key)) {
            try {
                result = payload.getInt(key);
            }
            catch (JSONException e) {
                try {
                    result = Integer.parseInt(payload.getString(key));
                }
                catch (Exception e1) {
                    result = payload.getBoolean(key) ? 1 : 0;
                }
            }
        }
        return result;
    }

    public static int optInt(JSONObject payload, String key, int defaultValue) {
        int result = defaultValue;
        if (payload.has(key)) {
            try {
                result = payload.getInt(key);
            }
            catch (JSONException e) {
                try {
                    result = Integer.parseInt(payload.getString(key));
                }
                catch (Exception e1) {
                    try {
                        result = payload.getBoolean(key) ? 1 : 0;
                    }
                    catch (Exception e2) {
                        Log.w((String)TAG, (Throwable)e2);
                    }
                }
            }
        }
        return result;
    }

    public static int optInt(JSONArray payload, int index, int defaultValue) {
        int result = defaultValue;
        if (payload.length() > index) {
            try {
                result = payload.getInt(index);
            }
            catch (JSONException e) {
                try {
                    result = Integer.parseInt(payload.getString(index));
                }
                catch (Exception e1) {
                    try {
                        result = payload.getBoolean(index) ? 1 : 0;
                    }
                    catch (Exception e2) {
                        Log.w((String)TAG, (Throwable)e2);
                    }
                }
            }
        }
        return result;
    }

    public static boolean getBoolean(JSONObject payload, String key, boolean defaultValue) throws JSONException {
        boolean result = defaultValue;
        if (payload.has(key)) {
            try {
                result = payload.getBoolean(key);
            }
            catch (Exception e) {
                try {
                    result = payload.getInt(key) != 0;
                }
                catch (JSONException e1) {
                    result = payload.getDouble(key) != 0.0;
                }
            }
        }
        return result;
    }

    public static boolean optBoolean(JSONObject payload, String key, boolean defaultValue) {
        boolean result = defaultValue;
        if (payload.has(key)) {
            try {
                result = payload.getBoolean(key);
            }
            catch (Exception e) {
                try {
                    result = payload.getInt(key) != 0;
                }
                catch (JSONException e1) {
                    try {
                        result = payload.getDouble(key) != 0.0;
                    }
                    catch (JSONException e2) {
                        Log.w((String)TAG, (Throwable)e2);
                    }
                }
            }
        }
        return result;
    }

    public static boolean optBoolean(JSONArray payload, int index, boolean defaultValue) {
        boolean result = defaultValue;
        if (payload.length() > index) {
            try {
                result = payload.getBoolean(index);
            }
            catch (Exception e) {
                try {
                    result = payload.getInt(index) != 0;
                }
                catch (JSONException e1) {
                    try {
                        result = payload.getDouble(index) != 0.0;
                    }
                    catch (JSONException e2) {
                        Log.w((String)TAG, (Throwable)e2);
                    }
                }
            }
        }
        return result;
    }
}

