/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.system.ContextUtils;

public class PowerHelper {
    private static final String TAG = "PowerHelper";

    private PowerHelper() {
    }

    public static void wake(Activity activity, boolean disableKeyguard, long lockDelayed) {
        PowerHelper.wake(activity, true, true, lockDelayed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"MissingPermission", "WakelockTimeout"})
    public static void wake(@NonNull Activity activity, boolean disableKeyguard, boolean keepScreenOn, long lockDelayed) {
        try {
            PowerManager.WakeLock wakelock = ContextUtils.requireSystemService((Context)activity, PowerManager.class).newWakeLock(805306394, "PowerHelper:disableLock");
            if (lockDelayed > 0L) {
                wakelock.acquire(lockDelayed);
            } else {
                wakelock.acquire();
            }
            try {
                if (disableKeyguard) {
                    activity.getWindow().addFlags(0x480000 | (keepScreenOn ? 128 : 0));
                } else if (keepScreenOn) {
                    activity.getWindow().addFlags(128);
                }
            }
            finally {
                wakelock.release();
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    public static void releaseWakeup(@NonNull Activity activity) {
        activity.getWindow().clearFlags(0x480080);
    }
}

