/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.preference;

import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.utils.ObjectHelper;
import java.util.Map;
import java.util.Set;

public class PrefHelper {
    private PrefHelper() {
    }

    public static short get(@Nullable SharedPreferences pref, String key, short defaultValue) {
        short result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = (short)pref.getInt(key, (int)defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asShort(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static int get(@Nullable SharedPreferences pref, String key, int defaultValue) {
        int result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getInt(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asInt(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static long get(@Nullable SharedPreferences pref, String key, long defaultValue) {
        long result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getLong(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asLong(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static float get(@Nullable SharedPreferences pref, String key, float defaultValue) {
        float result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getFloat(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asFloat(PrefHelper.getObject(pref, key, Float.valueOf(defaultValue)), defaultValue);
            }
        }
        return result;
    }

    public static double get(@Nullable SharedPreferences pref, String key, double defaultValue) {
        double result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = Double.parseDouble(pref.getString(key, Double.toString(defaultValue)));
            }
            catch (Exception e) {
                result = ObjectHelper.asDouble(PrefHelper.getObject(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public static boolean get(@Nullable SharedPreferences pref, String key, boolean defaultValue) {
        boolean result = defaultValue;
        if (pref != null && pref.contains(key)) {
            try {
                result = pref.getBoolean(key, defaultValue);
            }
            catch (Exception e) {
                result = ObjectHelper.asBoolean(PrefHelper.get(pref, key, defaultValue), defaultValue);
            }
        }
        return result;
    }

    public <T> T get(@Nullable SharedPreferences pref, String key, T defaultValue) {
        Object result;
        Class<?> clazz = defaultValue.getClass();
        if (clazz.isInstance(result = PrefHelper.getObject(pref, key, defaultValue))) {
            return (T)result;
        }
        return defaultValue;
    }

    public static final Object getObject(@Nullable SharedPreferences pref, String key) {
        return PrefHelper.getObject(pref, key, null);
    }

    public static final Object getObject(@Nullable SharedPreferences pref, String key, Object defaultValue) {
        Object result = defaultValue;
        if (pref != null && pref.contains(key)) {
            Map all = pref.getAll();
            result = all.get(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NonNull SharedPreferences src, @NonNull SharedPreferences dst) {
        Map values = src.getAll();
        if (values != null && !values.isEmpty()) {
            SharedPreferences.Editor editor = dst.edit();
            try {
                for (Map.Entry entry : values.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        editor.putString(key, (String)value);
                        continue;
                    }
                    if (value instanceof Set) {
                        editor.putStringSet(key, (Set)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        editor.putInt(key, ((Integer)value).intValue());
                        continue;
                    }
                    if (value instanceof Long) {
                        editor.putLong(key, ((Long)value).longValue());
                        continue;
                    }
                    if (value instanceof Float) {
                        editor.putFloat(key, ((Float)value).floatValue());
                        continue;
                    }
                    if (!(value instanceof Boolean)) continue;
                    editor.putBoolean(key, ((Boolean)value).booleanValue());
                }
            }
            finally {
                editor.apply();
            }
        }
    }

    public static void dump(@NonNull String tag, @NonNull SharedPreferences preferences) {
        Map values = preferences.getAll();
        if (values != null && !values.isEmpty()) {
            for (Map.Entry entry : values.entrySet()) {
                Log.d((String)tag, (String)("dump:" + (String)entry.getKey() + "=" + entry.getValue()));
            }
        } else {
            Log.d((String)tag, (String)"dump:empty");
        }
    }
}

