/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.serenegiant.common.R;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.mediastore.MediaInfo;
import com.serenegiant.mediastore.MediaStoreRecyclerAdapterListener;
import com.serenegiant.mediastore.MediaStoreUtils;
import com.serenegiant.mediastore.ThumbnailCache;
import com.serenegiant.mediastore.ThumbnailLoader;
import com.serenegiant.mediastore.ThumbnailLoaderDrawable;
import com.serenegiant.utils.ThreadPool;
import com.serenegiant.view.ViewUtils;
import java.io.IOException;

public class MediaStoreCursorRecyclerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreCursorRecyclerAdapter.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final Context mContext;
    @NonNull
    private final LayoutInflater mInflater;
    private final int mLayoutId;
    @NonNull
    private final MyAsyncQueryHandler mQueryHandler;
    @NonNull
    private final ThumbnailCache mThumbnailCache;
    @NonNull
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    @NonNull
    private final MediaInfo info = new MediaInfo();
    private boolean mNeedValidate;
    private boolean mDataValid;
    private ChangeObserver mChangeObserver;
    private DataSetObserver mDataSetObserver;
    private Cursor mCursor;
    private String mSelection;
    private String[] mSelectionArgs = null;
    private String mSortOrder = null;
    @Nullable
    private RecyclerView mRecycleView;
    @Nullable
    private MediaStoreRecyclerAdapterListener mListener;
    private boolean mShowTitle = false;
    private int mMediaType = 0;
    private int mThumbnailWidth = 200;
    private int mThumbnailHeight = 200;
    protected final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(final View v) {
            if (MediaStoreCursorRecyclerAdapter.this.mRecycleView != null && MediaStoreCursorRecyclerAdapter.this.mRecycleView.isEnabled()) {
                MediaInfo info;
                if (v instanceof Checkable) {
                    ((Checkable)v).setChecked(true);
                    MediaStoreCursorRecyclerAdapter.this.mUIHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((Checkable)v).setChecked(false);
                        }
                    }, 100L);
                }
                if (MediaStoreCursorRecyclerAdapter.this.mListener != null && (info = (MediaInfo)v.getTag(R.id.info)) != null) {
                    try {
                        MediaStoreCursorRecyclerAdapter.this.mListener.onItemClick(MediaStoreCursorRecyclerAdapter.this, v, info);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            } else {
                Log.w((String)TAG, (String)("onClick:mRecycleView=" + MediaStoreCursorRecyclerAdapter.this.mRecycleView));
            }
        }
    };
    protected final View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            MediaInfo info;
            if (MediaStoreCursorRecyclerAdapter.this.mRecycleView != null && MediaStoreCursorRecyclerAdapter.this.mRecycleView.isEnabled() && MediaStoreCursorRecyclerAdapter.this.mListener != null && (info = (MediaInfo)v.getTag(R.id.info)) != null) {
                try {
                    return MediaStoreCursorRecyclerAdapter.this.mListener.onItemLongClick(MediaStoreCursorRecyclerAdapter.this, v, info);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
            return false;
        }
    };

    public MediaStoreCursorRecyclerAdapter(@NonNull Context context, @LayoutRes int itemLayout) {
        this(context, itemLayout, true);
    }

    public MediaStoreCursorRecyclerAdapter(@NonNull Context context, @LayoutRes int itemLayout, boolean refreshNow) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = itemLayout;
        this.mQueryHandler = new MyAsyncQueryHandler(context.getContentResolver(), this);
        this.mThumbnailCache = new ThumbnailCache(context);
        this.mNeedValidate = true;
        if (refreshNow) {
            this.refresh();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.releaseCursor();
        }
        finally {
            super.finalize();
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecycleView = recyclerView;
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecycleView = null;
        super.onDetachedFromRecyclerView(recyclerView);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = this.mInflater.inflate(this.mLayoutId, parent, false);
        view.setOnClickListener(this.mOnClickListener);
        view.setOnLongClickListener(this.mOnLongClickListener);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        this.setInfo(holder, this.getMediaInfo(position, this.info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mCursor != null ? this.mCursor.getCount() : 0;
        }
    }

    @NonNull
    public MediaInfo getItem(int position) {
        return this.getMediaInfo(position, null);
    }

    public void setValidateItems(boolean needValidate) {
        if (this.mNeedValidate != needValidate) {
            this.mNeedValidate = needValidate;
        }
    }

    public void setListener(MediaStoreRecyclerAdapterListener listener) {
        this.mListener = listener;
    }

    public void notifyDataSetInvalidated() {
    }

    public void refresh() {
        ThreadPool.preStartAllCoreThreads();
        this.mQueryHandler.requery();
    }

    public void setThumbnailSize(int size) {
        this.setThumbnailSize(size, size);
    }

    public void setThumbnailSize(int width, int height) {
        if (this.mThumbnailWidth != width || this.mThumbnailHeight != height) {
            this.mThumbnailWidth = width;
            this.mThumbnailHeight = height;
            this.mThumbnailCache.clear();
            this.onContentChanged();
        }
    }

    public void setShowTitle(boolean showTitle) {
        if (this.mShowTitle != showTitle) {
            this.mShowTitle = showTitle;
            this.onContentChanged();
        }
    }

    public boolean getShowTitle() {
        return this.mShowTitle;
    }

    public int getMediaType() {
        return this.mMediaType % 3;
    }

    public void setMediaType(int media_type) {
        if (this.mMediaType != media_type % 3) {
            this.mMediaType = media_type % 3;
            this.onContentChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private MediaInfo getMediaInfo(int position, @Nullable MediaInfo info) {
        MediaInfo _info = info != null ? info : new MediaInfo();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCursor == null) {
                throw new IllegalStateException("Cursor is not ready!");
            }
            if (this.mCursor.moveToPosition(position)) {
                _info.loadFromCursor(this.mCursor);
            }
        }
        return _info;
    }

    protected void onContentChanged() {
        this.mQueryHandler.requery();
    }

    protected void releaseCursor() {
        Cursor old = this.swapCursor(null);
        if (old != null && !old.isClosed()) {
            old.close();
        }
    }

    @Nullable
    protected Cursor getCursor(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Cursor swapCursor(@Nullable Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return null;
        }
        Cursor oldCursor = this.mCursor;
        if (oldCursor != null) {
            if (this.mChangeObserver != null) {
                oldCursor.unregisterContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                oldCursor.unregisterDataSetObserver(this.mDataSetObserver);
            }
        }
        Object object = this.mSync;
        synchronized (object) {
            this.mCursor = newCursor;
        }
        if (newCursor != null) {
            if (this.mChangeObserver != null) {
                newCursor.registerContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                newCursor.registerDataSetObserver(this.mDataSetObserver);
            }
            this.mDataValid = true;
            this.notifyDataSetChanged();
        } else {
            this.mDataValid = false;
            this.notifyDataSetInvalidated();
        }
        return oldCursor;
    }

    private void setInfo(@NonNull ViewHolder holder, @NonNull MediaInfo info) {
        holder.info.set(info);
        ImageView iv = holder.mImageView;
        TextView tv = holder.mTitleView;
        if (iv != null) {
            Drawable drawable2 = iv.getDrawable();
            if (!(drawable2 instanceof ThumbnailLoaderDrawable)) {
                drawable2 = new MyThumbnailLoaderDrawable(this.mContext, this.mThumbnailWidth, this.mThumbnailHeight);
                iv.setImageDrawable(drawable2);
            }
            ((ThumbnailLoaderDrawable)drawable2).startLoad(info);
        }
        if (tv != null) {
            tv.setVisibility(this.mShowTitle ? 0 : 8);
            if (this.mShowTitle) {
                tv.setText((CharSequence)info.title);
            }
        }
    }

    static /* synthetic */ String[] access$402(MediaStoreCursorRecyclerAdapter x0, String[] x1) {
        x0.mSelectionArgs = x1;
        return x1;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView mTitleView;
        private final ImageView mImageView;
        @NonNull
        private final MediaInfo info = new MediaInfo();

        public ViewHolder(@NonNull View v) {
            super(v);
            v.setTag(R.id.info, (Object)this.info);
            this.mImageView = ViewUtils.findIconView(v);
            this.mTitleView = ViewUtils.findTitleView(v);
        }
    }

    private class MyThumbnailLoader
    extends ThumbnailLoader {
        public MyThumbnailLoader(MyThumbnailLoaderDrawable parent) {
            super(parent);
        }

        @Override
        @Nullable
        protected Bitmap loadThumbnail(@NonNull Context context, @NonNull MediaInfo info, int requestWidth, int requestHeight) {
            Bitmap result = null;
            try {
                result = MediaStoreCursorRecyclerAdapter.this.mThumbnailCache.getThumbnail(context.getContentResolver(), info, requestWidth, requestHeight);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
    }

    private class MyThumbnailLoaderDrawable
    extends ThumbnailLoaderDrawable {
        public MyThumbnailLoaderDrawable(Context context, int width, int height) {
            super(context, width, height);
        }

        @Override
        @NonNull
        protected ThumbnailLoader createLoader() {
            return new MyThumbnailLoader(this);
        }

        @Override
        protected Bitmap checkCache(long id2) {
            return MediaStoreCursorRecyclerAdapter.this.mThumbnailCache.get(id2);
        }

        @Override
        protected void setBitmap(@Nullable Bitmap bitmap) {
            Bitmap _bitmap = bitmap;
            if (_bitmap == null) {
                _bitmap = BitmapHelper.fromDrawable(this.getContext(), R.drawable.ic_error_outline_red_24dp);
            }
            super.setBitmap(_bitmap);
        }
    }

    private class MyDataSetObserver
    extends DataSetObserver {
        private MyDataSetObserver() {
        }

        public void onChanged() {
            MediaStoreCursorRecyclerAdapter.this.mDataValid = true;
            MediaStoreCursorRecyclerAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            MediaStoreCursorRecyclerAdapter.this.mDataValid = false;
            MediaStoreCursorRecyclerAdapter.this.notifyDataSetInvalidated();
        }
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(MediaStoreCursorRecyclerAdapter.this.mUIHandler);
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            MediaStoreCursorRecyclerAdapter.this.refresh();
        }
    }

    private static final class MyAsyncQueryHandler
    extends AsyncQueryHandler {
        @NonNull
        private final MediaStoreCursorRecyclerAdapter mAdapter;

        public MyAsyncQueryHandler(@NonNull ContentResolver cr, @NonNull MediaStoreCursorRecyclerAdapter adapter) {
            super(cr);
            this.mAdapter = adapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requery() {
            Object object = this.mAdapter.mSync;
            synchronized (object) {
                if (this.mAdapter.mCursor != null) {
                    this.mAdapter.mCursor.close();
                    this.mAdapter.mCursor = null;
                }
                this.mAdapter.mSelection = MediaStoreUtils.SELECTIONS[this.mAdapter.mMediaType % 3];
                MediaStoreCursorRecyclerAdapter.access$402(this.mAdapter, null);
                this.startQuery(0, (Object)this.mAdapter, MediaStoreUtils.QUERY_URI_FILES, MediaStoreUtils.PROJ_MEDIA, this.mAdapter.mSelection, this.mAdapter.mSelectionArgs, this.mAdapter.mSortOrder);
            }
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            super.onQueryComplete(token, cookie, cursor);
            Cursor oldCursor = this.mAdapter.swapCursor(cursor);
            if (oldCursor != null && !oldCursor.isClosed()) {
                oldCursor.close();
            }
        }
    }
}

