/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.PermissionUtils;
import com.serenegiant.system.SAFUtils;
import com.serenegiant.utils.FileUtils;
import java.io.File;
import java.io.IOException;

public class MediaFileUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaFileUtils.class.getSimpleName();

    private MediaFileUtils() {
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static synchronized DocumentFile getSAFRecordingRoot(@NonNull Context context, int saveTreeId) {
        DocumentFile root = null;
        if (BuildCheck.isAPI21()) {
            if (SAFUtils.hasPermission(context, saveTreeId)) {
                try {
                    root = SAFUtils.getDir(context, saveTreeId, FileUtils.DIR_NAME);
                    if (!root.exists() || !root.canWrite()) {
                        Log.d((String)TAG, (String)("path will be wrong, will already be removed," + (root != null ? root.getUri() : null)));
                        root = null;
                    }
                }
                catch (IOException | IllegalStateException e) {
                    root = null;
                    Log.d((String)TAG, (String)"path is wrong, will already be removed.", (Throwable)e);
                }
            }
            if (root == null) {
                SAFUtils.releasePersistableUriPermission(context, saveTreeId);
            }
        }
        return root;
    }

    @Nullable
    public static synchronized DocumentFile getRecordingRoot(@NonNull Context context, @NonNull String type, int saveTreeId) {
        File captureDir;
        DocumentFile root = MediaFileUtils.getSAFRecordingRoot(context, saveTreeId);
        if (root == null && PermissionUtils.hasWriteExternalStorage(context) && (captureDir = FileUtils.getCaptureDir(context, type)) != null && captureDir.canWrite()) {
            root = DocumentFile.fromFile((File)captureDir);
        }
        return root;
    }

    public static synchronized DocumentFile getRecordingFile(@NonNull Context context, int saveTreeId, @NonNull String type, @Nullable String mime, @NonNull String ext) throws IOException {
        DocumentFile root = MediaFileUtils.getRecordingRoot(context, type, saveTreeId);
        if (root != null) {
            return SAFUtils.getFile(root, null, mime, FileUtils.getDateTimeString() + ext);
        }
        throw new IOException("Failed to get recording root dir");
    }
}

