/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.media.AbstractAudioEncoder;
import com.serenegiant.media.AudioSampler;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IAudioSampler;
import com.serenegiant.media.IRecorder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public class AudioEncoder
extends AbstractAudioEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = AudioEncoder.class.getSimpleName();
    private AudioThread mAudioThread = null;

    public AudioEncoder(@NonNull IRecorder recorder, @NonNull EncoderListener listener, int audio_source, int audio_channels) {
        super(recorder, listener, audio_source, audio_channels, 44100, 64000);
        if (audio_source < 0 || audio_source > 7) {
            throw new IllegalArgumentException("invalid audio source:" + audio_source);
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.mAudioThread == null) {
            this.mAudioThread = new AudioThread();
            this.mAudioThread.start();
        }
    }

    @Override
    public void stop() {
        this.mAudioThread = null;
        super.stop();
    }

    @Override
    public void release() {
        this.mAudioThread = null;
        super.release();
    }

    private final class AudioThread
    extends Thread {
        public AudioThread() {
            super("AudioThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ByteBuffer buf;
            int frame_count;
            block42: {
                Process.setThreadPriority((int)-16);
                int buffer_size = AudioSampler.getAudioBufferSize(AudioEncoder.this.mChannelCount, AudioEncoder.this.mSampleRate, 1024, 25);
                AudioRecord audioRecord = IAudioSampler.createAudioRecord(AudioEncoder.this.mAudioSource, AudioEncoder.this.mSampleRate, AudioEncoder.this.mChannelCount, 2, buffer_size);
                frame_count = 0;
                int err_count = 0;
                buf = ByteBuffer.allocateDirect(buffer_size).order(ByteOrder.nativeOrder());
                if (audioRecord != null) {
                    try {
                        if (!AudioEncoder.this.mIsCapturing) break block42;
                        audioRecord.startRecording();
                        try {
                            int sizeInBytes = 1024 * AudioEncoder.this.mChannelCount;
                            while (AudioEncoder.this.mIsCapturing && !AudioEncoder.this.mRequestStop) {
                                int readBytes;
                                int recordingState = audioRecord.getRecordingState();
                                if (recordingState != 3) {
                                    if (err_count == 0) {
                                        Log.e((String)TAG, (String)("not a recording state," + recordingState));
                                    }
                                    if (++err_count > 20) break;
                                    Object object = AudioEncoder.this.mSync;
                                    synchronized (object) {
                                        AudioEncoder.this.mSync.wait(100L);
                                        continue;
                                    }
                                }
                                buf.clear();
                                try {
                                    readBytes = audioRecord.read(buf, sizeInBytes);
                                }
                                catch (Exception e) {
                                    break;
                                }
                                if (readBytes > 0) {
                                    err_count = 0;
                                    ++frame_count;
                                    buf.position(readBytes);
                                    buf.flip();
                                    AudioEncoder.this.encode(buf, readBytes, AudioEncoder.this.getInputPTSUs());
                                    AudioEncoder.this.frameAvailableSoon();
                                } else {
                                    if (readBytes == 0) {
                                        err_count = 0;
                                        continue;
                                    }
                                    if (readBytes == -1) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR");
                                        }
                                        ++err_count;
                                    } else if (readBytes == -2) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR_BAD_VALUE");
                                        }
                                        ++err_count;
                                    } else if (readBytes == -3) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR_INVALID_OPERATION");
                                        }
                                        ++err_count;
                                    } else if (readBytes == -6) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)"Read error ERROR_DEAD_OBJECT");
                                        }
                                        ++err_count;
                                    } else if (readBytes < 0) {
                                        if (err_count == 0) {
                                            Log.e((String)TAG, (String)("Read returned unknown err " + readBytes));
                                        }
                                        ++err_count;
                                    }
                                }
                                if (err_count <= 10) continue;
                                break;
                            }
                            if (frame_count > 0) {
                                AudioEncoder.this.frameAvailableSoon();
                            }
                        }
                        finally {
                            audioRecord.stop();
                        }
                    }
                    catch (Exception readBytes) {
                    }
                    finally {
                        audioRecord.release();
                    }
                }
            }
            if (frame_count == 0) {
                for (int i = 0; AudioEncoder.this.mIsCapturing && i < 5; ++i) {
                    buf.position(1024);
                    buf.flip();
                    AudioEncoder.this.encode(buf, 1024, AudioEncoder.this.getInputPTSUs());
                    AudioEncoder.this.frameAvailableSoon();
                    AudioThread audioThread = this;
                    synchronized (audioThread) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
        }
    }
}

