/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.media.Decoder;
import com.serenegiant.media.DecoderListener;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(value=16)
public abstract class AbstractDecoder
implements Decoder {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractDecoder.class.getSimpleName();
    public static final int TIMEOUT_USEC = 10000;
    @NonNull
    protected final Object mSync = new Object();
    @NonNull
    private final String mMimeType;
    @NonNull
    protected final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    @Nullable
    private MediaFormat mFormat;
    @Nullable
    protected MediaCodec mDecoder;
    private long mStartTimeNs;
    private volatile int mTrackIndex;
    private volatile boolean mIsRunning;
    protected boolean mOutputDone;

    protected AbstractDecoder(@NonNull String mimeType, @NonNull DecoderListener listener) {
        this.mMimeType = mimeType;
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void release() {
        this.stop();
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public int prepare(@NonNull MediaExtractor extractor) throws IllegalArgumentException {
        this.mTrackIndex = AbstractDecoder.findTrack(extractor, this.mMimeType);
        if (this.mTrackIndex < 0) {
            throw new IllegalArgumentException("Track not found for " + this.mMimeType);
        }
        extractor.selectTrack(this.mTrackIndex);
        this.mFormat = extractor.getTrackFormat(this.mTrackIndex);
        this.internalPrepare(this.mTrackIndex, this.mFormat);
        return this.mTrackIndex;
    }

    protected abstract void internalPrepare(int var1, @NonNull MediaFormat var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.mTrackIndex >= 0) {
            String mime = this.mFormat.getString("mime");
            try {
                this.mDecoder = this.createDecoder(this.mTrackIndex, this.mFormat);
                this.mOutputDone = false;
                this.mIsRunning = true;
                Thread outputThread = new Thread((Runnable)this.createOutputTask(this.mTrackIndex), TAG + "-" + this.hashCode());
                Object object = this.mSync;
                synchronized (object) {
                    outputThread.start();
                    try {
                        this.mSync.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected abstract MediaCodec createDecoder(int var1, @NonNull MediaFormat var2) throws IOException;

    protected abstract OutputTask createOutputTask(int var1);

    public abstract void decode(@NonNull MediaExtractor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.mIsRunning = false;
        Object object = this.mSync;
        synchronized (object) {
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalEndOfStream() {
        while (this.isRunning()) {
            int inputBufIndex = this.mDecoder.dequeueInputBuffer(10000L);
            if (inputBufIndex < 0) continue;
            this.mDecoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
            break;
        }
        Object object = this.mSync;
        synchronized (object) {
            this.mSync.notifyAll();
        }
    }

    protected void decodeAPI16(@NonNull MediaExtractor extractor, @NonNull MediaCodec decoder, ByteBuffer[] inputBuffers) {
        while (this.isRunning()) {
            int inputBufIndex = decoder.dequeueInputBuffer(10000L);
            if (inputBufIndex < 0) continue;
            int size = extractor.readSampleData(inputBuffers[inputBufIndex], 0);
            if (size > 0) {
                long presentationTimeUs = extractor.getSampleTime();
                decoder.queueInputBuffer(inputBufIndex, 0, size, presentationTimeUs, 0);
                break;
            }
            this.mDecoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
            break;
        }
    }

    @RequiresApi(api=21)
    protected void decodeAPI21(@NonNull MediaExtractor extractor, @NonNull MediaCodec decoder) {
        while (this.isRunning()) {
            int inputBufIndex = decoder.dequeueInputBuffer(10000L);
            if (inputBufIndex < 0) continue;
            ByteBuffer in = decoder.getInputBuffer(inputBufIndex);
            int size = extractor.readSampleData(in, 0);
            if (size > 0) {
                long presentationTimeUs = extractor.getSampleTime();
                decoder.queueInputBuffer(inputBufIndex, 0, size, presentationTimeUs, 0);
                break;
            }
            this.mDecoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
            break;
        }
    }

    protected boolean onFrameAvailable(long presentationTimeUs) {
        return false;
    }

    private static final int findTrack(@NonNull MediaExtractor extractor, @NonNull String mimeType) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!mime.startsWith(mimeType)) continue;
            return i;
        }
        return -1;
    }

    protected abstract class OutputTask
    implements Runnable {
        protected final int trackIndex;
        private static final long VSYNC2 = 33330000L;
        private long mOffsetPtsNs = -1L;
        private long mOffsetSysTimeNs = -1L;

        protected OutputTask(int trackIndex) {
            this.trackIndex = trackIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AbstractDecoder.this.mSync;
            synchronized (object) {
                AbstractDecoder.this.mSync.notify();
            }
            while (AbstractDecoder.this.mIsRunning && !AbstractDecoder.this.mOutputDone) {
                try {
                    if (AbstractDecoder.this.mOutputDone) continue;
                    this.handleOutput(AbstractDecoder.this.mDecoder);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"DecodeTask:", (Throwable)e);
                    break;
                }
            }
            object = AbstractDecoder.this.mSync;
            synchronized (object) {
                AbstractDecoder.this.mOutputDone = true;
                AbstractDecoder.this.mSync.notifyAll();
            }
        }

        protected abstract void handleOutput(@NonNull MediaCodec var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long adjustPresentationTime(long presentationTimeUs) {
            long presentationTimeNs = presentationTimeUs * 1000L;
            if (this.mOffsetSysTimeNs <= 0L) {
                this.mOffsetSysTimeNs = System.nanoTime();
                this.mOffsetPtsNs = this.mOffsetSysTimeNs - presentationTimeNs;
                return this.mOffsetSysTimeNs + 33330000L;
            }
            long base = this.mOffsetPtsNs + presentationTimeNs - 33330000L;
            long t = base - System.nanoTime();
            while (AbstractDecoder.this.isRunning() && t > 0L) {
                if (t > 20000000L) {
                    t >>= 1;
                }
                Object object = AbstractDecoder.this.mSync;
                synchronized (object) {
                    try {
                        AbstractDecoder.this.mSync.wait(t / 1000000L, (int)(t % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                t = base - System.nanoTime();
            }
            return System.nanoTime() + 33330000L;
        }
    }
}

