/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.math;

import android.opengl.Matrix;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

public class Vector
implements Parcelable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1620440892067002860L;
    public static final double TO_RADIAN = Math.PI / 180;
    public static final double TO_DEGREE = 57.29577951308232;
    public static final Vector zeroVector = new Vector();
    public static final Vector normVector = new Vector(1.0f, 1.0f, 1.0f).normalize();
    @Size(min=16L)
    @NonNull
    private static final float[] matrix = new float[16];
    private static final float[] inVec = new float[4];
    private static final float[] outVec = new float[4];
    public float x;
    public float y;
    public float z;
    public static final Parcelable.Creator<Vector> CREATOR = new Parcelable.Creator<Vector>(){

        public Vector createFromParcel(Parcel in) {
            return new Vector(in);
        }

        public Vector[] newArray(int size) {
            return new Vector[size];
        }
    };

    public Vector() {
    }

    public Vector(float x, float y) {
        this(x, y, 0.0f);
    }

    public Vector(@NonNull Vector v) {
        this(v.x, v.y, v.z);
    }

    public Vector(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    protected Vector(@NonNull Parcel in) {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
    }

    @NonNull
    public Vector clone() throws CloneNotSupportedException {
        Vector result = (Vector)super.clone();
        return result;
    }

    public Vector clear(float scalar) {
        this.y = this.z = scalar;
        this.x = this.z;
        return this;
    }

    public Vector set(float x, float y) {
        return this.set(x, y, 0.0f);
    }

    public Vector set(@NonNull Vector v) {
        if (this != v) {
            this.set(v.x, v.y, v.z);
        }
        return this;
    }

    public Vector set(@NonNull Vector v, float a) {
        return this.set(v.x, v.y, v.z, a);
    }

    public Vector set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector set(float x, float y, float z, float a) {
        this.x = x * a;
        this.y = y * a;
        this.z = z * a;
        return this;
    }

    public float x() {
        return this.x;
    }

    public Vector x(float x) {
        this.x = x;
        return this;
    }

    public float y() {
        return this.y;
    }

    public Vector y(float y) {
        this.y = y;
        return this;
    }

    public float z() {
        return this.z;
    }

    public Vector z(float z) {
        this.z = z;
        return this;
    }

    public Vector add(float x, float y) {
        return this.add(x, y, 0.0);
    }

    public Vector add(double x, double y, double z) {
        this.x = (float)((double)this.x + x);
        this.y = (float)((double)this.y + y);
        this.z = (float)((double)this.z + z);
        return this;
    }

    public Vector add(double x, double y, double z, double a) {
        this.x = (float)((double)this.x + x * a);
        this.y = (float)((double)this.y + y * a);
        this.z = (float)((double)this.z + z * a);
        return this;
    }

    public Vector add(@NonNull Vector v) {
        return this.add(v.x, v.y, v.z);
    }

    public Vector add(@NonNull Vector v, float a) {
        return this.add(v.x, v.y, v.z, a);
    }

    public static Vector add(@Nullable Vector result, @NonNull Vector v1, @NonNull Vector v2) {
        return (result != null ? result.set(v1) : new Vector(v1)).add(v2);
    }

    public Vector sub(float x, float y) {
        return this.add(-x, -y, 0.0);
    }

    public Vector sub(double x, double y) {
        return this.add(-x, -y, 0.0);
    }

    public Vector sub(@NonNull Vector v) {
        return this.add(-v.x, -v.y, -v.z);
    }

    public Vector sub(@NonNull Vector v, float a) {
        return this.add(-v.x, -v.y, -v.z, a);
    }

    public Vector sub(float x, float y, float z) {
        return this.add(-x, -y, -z);
    }

    public Vector sub(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public Vector sub(float x, float y, float z, float a) {
        return this.add(-x, -y, -z, a);
    }

    public Vector sub(double x, double y, double z, double a) {
        return this.add(-x, -y, -z, a);
    }

    public static Vector sub(@Nullable Vector result, @NonNull Vector v1, @NonNull Vector v2) {
        return (result != null ? result.set(v1) : new Vector(v1)).sub(v2);
    }

    public Vector mult(@NonNull Vector other) {
        this.x *= other.x;
        this.y *= other.y;
        this.z *= other.z;
        return this;
    }

    public Vector mult(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public Vector mult(double scale) {
        this.x = (float)((double)this.x * scale);
        this.y = (float)((double)this.y * scale);
        this.z = (float)((double)this.z * scale);
        return this;
    }

    public Vector mult(float xScale, float yScale) {
        this.x *= xScale;
        this.y *= yScale;
        return this;
    }

    public Vector mult(double xScale, double yScale) {
        this.x = (float)((double)this.x * xScale);
        this.y = (float)((double)this.y * yScale);
        return this;
    }

    public Vector mult(float xScale, float yScale, float zScale) {
        this.x *= xScale;
        this.y *= yScale;
        this.z *= zScale;
        return this;
    }

    public Vector mult(double xScale, double yScale, double zScale) {
        this.x = (float)((double)this.x * xScale);
        this.y = (float)((double)this.y * yScale);
        this.z = (float)((double)this.z * zScale);
        return this;
    }

    public Vector div(@NonNull Vector other) {
        this.x /= other.x;
        this.y /= other.y;
        this.z /= other.z;
        return this;
    }

    public Vector div(float scale) {
        this.x /= scale;
        this.y /= scale;
        this.z /= scale;
        return this;
    }

    public Vector div(double scale) {
        this.x = (float)((double)this.x / scale);
        this.y = (float)((double)this.y / scale);
        this.z = (float)((double)this.z / scale);
        return this;
    }

    public Vector div(float xDiv, float yDiv) {
        this.x /= xDiv;
        this.y /= yDiv;
        return this;
    }

    public Vector div(double xDiv, double yDiv) {
        this.x = (float)((double)this.x / xDiv);
        this.y = (float)((double)this.y / yDiv);
        return this;
    }

    public Vector div(float xDiv, float yDiv, float zDiv) {
        this.x /= xDiv;
        this.y /= yDiv;
        this.z /= zDiv;
        return this;
    }

    public Vector div(double xDiv, double yDiv, double zDiv) {
        this.x = (float)((double)this.x / xDiv);
        this.y = (float)((double)this.y / yDiv);
        this.z = (float)((double)this.z / zDiv);
        return this;
    }

    public Vector mod(float scalar) {
        this.x %= scalar;
        this.y %= scalar;
        this.z %= scalar;
        return this;
    }

    public Vector toRadian() {
        return this.mult(Math.PI / 180);
    }

    public Vector toDegree() {
        return this.mult(57.29577951308232);
    }

    public Vector limit(float scalar) {
        float limit = Math.abs(scalar);
        if (limit != 0.0f) {
            while (this.x >= limit) {
                this.x -= limit;
            }
            while (this.x <= -limit) {
                this.x += limit;
            }
            while (this.y >= limit) {
                this.y -= limit;
            }
            while (this.y <= -limit) {
                this.y += limit;
            }
            while (this.z >= limit) {
                this.z -= limit;
            }
            while (this.z <= -limit) {
                this.z += limit;
            }
        } else {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }
        return this;
    }

    public Vector limit(float lower, float upper) {
        float min = Math.min(lower, upper);
        float max = Math.max(lower, upper);
        if (max != min) {
            while (this.x >= max) {
                this.x -= max;
            }
            while (this.x <= min) {
                this.x -= min;
            }
            while (this.y >= max) {
                this.y -= max;
            }
            while (this.y <= min) {
                this.y -= min;
            }
            while (this.z >= max) {
                this.z -= max;
            }
            while (this.z <= min) {
                this.z -= min;
            }
        } else {
            this.y = this.z = min;
            this.x = this.z;
        }
        return this;
    }

    public Vector saturate(float scalar) {
        float limit = Math.abs(scalar);
        this.x = this.x >= limit ? limit : Math.max(this.x, -limit);
        this.y = this.y >= limit ? limit : Math.max(this.y, -limit);
        this.z = this.z >= limit ? limit : Math.max(this.z, -limit);
        return this;
    }

    public Vector saturate(float lower, float upper) {
        float min = Math.min(lower, upper);
        float max = Math.max(lower, upper);
        if (max != min) {
            this.x = this.x >= max ? max : Math.max(this.x, min);
            this.y = this.y >= max ? max : Math.max(this.y, min);
            this.z = this.z >= max ? max : Math.max(this.z, min);
        } else {
            this.y = this.z = min;
            this.z = this.z;
        }
        return this;
    }

    public float len2D() {
        return (float)Math.hypot(this.x, this.y);
    }

    public float len() {
        return (float)Math.sqrt(this.lenSquared());
    }

    public Vector len(float len) {
        double l = Math.sqrt(this.lenSquared());
        if (l != 0.0 && len != 0.0f) {
            return this.mult((double)len / l);
        }
        return this.clear(0.0f);
    }

    public Vector len(double len) {
        double l = Math.sqrt(this.lenSquared());
        if (l != 0.0 && len != 0.0) {
            return this.mult(len / l);
        }
        return this.clear(0.0f);
    }

    public float lenSquared() {
        return (float)((double)this.x * (double)this.x + (double)this.y * (double)this.y + (double)this.z * (double)this.z);
    }

    public Vector normalize() {
        double len = Math.sqrt(this.lenSquared());
        if (len != 0.0) {
            this.x = (float)((double)this.x / len);
            this.y = (float)((double)this.y / len);
            this.z = (float)((double)this.z / len);
        }
        return this;
    }

    public float dot2D(@NonNull Vector v) {
        return (float)((double)this.x * (double)v.x + (double)this.y * (double)v.y);
    }

    public float dotProduct2D(@NonNull Vector v) {
        return (float)((double)this.x * (double)v.x + (double)this.y * (double)v.y);
    }

    public float dot2D(float x, float y, float z) {
        return (float)((double)this.x * (double)x + (double)this.y * (double)y);
    }

    public float dotProduct2D(float x, float y, float z) {
        return (float)((double)this.x * (double)x + (double)this.y * (double)y);
    }

    public float dot(@NonNull Vector v) {
        return Vector.dot(this, v);
    }

    public float dotProduct(@NonNull Vector v) {
        return Vector.dot(this, v);
    }

    public float dot(float x, float y, float z) {
        return (float)((double)this.x * (double)x + (double)this.y * (double)y + (double)this.z * (double)z);
    }

    public float dotProduct(float x, float y, float z) {
        return (float)((double)this.x * (double)x + (double)this.y * (double)y + (double)this.z * (double)z);
    }

    public static float dot(@NonNull Vector v0, @NonNull Vector v1) {
        return (float)((double)v0.x * (double)v1.x + (double)v0.y * (double)v1.y + (double)v0.z * (double)v1.z);
    }

    public static double dotDouble(@NonNull Vector v0, @NonNull Vector v1) {
        return (double)v0.x * (double)v1.x + (double)v0.y * (double)v1.y + (double)v0.z * (double)v1.z;
    }

    public float cross2D(@NonNull Vector v) {
        return (float)((double)this.x * (double)v.y - (double)v.x * (double)this.y);
    }

    public float crossProduct2D(@NonNull Vector v) {
        return (float)((double)this.x * (double)v.y - (double)v.x * (double)this.y);
    }

    public Vector cross(@NonNull Vector v) {
        return Vector.crossProduct(this, this, v);
    }

    public Vector crossProduct(@NonNull Vector v) {
        return Vector.crossProduct(this, this, v);
    }

    public static Vector cross(@Nullable Vector result, @NonNull Vector v1, @NonNull Vector v2) {
        return Vector.crossProduct(result, v1, v2);
    }

    public static Vector crossProduct(@Nullable Vector result, @NonNull Vector v1, @NonNull Vector v2) {
        float x3 = (float)((double)v1.y * (double)v2.z - (double)v1.z * (double)v2.y);
        float y3 = (float)((double)v1.z * (double)v2.x - (double)v1.x * (double)v2.z);
        float z3 = (float)((double)v1.x * (double)v2.y - (double)v1.y * (double)v2.x);
        return result != null ? result.set(x3, y3, z3) : new Vector(x3, y3, z3);
    }

    public float angleXY() {
        float angle = (float)(Math.atan2(this.y, this.x) * 57.29577951308232);
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float angleXZ() {
        float angle = (float)(Math.atan2(this.z, this.x) * 57.29577951308232);
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float angleYZ() {
        float angle = (float)(Math.atan2(this.z, this.y) * 57.29577951308232);
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float angle(@NonNull Vector v) {
        double cos = Vector.dotDouble(this, v) / (Math.sqrt(this.lenSquared()) * Math.sqrt(v.lenSquared()));
        return (float)(Math.acos(cos) * 57.29577951308232);
    }

    public Vector rotateXY(float angle) {
        double rad = (double)angle * (Math.PI / 180);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double newX = (double)this.x * cos - (double)this.y * sin;
        double newY = (double)this.x * sin + (double)this.y * cos;
        this.x = (float)newX;
        this.y = (float)newY;
        return this;
    }

    public Vector rotateXZ(float angle) {
        double rad = (double)angle * (Math.PI / 180);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double newX = (double)this.x * cos - (double)this.z * sin;
        double newZ = (double)this.x * sin + (double)this.z * cos;
        this.x = (float)newX;
        this.z = (float)newZ;
        return this;
    }

    public Vector rotateYZ(float angle) {
        double rad = (double)angle * (Math.PI / 180);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double newY = (double)this.y * cos - (double)this.z * sin;
        double newZ = (double)this.y * sin + (double)this.z * cos;
        this.y = (float)newY;
        this.z = (float)newZ;
        return this;
    }

    public Vector rotate(float angle, float axisX, float axisY, float axisZ) {
        Vector.inVec[0] = this.x;
        Vector.inVec[1] = this.y;
        Vector.inVec[2] = this.z;
        Vector.inVec[3] = 1.0f;
        Matrix.setIdentityM((float[])matrix, (int)0);
        Matrix.rotateM((float[])matrix, (int)0, (float)angle, (float)axisX, (float)axisY, (float)axisZ);
        Matrix.multiplyMV((float[])outVec, (int)0, (float[])matrix, (int)0, (float[])inVec, (int)0);
        this.x = outVec[0];
        this.y = outVec[1];
        this.z = outVec[2];
        return this;
    }

    public Vector rotate(float angleX, float angleY, float angleZ) {
        return Vector.rotate(this, angleX, angleY, angleZ);
    }

    public static Vector rotate(@NonNull Vector result, float angleX, float angleY, float angleZ) {
        Vector.inVec[0] = result.x;
        Vector.inVec[1] = result.y;
        Vector.inVec[2] = result.z;
        Vector.inVec[3] = 1.0f;
        Matrix.setIdentityM((float[])matrix, (int)0);
        if (angleX != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (angleY != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (angleZ != 0.0f) {
            Matrix.rotateM((float[])matrix, (int)0, (float)angleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Matrix.multiplyMV((float[])outVec, (int)0, (float[])matrix, (int)0, (float[])inVec, (int)0);
        result.x = outVec[0];
        result.y = outVec[1];
        result.z = outVec[2];
        return result;
    }

    public Vector rotate(@NonNull Vector angle, float a) {
        return Vector.rotate(this, angle.x * a, angle.y * a, angle.z * a);
    }

    public Vector rotate(@NonNull Vector angle) {
        return Vector.rotate(this, angle.x, angle.y, angle.z);
    }

    public float[] getQuat(@Nullable @Size(min=4L) float[] result) {
        float[] q = result != null ? result : new float[4];
        q[0] = this.x;
        q[1] = this.y;
        q[2] = this.z;
        q[3] = 1.0f;
        return q;
    }

    public Vector setQuat(@NonNull @Size(min=4L) float[] q) {
        this.x = q[0];
        this.y = q[1];
        this.z = q[2];
        return this;
    }

    public float distance(@NonNull Vector p) {
        return this.distance(p.x, p.y, p.z);
    }

    public float distance(float px, float py) {
        return this.distance(px, py, this.z);
    }

    public float distance(float px, float py, float pz) {
        return (float)Math.sqrt(this.distSquaredDouble(px, py, pz));
    }

    public float distSquared(@NonNull Vector p) {
        return this.distSquared(p.x, p.y, p.z);
    }

    public float distSquared(float px, float py) {
        return this.distSquared(px, py, this.z);
    }

    public float distSquared(float px, float py, float pz) {
        double dx = (double)this.x - (double)px;
        double dy = (double)this.y - (double)py;
        double dz = (double)this.z - (double)pz;
        return (float)(dx * dx + dy * dy + dz * dz);
    }

    public double distSquaredDouble(float px, float py, float pz) {
        double dx = (double)this.x - (double)px;
        double dy = (double)this.y - (double)py;
        double dz = (double)this.z - (double)pz;
        return dx * dx + dy * dy + dz * dz;
    }

    public Vector swap(@NonNull Vector v) {
        float w = this.x;
        this.x = v.x;
        v.x = w;
        w = this.y;
        this.y = v.y;
        v.y = w;
        w = this.z;
        this.z = v.z;
        v.z = w;
        return this;
    }

    public Vector swapXY() {
        float w = this.x;
        this.x = this.y;
        this.y = w;
        return this;
    }

    public float slope2D(@NonNull Vector p) {
        if (p.x != this.x) {
            return (float)(((double)p.y - (double)this.y) / ((double)p.x - (double)this.x));
        }
        return p.y - this.y >= 0.0f ? Float.MAX_VALUE : Float.MIN_VALUE;
    }

    public float interceptY2D(@NonNull Vector p) {
        if (p.x != this.x) {
            double slope = ((double)p.y - (double)this.y) / ((double)p.x - (double)this.x);
            return (float)((double)this.y - slope * (double)this.x);
        }
        return Float.POSITIVE_INFINITY;
    }

    public float slope2D() {
        if (this.x != 0.0f) {
            return (float)((double)this.y / (double)this.x);
        }
        return this.y >= 0.0f ? Float.MAX_VALUE : Float.MIN_VALUE;
    }

    public Vector sign() {
        this.x = Math.signum(this.x);
        this.y = Math.signum(this.y);
        this.z = Math.signum(this.z);
        return this;
    }

    public Vector mid(@NonNull Vector p) {
        return Vector.mid(null, this, p);
    }

    public static Vector mid(@Nullable Vector result, @NonNull Vector p1, @NonNull Vector p2) {
        return Vector.add(result != null ? result : new Vector(), p1, p2).div(2.0f);
    }

    public static Vector normalVector(@Nullable Vector result, @NonNull Vector p0, @NonNull Vector p1, @NonNull Vector p2) {
        Vector v1 = Vector.sub(result, p1, p0);
        Vector v2 = new Vector(p2).sub(p0);
        return v1.mult(v1.dot(v2) / v1.lenSquared()).add(p0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector v = (Vector)o;
        return Float.compare(v.x, this.x) == 0 && Float.compare(v.y, this.y) == 0 && Float.compare(v.z, this.z) == 0;
    }

    public int hashCode() {
        return Vector.hasCode(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    private static int hasCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    @NonNull
    public String toString() {
        return String.format(Locale.US, "(%f,%f,%f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public String toString(String fmt) {
        return String.format(Locale.US, fmt, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeFloat(this.x);
        dest.writeFloat(this.y);
        dest.writeFloat(this.z);
    }
}

