/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLContext;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.glpipeline.GLPipelineSource;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.ThreadUtils;

public class VideoSourcePipeline
extends ProxyPipeline
implements GLPipelineSource {
    private static final boolean DEBUG = false;
    private static final String TAG = VideoSourcePipeline.class.getSimpleName();
    private static final int REQUEST_UPDATE_TEXTURE = 1;
    private static final int REQUEST_UPDATE_SIZE = 2;
    private static final int REQUEST_RECREATE_MASTER_SURFACE = 3;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    private final boolean mOwnManager;
    @NonNull
    private final GLContext mGLContext;
    @NonNull
    private final Handler mGLHandler;
    @NonNull
    private final GLPipelineSource.PipelineSourceCallback mCallback;
    @Size(min=16L)
    @NonNull
    private final float[] mTexMatrix = new float[16];
    private int mTexId;
    private SurfaceTexture mInputTexture;
    private Surface mInputSurface;
    private final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            if (VideoSourcePipeline.this.isValid()) {
                VideoSourcePipeline.this.mGLHandler.sendEmptyMessage(1);
            }
        }
    };

    public VideoSourcePipeline(@NonNull GLManager manager, int width, int height, @NonNull GLPipelineSource.PipelineSourceCallback callback) {
        this(manager, width, height, callback, false);
    }

    public VideoSourcePipeline(@NonNull GLManager manager, int width, int height, @NonNull GLPipelineSource.PipelineSourceCallback callback, boolean useSharedContext) {
        super(width, height);
        this.mOwnManager = useSharedContext;
        Handler.Callback handlerCallback = new Handler.Callback(){

            public boolean handleMessage(@NonNull Message msg) {
                return VideoSourcePipeline.this.handleMessage(msg);
            }
        };
        if (useSharedContext) {
            this.mManager = manager.createShared(handlerCallback);
            this.mGLHandler = this.mManager.getGLHandler();
        } else {
            this.mManager = manager;
            this.mGLHandler = manager.createGLHandler(handlerCallback);
        }
        this.mGLContext = this.mManager.getGLContext();
        this.mCallback = callback;
        this.mGLHandler.sendEmptyMessage(3);
    }

    @Override
    protected void internalRelease() {
        if (this.isValid()) {
            this.mGLHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoSourcePipeline.this.handleReleaseInputSurface();
                    if (VideoSourcePipeline.this.mOwnManager) {
                        VideoSourcePipeline.this.mManager.release();
                    }
                }
            });
        }
        super.internalRelease();
    }

    @Override
    @NonNull
    public GLManager getGLManager() throws IllegalStateException {
        this.checkValid();
        return this.mManager;
    }

    @Override
    public void resize(int width, int height) throws IllegalStateException {
        this.checkValid();
        boolean updateSize = width > 0 && height > 0 && (width != this.getWidth() || height != this.getHeight());
        super.resize(width, height);
        if (updateSize) {
            this.mGLHandler.sendMessage(this.mGLHandler.obtainMessage(2, width, height));
        }
    }

    @Override
    public boolean isValid() {
        return this.mManager.isValid() && this.mInputSurface != null && this.mInputSurface.isValid();
    }

    @Override
    @NonNull
    public SurfaceTexture getInputSurfaceTexture() throws IllegalStateException {
        this.checkValid();
        if (this.mInputTexture == null) {
            throw new IllegalStateException("has no master surface");
        }
        return this.mInputTexture;
    }

    @Override
    @NonNull
    public Surface getInputSurface() throws IllegalStateException {
        this.checkValid();
        if (this.mInputSurface == null) {
            throw new IllegalStateException("has no master surface");
        }
        return this.mInputSurface;
    }

    @Override
    public int getTexId() {
        return this.mTexId;
    }

    @Override
    @Size(min=16L)
    @NonNull
    public float[] getTexMatrix() {
        return this.mTexMatrix;
    }

    protected void checkValid() throws IllegalStateException {
        if (!this.mManager.isValid()) {
            throw new IllegalStateException("Already released");
        }
    }

    @WorkerThread
    protected boolean handleMessage(@NonNull Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleUpdateTex();
                return true;
            }
            case 2: {
                this.handleResize(msg.arg1, msg.arg2);
                return true;
            }
            case 3: {
                this.handleReCreateInputSurface();
                return true;
            }
        }
        return false;
    }

    @WorkerThread
    protected void handleUpdateTex() {
        this.makeDefault();
        GLES20.glClear((int)16384);
        GLES20.glFlush();
        if (this.mInputTexture != null) {
            this.mInputTexture.updateTexImage();
            this.mInputTexture.getTransformMatrix(this.mTexMatrix);
            GLES20.glFlush();
            ThreadUtils.NoThrowSleep(0L, 0);
            this.onFrameAvailable(true, this.mTexId, this.mTexMatrix);
        }
    }

    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void handleReCreateInputSurface() {
        this.makeDefault();
        this.handleReleaseInputSurface();
        this.makeDefault();
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.mTexId = GLUtils.initTex(36197, 33984, 9728);
        this.mInputTexture = new SurfaceTexture(this.mTexId);
        this.mInputSurface = new Surface(this.mInputTexture);
        if (BuildCheck.isAndroid4_1()) {
            this.mInputTexture.setDefaultBufferSize(this.getWidth(), this.getHeight());
        }
        if (BuildCheck.isLollipop()) {
            this.mInputTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener, this.mGLHandler);
        } else {
            this.mInputTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
        }
        this.mCallback.onCreate(this.mInputSurface);
    }

    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void handleReleaseInputSurface() {
        if (this.mInputSurface != null) {
            this.mCallback.onDestroy();
            try {
                this.mInputSurface.release();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mInputSurface = null;
        }
        if (this.mInputTexture != null) {
            try {
                this.mInputTexture.release();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mInputTexture = null;
        }
        if (this.mTexId != 0) {
            GLUtils.deleteTex(this.mTexId);
            this.mTexId = 0;
        }
    }

    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void handleResize(int width, int height) {
        if (this.mInputSurface == null || !this.mInputSurface.isValid()) {
            this.handleReCreateInputSurface();
        }
        if (BuildCheck.isAndroid4_1()) {
            this.mInputTexture.setDefaultBufferSize(width, height);
        }
    }

    @WorkerThread
    protected void makeDefault() {
        this.mGLContext.makeDefault();
    }
}

